﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 转仓记录
    /// </summary>
    public class dc_aims_transfer_warehouse_log
    {
        public int id { get; set; }
        public string bailun_sku { get; set; }
        public string from_warehouse_code { get; set; }
        public string from_warehouse_name { get; set; }
        public string to_warehouse_name { get; set; }
        public string to_warehouse_code { get; set; }
        public string create_user { get; set; }
        public DateTime create_date { get; set; }
        public int status { get; set; }
        public string error_message { get; set; }
        public string error_stack_trace { get; set; }
    }

    public class dc_aims_transfer_warehouse_log_dto: dc_aims_transfer_warehouse_log
    {
        public string status_str { get
            {
                return ((status_enum)status).ToString();
            } }
        public enum status_enum
        {
            待处理=0,
            转移最新30天销量= 1,
            刷新周转数据= 2,
            完成=3,
            失败 =-1
        }
    }

    /// <summary>
    /// 转仓操作
    /// </summary>
    public class dc_aims_transfer_warehouse_input_dto
    {
        public List<string> turnover_ids { get; set; }
        public string to_warehouse_code { get; set; }
    }

    public class dc_aims_transfer_warehouse_log_search_dto
    {
        public string bailun_sku { get; set; }
        public DateTime? start_date { get; set; }
        public DateTime? end_date { get; set; }
        public string warehousecode { get; set; }
        public string warehousetype { get; set; }
        public int? warehousearea { get; set; }
    }
}
