﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Dapper;
using AutoTurnOver.Models;

namespace AutoTurnOver.DB
{
    public class dc_base_transfer_extend_dao : connectionHelper
    {
        /// <summary>
        /// 刷新数据
        /// </summary>
        public static void ResetData()
        {
            // 查询所有当前未完成的调拨单
            var temp_trans_order_datas = _connection.Query<temp_trans_order_dto>(@"select 
t2.sku as 'bailun_sku',
t1.targetwareno as 'warehouse_code',
t1.expectarrivaltime as 'expectarrivaltime',
t1.`code` as 'order_no',
t2.deliverycount-t2.storagecount as 'count',
t1.trackingno,
t1.transporttype,
t1.logisticsname
from dc_base_transfer_info as t1
left join dc_base_transfer_info_skus as t2 on t1.dataid =t2.dataid
where t1.stateid!=5 and t1.isdeleted=0 and t2.deliverycount>t2.storagecount").ToList();
            if (temp_trans_order_datas != null && temp_trans_order_datas.Count>=1)
            {
                var db_datas = new List<dc_base_transfer_extend>();
                foreach (var item in temp_trans_order_datas.GroupBy(s => new { s.bailun_sku, s.warehouse_code }))
                {
                    var lately_item = item.OrderBy(s => s.expectarrivaltime).FirstOrDefault();
                    var lately_data = new dc_base_transfer_extend
                    {
                        bailun_sku = lately_item.bailun_sku,
                        warehouse_code = lately_item.warehouse_code,
                        bailun_sku_warehouse_code = $"{lately_item.bailun_sku}{lately_item.warehouse_code}",
                        lately_transfer_count = lately_item.count,
                        lately_transfer_expect_arrival_time = lately_item.expectarrivaltime,
                        lately_transfer_order_no = lately_item.order_no ?? "",
                        lately_transfer_trackingno = lately_item.trackingno ?? "",
                        lately_transfer_logisticsname = lately_item.logisticsname ?? "",
                        lately_transfer_transporttype = lately_item.transporttype ?? ""
                    };
                    lately_data.id = _connection.QueryFirstOrDefault<long?>(" select id from dc_base_transfer_extend where bailun_sku_warehouse_code=@bailun_sku_warehouse_code ",new {
                        bailun_sku_warehouse_code = lately_data.bailun_sku_warehouse_code
                    }) ?? 0;
                    if (lately_data.id > 0)
                    {
                        _connection.Update(lately_data);
                    }
                    else
                    {
                        _connection.Insert(lately_data);
                    }
                    db_datas.Add(lately_data);
                }
                // 清空没有在途的数据
                _connection.Execute(" delete from dc_base_transfer_extend where bailun_sku_warehouse_code not in @bailun_sku_warehouse_codes ",new {
                    bailun_sku_warehouse_codes = db_datas.Select(s=>s.bailun_sku_warehouse_code).ToList()
                });

            }
            else
            {
                _connection.Execute(" delete from dc_base_transfer_extend  ");
            }
        }

        public class temp_trans_order_dto
        {
            public string bailun_sku { get; set; }
            public string warehouse_code { get; set; }
            public DateTime? expectarrivaltime { get; set; }
            public string order_no { get; set; }
            public int count { get; set; }
            public string trackingno { get; set; }
            public string transporttype { get; set; }
            public string logisticsname { get; set; }
        }
    }
}
