﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Models.auto;
using AutoTurnOver.Models.Report;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class StorageCapacityController : Controller
    {
        #region 库容

        /// <summary>
        /// 库容列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="limit"></param>
        /// <param name="offset"></param>
        /// <returns></returns>
        [HttpGet]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【库容】->【列表】->【搜索】页面", 0)]
        public JsonResult StorageCapacityList([FromQuery]dc_base_storage_capacity_search_dto m, [FromQuery] int limit, [FromQuery] int offset)
        {
            
            var total = 0;
            var service = new Services.StorageCapacityServices();
            var list = service.StorageCapacityList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }


        /// <summary>
        /// 库容日志
        /// </summary>
        /// <param name="m"></param>
        /// <param name="limit"></param>
        /// <param name="offset"></param>
        /// <returns></returns>
        [HttpGet]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【库容】->【库容日志】->【搜索】页面", 0)]
        public JsonResult StorageCapacityLogList([FromQuery]dc_base_storage_capacity_log_search_dto m, [FromQuery] int limit, [FromQuery] int offset)
        {

            var total = 0;
            var service = new Services.StorageCapacityServices();
            var list = service.StorageCapacityLogList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }


        #endregion

        /// <summary>
        /// 导入
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        [HttpPost]
        [BrowseLog("Bailun_aims", "触发【百伦自动周转系统】->【库容管理】->【导入】操作", 1)]
        public async Task<ActionResult<RequestResultDto>> Import(IFormFile file)
        {
            try
            {
                var user = AutoUtility.GetUser();
                var dataTable = new Services.StorageCapacityServices().Import(file.OpenReadStream(), user);

                var fileName = AppContext.BaseDirectory + $@"Result\库容导入结果.csv";

                CsvFileHelper.SaveCSV(dataTable, fileName);

                var memory = new MemoryStream();
                using (var stream = new FileStream(fileName, FileMode.Open))
                {
                    stream.CopyTo(memory);
                }
                memory.Position = 0;

                var fileData = await QiNiuCloudHelper.UploadAsync(memory, $"{user.UserName}-{DateTime.Now.ToString("yyyyMMddHHmmss")}库容导入结果.csv");
                return new RequestResultDto { success = true, data = fileData };
            }
            catch (Exception ex)
            {
                return new RequestResultDto { success = false, message = ex.Message, err_data = ex.StackTrace };
            }

        }

    }
}