﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.ApiDto
{
    /// <summary>
    /// 物流方式
    /// </summary>
    public class LmsShipLogisticsDto
    {
        public string Line_Code { get; set; }
        public string Line_Name { get; set; }

        /// <summary>
        /// 最快签收时间
        /// </summary>
        public int? Fast_Aging { get; set; }
        public string Company_Code { get; set; }
        public string Company_Name { get; set; }

        /// <summary>
        /// 1-直邮 2-海外 3-头程
        /// </summary>
        public string Start_Point { get; set; }

        /// <summary>
        /// 运输方式  0-不限 1-陆运 2-空运 3-海运
        /// </summary>
        public int? TransportType { get; set; }

        /// <summary>
        /// 最低运费单价
        /// </summary>
        public decimal? min_freight_unit_price { get; set; }
        public decimal? min_freight_unit_weight { get; set; }
    }

    public class LmsResultDto<T>
    {
        public bool Success { get; set; }
        public string ErrorMessage { get; set; }

        public T Data { get; set; }
    }

    public class LmsShipLogisticsRequstDto
    {
        public string RecordStatus { get; set; } = ""; public string startPoint { get; set; } = ""; public string platform { get; set; } = ""; public string Line_Code { get; set; } = "";
        public string country_code { get; set; } = "";
        public int transport_type { get; set; } = 0;
        public string endCountries { get; set; } = "";
        public string character_skus { get; set; } = "";
        public bool has_min_freight_unit_price { get; set; } = false;
        public int has_history_order { get; set; } = 0;
    }
}
