﻿using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.DB
{
    /// <summary>
    /// pps 跟卖商品
    /// </summary>
    public class dc_base_pps_sell_product_dao : connectionHelper
    {
        /// <summary>
        /// 同步数据
        /// </summary>
        public static void SyncData()
        {
            try
            {
                int page = 1;
                int rows = 100;
                // 清理数据重抓
                _connection.Execute(" TRUNCATE table dc_base_pps_sell_product; ");
                while (true)
                {
                    var datas = ApiUtility.GetPPSSellProduct(page, rows);
                    page++;
                    if (datas != null && datas.Count >= 1)
                    {
                        foreach (var item in datas)
                        {
                            dc_base_pps_sell_product dbData = new dc_base_pps_sell_product();
                            dbData.pro_code = item.proCode ?? "";
                            dbData.sku_code = item.skuCode ?? "";
                            dbData.platform_sku = item.platformSku ?? "";
                            dbData.item_id = item.itemId ?? "";
                            dbData.productId = item.productId;
                            dbData.platform = "walmart";
                            dbData.warehouse_code = "GZBLWH";
                            _connection.Insert(dbData);
                        }
                    }
                    else
                    {
                        break;
                    }
                }

            }
            catch (Exception)
            {
                Console.WriteLine("拉取pps数据异常");
            }
          
        }
    }
}
