﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    [NoLogin]
    public class ApiController : ControllerBase
    {
        [HttpPost("GetOutStockPage")]
        public ActionResult<RequestResultDto> GetOutStockPage([FromBody] dc_quantity_out_stock_search_dto search)
        {
            return new RequestResultDto { success = true, data = ApiServices.GetOutStockPage(search) };
        }

        /// <summary>
        /// 获取oms 订单数据
        /// </summary>
        /// <param name="search"></param>
        /// <returns></returns>
        [HttpPost("GetOmsSkuFullPage")]
        public  async Task<ActionResult<RequestResultDto>> GetOmsSkuFullPage([FromBody] dc_base_oms_sku_full_search_dto search)
        {
            return new RequestResultDto { success = true, data = await ApiServices.GetOmsSkuFullPage(search) };
        }

        

        [HttpPost("Buys")]
        public JsonResult Buys([FromBody]AverageQueryDto queryDto)
        {
            try
            {
                return new JsonResult(new
                {
                    data = PurchaseAverageTargetServices.GetList(queryDto.sids, queryDto.skus),
                    success = true,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false,
                });
            }
        }
    }
}