﻿using AutoTurnOver.DB;
using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Services
{
    public class JitTagServices
    {
        #region 安全库存规则配置

        /// <summary>
        /// 获取安全库存规则设置分页列表
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public List<dc_auto_jit_tag_dto> JitTagList(int group_id,int offset, int limit, ref int total)
        {
            return DB.dc_auto_jit_tag_dao.JitTagList(group_id,offset, limit, ref total);
        }

        public List<dc_auto_jit_tag_log_dto> JitTagLogList(dc_auto_jit_tag_log_search_dto data, int offset, int limit, ref int total)
        {
            return DB.dc_auto_jit_tag_dao.JitTagLogList(data,offset, limit, ref total);
        }

        public List<dc_auto_jit_tag> All()
        {
            return DB.dc_auto_jit_tag_dao.All();
        }


        public string SaveJitTag(dc_auto_jit_tag m, string username)
        {
            return DB.dc_auto_jit_tag_dao.SaveJitTag(m, username);
        }



        public dc_auto_jit_tag GetJitTagById(int id)
        {
            return DB.dc_auto_jit_tag_dao.GetJitTagById(id);
        }

        #endregion
    }
}
