﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Bailun.DC.Services;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class AllotController :Controller
    {
        public IActionResult ListAllot()
        {
            return View();
        }
        [BrowseLog("Bailun_data", "访问【百伦数据中心】->【订单】->【调拨单(调拨在途明细】->【查询】页面", 0)]
        public string ListAllotJson(BtTableParameter parameter, string warehouse, int? status, string orderno, string sku)
        {
            var total = 0;

            var service = new Services.AllotServices();
            var obj = service.ListAllot(parameter, warehouse, status, orderno, sku, ref total);
            var countM = service.ListAllotCount(warehouse, status, orderno, sku);
            countM.sku_title_cn = "总计：";

            foreach (var item in obj)
            {
                item.update_time = item.create_time;
            }

            var list = obj.Select(p => new {
                allottype = p.allottype==1?"采购调拨": "成品调拨",
                p.arrivalcount,
                p.bailun_sku,
                p.category_name,
                p.character,
                p.color,
                p.count,
                create_time = p.create_time.ToString("yyyy-MM-dd HH:mm:ss"),
                gmt_modified = p.gmt_modified.ToString("yyyy-MM-dd HH:mm:ss"),
                p.losscount,
                p.noarrivalcount,
                p.putcount,
                p.sku_image,
                p.sku_title_cn,
                p.sku_title_en,
                status = Enum.GetName(typeof(Models.Allot.EnumAllotStatus),p.status),
                p.transfer_order_id,
                update_time = p.update_time.ToString("yyyy-MM-dd HH:mm:ss"),
                p.warehouse_from_name,
                p.warehouse_to_name
            });
            
            return JsonConvert.SerializeObject(new { total = total, rows = list,count_row=countM });
        }
    }
}