﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Bailun.DC.Models.DataWareHouse;
using Bailun.DC.Common;
using Dapper;
using System.Linq;

namespace Bailun.DC.Services.DataWareHouse
{
    public class PlatformOrderFeeServices
    {
        #region 配置保存

        //需要存的费用字段

        /// <summary>
        /// 保存需要解析的字段配置
        /// </summary>
        /// <param name="cols"></param>
        /// <returns></returns>
        public string SaveOrderFeeCol(List<order_fee_col> cols)
        {
            if (cols.Count == 0)
            {
                return "没有可保存的字段配置";
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                foreach(var item in cols)
                {
                    var m = cn.QueryFirstOrDefault<order_fee_col>($"select * from order_fee_col where platform='{item.platform}' and website='{item.website}'");

                    if (m == null)
                    {
                        cn.Insert(item);
                    }
                    else
                    {
                        m.cols = item.cols;
                        cn.Update(m);
                    }

                }

            }

            return "";
        }

        /// <summary>
        /// 保存平台+站点的不同费用类型的取值条件和会计科目
        /// </summary>
        /// <param name="configs"></param>
        /// <returns></returns>
        public string SaveOrderFeeConfig(List<order_fee_config> configs)
        {
            if(configs.Count==0)
            {
                return "至少需要有一个配置。";
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                cn.Execute($"update order_fee_config set delstatus=1 where platform='{configs.FirstOrDefault().platform}' and website='{configs.FirstOrDefault().website}'");

                foreach (var item in configs)
                {
                    cn.Insert(item);
                }

            }

            return "";
        }

        #endregion

        public List<order_fee_col> ListOrderFeeCol()
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                return cn.Query<order_fee_col>("select * from order_fee_col").ToList();

            }
        }

        /// <summary>
        /// 获取财务会计流水明细
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="orderno"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public List<order_fee_value_amazon> ListOrderFeeValue(int page, int pagesize, string platform, string website, DateTime? start, DateTime? end, string orderno,ref int total)
        {
            var sql = $@"select t1.* from order_fee_value_amazon t1
                        where amountval!=0 ";
            var sqlparam = new DynamicParameters();

            if (!string.IsNullOrEmpty(platform))
            {
                sql += " and t1.platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and t1.website=@website";
                sqlparam.Add("website", website);
            }

            //if(!string.IsNullOrEmpty(month))
            //{
            //    sql += " and t1.month=@month";
            //    sqlparam.Add("month", month);
            //}

            if (!string.IsNullOrEmpty(orderno))
            {
                sql += " and t1.orderno=@orderno";
                sqlparam.Add("orderno", orderno);
            }

            if (start.HasValue)
            {
                sql += $" and t1.datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }

            if (end.HasValue)
            {
                sql += $" and t1.datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var list = new List<order_fee_value_amazon>();

                if (pagesize > 0)
                {
                    list = cn.Page<order_fee_value_amazon>(page, pagesize, sql, ref total, sqlparam).ToList();
                }
                else
                {
                    list = cn.Query<order_fee_value_amazon>(sql, sqlparam).ToList();
                }

                var config = cn.Query<order_fee_config>($"select * from order_fee_config where id in ('{string.Join("','", list.Select(a => a.order_fee_config_id).Distinct().ToList())}')");
                foreach (var item in list)
                {
                    item.fee_config = config.Where(a => a.id == item.order_fee_config_id).FirstOrDefault();
                }

                return list;
            }
        }


    }
}
