﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Allot
{
    /// <summary>
    /// 调拨单
    /// </summary>
    public class mAllotOrder
    {
        /// <summary>
        /// 调拨单号
        /// </summary>
        public string transfer_order_id { get; set; }

        /// <summary>
        /// 调拨状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 主图
        /// </summary>
        public string sku_image { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string category_name { get; set;}

        /// <summary>
        /// 英文标题
        /// </summary>
        public string sku_title_en { get; set; }

        /// <summary>
        /// 中文标题
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 颜色
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 特征
        /// </summary>
        public string character { get; set; }

        /// <summary>
        /// 起始仓名称
        /// </summary>
        public string warehouse_from_name { get; set; }

        /// <summary>
        /// 目标仓名称
        /// </summary>
        public string warehouse_to_name { get; set; }

        /// <summary>
        /// 调拨类型
        /// </summary>
        public int allottype { get; set; }

        /// <summary>
        /// 调拨数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// 已到货数量
        /// </summary>
        public int arrivalcount { get; set; }

        /// <summary>
        /// 未到货数量
        /// </summary>
        public int noarrivalcount { get; set; }

        /// <summary>
        /// 缺失数量
        /// </summary>
        public int losscount { get; set; }

        /// <summary>
        /// 入库数量
        /// </summary>
        public int putcount { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime update_time { get; set; }

        /// <summary>
        /// 同步时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

    }

    public enum EnumAllotStatus {
        打包 = 1,
        交运 = 2,
        确认交运 = 3,
        运输中 = 4,
        入库 = 5,
        完成 = 6
    }
}
