﻿using Newtonsoft.Json;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Common
{
    public class RedisHelper
    {
        public static string RedisServiceAddr = "localhost:6379";

        public static ConnectionMultiplexer Redis { get; set; }

        static RedisHelper()
        {
            Redis = ConnectionMultiplexer.Connect(RedisServiceAddr);
        }
        /// <summary>
        /// 获取缓存
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetString(string key)
        {
            using (var conn = ConnectionMultiplexer.Connect(RedisServiceAddr))
            {
                var db = conn.GetDatabase();
                return db.StringGet(key);
            }
        }
        /// <summary>
        /// 获取缓存（序列化）
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="key"></param>
        /// <returns></returns>
        public static List<T> GetList<T>(string key)
        {
            using (var conn = ConnectionMultiplexer.Connect(RedisServiceAddr))
            {
                var db = conn.GetDatabase();
                var value = db.StringGet(key);
                return value.HasValue ? JsonConvert.DeserializeObject<List<T>>(value) : new List<T>();
            }
        }
        /// <summary>
        /// 添加 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="key"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool Add<T>(string key, T value)
        {
            using (var conn = ConnectionMultiplexer.Connect(RedisServiceAddr))
            {
                var db = conn.GetDatabase();
                return db.StringSet(key, JsonConvert.SerializeObject(value));
            }
        }
        /// <summary>
        /// 添加（带过期时间）
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="key"></param>
        /// <param name="value"></param>
        /// <param name="expire"></param>
        /// <returns></returns>
        public static bool Add<T>(string key, T value, TimeSpan expire)
        {
            using (var conn = ConnectionMultiplexer.Connect(RedisServiceAddr))
            {
                var db = conn.GetDatabase();
                return db.StringSet(key, JsonConvert.SerializeObject(value), expire);
            }
        }
    }
}
