﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Bailun.DC.Services;
using Newtonsoft.Json;
using Microsoft.AspNetCore.Hosting;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class SkuController : Base.BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;
        public SkuController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// Sku列表
        /// </summary>
        /// <returns></returns>
        public ActionResult ListSku()
        {
            return View();
        }

        /// <summary>
        /// sku列表
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="sku"></param>
        /// <param name="skuname"></param>
        /// <returns></returns>
        public string ListSkuJson(BtTableParameter parameter,string sku,string skuname)
        {
            var total = 0;
            var services = new Services.SkuInfoServices();
            var obj = services.ListSku(parameter,sku,skuname,ref total);

            var countM = services.ListSkuCount(sku, skuname);

            countM.sku_title_cn = "总计：";
            countM.amount_onedaysale = Math.Round(countM.amount_onedaysale ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.amount_stock = Math.Round(countM.amount_stock ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.amount_transit = Math.Round(countM.amount_transit ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.purchase_amount = Math.Round(countM.purchase_amount ?? 0, 2, MidpointRounding.AwayFromZero);

            var list = obj.Select(p => new {
                amount_onedaysale = p.amount_onedaysale??0,
                amount_stock = p.amount_stock??0,
                amount_transit = p.amount_transit??0,
                p.bailun_sku,
                p.category_name,
                fourteenday_total_sales = p.fourteenday_total_sales??0,
                noshippingcount = p.noshippingcount??0,
                nostockcount = p.nostockcount??0,
                oneday_total_sales = p.oneday_total_sales??0,
                purchase_amount = p.purchase_amount??0,
                quantity_purchase = p.quantity_purchase??0,
                quantity_transfer = p.quantity_transfer??0,
                sevenday_total_sales = p.sevenday_total_sales??0,
                p.sku_image,
                p.sku_title_cn,
                p.sku_title_en,
                thirtyday_total_sales = p.thirtyday_total_sales??0,
                usable_stock = p.usable_stock??0,
            });


            return JsonConvert.SerializeObject(new { total = total, rows = list, count_row=countM });
        }

        public ActionResult ListSkuDiffWeigh()
        {
            return View();
        }

        /// <summary>
        /// sku发货重量差异表
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="sku">sku编码</param>
        /// <param name="shipstart">发货开始时间</param>
        /// <param name="shipend">发货结束时间</param>
        /// <param name="min">差异开始值</param>
        /// <param name="max">差异结束值</param>
        /// <returns></returns>
        public string ListSkuDiffWeighJson(BtTableParameter parameter, string sku, DateTime? shipstart, DateTime? shipend, int? min, int? max)
        {
            var total = 0;
            var obj = new Services.OrdersServices().ListWeighDiff(parameter, shipstart, shipend, min, max, sku, ref total).Select(a=>new {
                a.bailun_sku,
                a.bailun_sku_outbound_weight,
                day = a.day.ToString("yyyy-MM-dd"),
                a.diffweigh,
                a.pick_order_id,
                a.weight
            });

            return JsonConvert.SerializeObject(new { total = total, rows = obj });
        }

        /// <summary>
        /// 导出Sku发货重量差异明细
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="shipstart"></param>
        /// <param name="shipend"></param>
        /// <param name="min"></param>
        /// <param name="max"></param>
        /// <returns></returns>
        public ActionResult ExportSkuDiffWeigh(string sku, DateTime? shipstart, DateTime? shipend, int? min, int? max)
        {
            var obj = new Services.OrdersServices().ListWeighDiff(shipstart, shipend, min, max, sku);

            var colNames = new List<string> {"日期","配货单号","sku","sku重量", "发货重量", "重量差异值"};

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.day.ToString("yyyy-MM-dd") + "|" + item.pick_order_id + "|" + item.bailun_sku + "|" + item.weight + "|" + item.bailun_sku_outbound_weight + "|" +
                    item.diffweigh
                    );
            }

            var guid = Guid.NewGuid().ToString();
            var filename = "sku发货重量差异 " + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");
        }

    }
}