﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Bailun.DC.Services;
using Newtonsoft.Json;
using Microsoft.AspNetCore.Hosting;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class WarehouseController : Base.BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public WarehouseController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// 逻辑仓库 库存
        /// </summary>
        /// <returns></returns>
        public ActionResult LogicWarehouse()
        {
            return View();
        }

        /// <summary>
        /// 逻辑仓库 库存列表
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="warehousetype">仓库类型</param>
        /// <param name="warehouse">仓库编码</param>
        /// <returns></returns>
        public string LogicWarehouseJson(BtTableParameter parameter,string warehousetype,string warehousecode)
        {
            var service = new Services.WareHouseServices();
            var total = 0;
            var obj = service.ListLogicWarehouseStock(parameter, warehousetype, warehousecode, ref total);

            var countM = service.LogicWarehouseStockCount(warehousetype, warehousecode);

            countM.warehouse_name = "总计";
            countM.amount_onedaysale = Math.Round(countM.amount_onedaysale??0, 2, MidpointRounding.AwayFromZero);
            countM.amount_stock = Math.Round(countM.amount_stock , 2, MidpointRounding.AwayFromZero);
            countM.amount_transit = Math.Round(countM.amount_transit??0, 2, MidpointRounding.AwayFromZero);
            countM.purchase_amount = Math.Round(countM.purchase_amount ?? 0, 2, MidpointRounding.AwayFromZero);

            var list = obj.Select(p => new {
                amount_onedaysale = (p.amount_onedaysale??0).ToString("N2"),
                amount_stock = p.amount_stock.ToString("N2"),
                amount_transit = (p.amount_transit??0.00M).ToString("N2"),
                fourteenday_total_sales = (p.fourteenday_total_sales??0).ToString("N0"),
                noshippingcount = (p.noshippingcount??0).ToString("N0"),
                nostockcount = (p.nostockcount??0).ToString("N0"),
                oneday_total_sales = (p.oneday_total_sales??0).ToString("N0"),
                purchase_amount = (p.purchase_amount??0).ToString("N2"),
                quantity_purchase = (p.quantity_purchase??0).ToString("N0"),
                quantity_transfer = (p.quantity_transfer??0).ToString("N0"),
                sevenday_total_sales = (p.sevenday_total_sales??0).ToString("N0"),
                thirtyday_total_sales = (p.thirtyday_total_sales??0).ToString("N0"),
                usable_stock = p.usable_stock.ToString("N0"),
                p.warehouse_code,
                p.warehouse_name,
            });
            
            return JsonConvert.SerializeObject(new { total = total, rows = list, count_row = new {
                countM.warehouse_name,
                amount_onedaysale = (countM.amount_onedaysale??0).ToString("N2"),
                amount_stock = countM.amount_stock.ToString("N2"),
                amount_transit = (countM.amount_transit??0).ToString("N2"),
                noshippingcount = (countM.noshippingcount??0).ToString("N0"),
                nostockcount = (countM.nostockcount??0).ToString("N0"),
                oneday_total_sales = (countM.oneday_total_sales??0).ToString("N0"),
                purchase_amount = (countM.purchase_amount??0).ToString("N2"),
                quantity_purchase = (countM.quantity_purchase??0).ToString("N0"),
                quantity_transfer = (countM.quantity_transfer??0).ToString("N0"),
                sevenday_total_sales = (countM.sevenday_total_sales??0).ToString("N0"),
                thirtyday_total_sales = (countM.thirtyday_total_sales??0).ToString("N0"),
                usable_stock = countM.usable_stock.ToString("N0"),
                fourteenday_total_sales = (countM.fourteenday_total_sales??0).ToString("N0")
            } }); 
        }

        /// <summary>
        /// Sku仓库
        /// </summary>
        /// <param name="code">仓库编码</param>
        /// <returns></returns>
        public ActionResult ListWareHouseSku(string code)
        {
            ViewBag.warehousecode = code;
            return View();
        }

        /// <summary>
        /// Sku仓库
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="code">仓库编码</param>
        /// <param name="categoryid">sku分类id</param>
        /// <param name="minordercount">14日均销量 最小值</param>
        /// <param name="maxordercount">14日均销量 最大值</param>
        /// <param name="stockmin">库存 最小值</param>
        /// <param name="stockmax">库存 最大值</param>
        /// <param name="stockamountmin">库存金额 最小值</param>
        /// <param name="stockamountmax">库存金额 最大值</param>
        /// <returns></returns>
        public string ListWareHouseSkuJson(BtTableParameter parameter, string code, int? push_status, int? minordercount, int? maxordercount, int? stockmin, int? stockmax, decimal? stockamountmin, decimal? stockamountmax,string skucategoryids)
        {
            var total = 0;
            var obj = new Services.WareHouseServices().ListWareHouseSku(parameter, code, null, minordercount, maxordercount, stockmin, stockmax, stockamountmin, stockamountmax, skucategoryids, push_status, ref total);

            var list = obj.Select(p => new {
                amount_onedaysale = p.amount_onedaysale??0,
                amount_stock = p.amount_stock??0,
                amount_transit = p.amount_transit??0,
                p.bailun_sku,
                p.category_name,
                noshippingcount = p.noshippingcount??0,
                nostockcount = p.nostockcount??0,
                oneday_total_sales = p.oneday_total_sales??0,
                purchase_amount = p.purchase_amount??0,
                quantity_purchase = p.quantity_purchase??0,
                quantity_transfer = p.quantity_transfer??0,
                sevenday_total_sales = p.sevenday_total_sales??0,

                push_status = p.push_status==1?"是":"否",
                p.sku_image,
                p.sku_title_cn,
                p.sku_title_en,
                thirtyday_total_sales = p.thirtyday_total_sales??0,
                usable_stock = p.usable_stock??0,
                p.warehouse_code,
                p.warehouse_name,
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }


        /// <summary>
        /// 仓库冗余报告分析
        /// </summary>
        /// <returns></returns>
        public ActionResult WarehouseRedundancy()
        {
            return View();
        }

        /// <summary>
        /// 仓库冗余报告分析数据
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="warehousetype">仓库类型</param>
        /// <param name="code">仓库编码</param>
        /// <returns></returns>
        public string WarehouseRedundancyJson(BtTableParameter parameter, string warehousetype, string code,DateTime? day)
        {
            var total = 0;
            var services = new Services.WareHouseServices();
            var obj = services.ListWarehouseRedundancy(parameter, warehousetype, code,day, ref total);

            var count_obj = services.ListWarehouseRedundancyCount(warehousetype, code,day);
            
            var list = obj.Select(a => new {
                a.warehouse_code,
                a.warehouse_name,
                amount_total = (a.amount_total??0).ToString("N2"),
                dailysale_amount = (a.dailysale_amount??0).ToString("N2"),
                daily_productsale_count = (a.daily_productsale_count??0),
                day = a.day.ToString("yyyy-MM-dd"),
                productcount = (a.productcount??0).ToString("N0"),
                productsale_rate = ((a.productsale_rate??0)*100).ToString("N4"),
                redundancy_amount = (a.redundancy_amount??0).ToString("N2"),
                redundancy_amount_rate = ((a.redundancy_amount_rate??0)*100).ToString("N4"),
                redundancy_product_count = (a.redundancy_product_count??0).ToString("N0"),
                redundancy_product_rate = ((a.redundancy_product_rate??0)*100).ToString("N4"),
                redundancy_sku_count = (a.redundancy_sku_count??0).ToString("N0"),
                redundancy_sku_rate = ((a.redundancy_sku_rate??0)*100).ToString("N4"),
                saleamount_rate = ((a.saleamount_rate??0)*100).ToString("N4"),
                skucount = (a.skucount??0).ToString("N0"),
                skusales_count = (a.skusales_count??0).ToString("N2"),
                skusales_rate = ((a.skusales_rate??0)*100).ToString("N4"),
                onway_count = a.onway_count.ToString("N0"),
            });

            return JsonConvert.SerializeObject(new {
                total = total,
                rows = list,
                count_row = new {
                    warehouse_name = "合计",
                    amount_total = (count_obj.amount_total ?? 0).ToString("N2"),
                    dailysale_amount = (count_obj.dailysale_amount ?? 0).ToString("N2"),
                    daily_productsale_count = (count_obj.daily_productsale_count ?? 0).ToString("N2"),
                    //day = a.day.ToString("yyyy-MM-dd"),
                    productcount = (count_obj.productcount ?? 0).ToString("N0"),
                    productsale_rate = ((count_obj.productsale_rate ?? 0) * 100).ToString("N4"),
                    redundancy_amount = (count_obj.redundancy_amount ?? 0).ToString("N2"),
                    redundancy_amount_rate = ((count_obj.redundancy_amount_rate ?? 0) * 100).ToString("N4"),
                    redundancy_product_count = (count_obj.redundancy_product_count ?? 0).ToString("N0"),
                    redundancy_product_rate = ((count_obj.redundancy_product_rate ?? 0) * 100).ToString("N4"),
                    redundancy_sku_count = (count_obj.redundancy_sku_count ?? 0).ToString("N0"),
                    redundancy_sku_rate = ((count_obj.redundancy_sku_rate ?? 0) * 100).ToString("N4"),
                    saleamount_rate = ((count_obj.saleamount_rate ?? 0) * 100).ToString("N4"),
                    skucount = (count_obj.skucount ?? 0).ToString("N0"),
                    skusales_count = (count_obj.skusales_count ?? 0).ToString("N2"),
                    skusales_rate = ((count_obj.skusales_rate ?? 0) * 100).ToString("N4"),
                    onway_count = count_obj.onway_count.ToString("N0"),
                }
            });
        }


        /// <summary>
        /// 仓库sku库存冗余分析
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public ActionResult SkuRedundancy(string warehousecode,DateTime? day,string warehousename)
        {
            ViewBag.warehousecode = warehousecode;
            ViewBag.day = day.HasValue ? day.Value.ToString("yyyy-MM-dd") : "";
            ViewBag.warehousename = warehousename;
            return View();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SkuRedundancyJson(string warehousecode,DateTime day,int? t)
        {
            var services = new Services.WareHouseServices();
            if (t.HasValue)
            {
                var obj = services.GetSkuRedundancyByType(warehousecode, day, t);

                foreach (var item in obj)
                {
                    item.productsale_rate = item.productsale_rate * 100;
                    item.saleamount_rate = item.saleamount_rate * 100;
                    item.redundancy_product_rate = item.redundancy_product_rate * 100;
                    item.redundancy_amount_rate = item.redundancy_amount_rate * 100;

                    item.day_turnover_rate = item.day_turnover_rate * 100;
                    item.week_turnover_rate = item.week_turnover_rate * 100;
                    item.month_turnover_rate = item.month_turnover_rate * 100;

                }

                return Json(obj);
            }
            else
            {
                var obj = services.GetSkuRedundancy(warehousecode, day);
                return Json(obj);
            }
        }

        /// <summary>
        /// 导出sku冗余报表
        /// </summary>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="day">统计日期</param>
        /// <param name="t">类型</param>
        /// <returns></returns>
        public ActionResult ExportSkuRedundancy(string warehousecode, DateTime day, int? t)
        {
            var services = new Services.WareHouseServices();
            if (t.HasValue)
            {
                var obj = services.GetSkuRedundancyByType(warehousecode, day, t);

                foreach (var item in obj)
                {
                    item.productsale_rate = item.productsale_rate * 100;
                    item.saleamount_rate = item.saleamount_rate * 100;
                    item.redundancy_product_rate = item.redundancy_product_rate * 100;
                    item.redundancy_amount_rate = item.redundancy_amount_rate * 100;

                    item.day_turnover_rate = item.day_turnover_rate * 100;
                    item.week_turnover_rate = item.week_turnover_rate * 100;
                    item.month_turnover_rate = item.month_turnover_rate * 100;

                }

                var listCol = new List<string> { "sku", "产品编码", "sku标题", "产品个数", "在途数", "库存总金额", "日销产品个数", "动销产品比例", "日销金额", "动销金额比例", "冗余产品个数", "冗余个数比例", "冗余金额", "冗余金额比例","监控状态","是否侵权" };

                if (t.Value > 1)
                {
                    listCol = new List<string> { "sku", "产品编码", "sku标题", "产品个数", "在途数", "库存总金额", "昨日销量", "昨日销售金额", "过去3天日均", "过去7天日均", "过去14天日均", "过去30天日均", "日周转率", "周周转率", "月周转率", "缺货数", "监控状态", "是否侵权" };
                }

                var list = new List<string>();

                if (t.Value <= 1)
                {
                    var s = "";
                    foreach (var item in obj)
                    {
                        s = item.bailun_sku + "|" + item.sku_product_code + "|" + item.bailun_sku_name + "|" + item.productcount + "|" + item.onway_count + "|" + item.amount_total + "|" + item.daily_productsale_count + "|" + item.productsale_rate + "|" + item.dailysale_amount + "|" + item.saleamount_rate + "|" + item.redundancy_product_count + "|" + item.redundancy_product_rate + "|" + item.redundancy_amount + "|" + item.redundancy_amount_rate+"|"+(item.monitorstatus==0?"正在监控":"停止监控")+"|"+(item.tortstatus==1?"已侵权":"未侵权");
                        list.Add(s);
                    }
                }
                else if (t.Value > 1)
                {
                    var s = "";
                    foreach (var item in obj)
                    {
                        s = item.bailun_sku + "|" + item.sku_product_code + "|" + item.bailun_sku_name + "|" + item.productcount + "|" + item.onway_count + "|" + item.amount_total + "|" + item.yesterdaysale_count + "|" + item.yesterdaysale_amount + "|" + item.sale_3d_avg + "|" + item.sale_7d_avg + "|" + item.sale_14d_avg + "|" + item.sale_30d_avg + "|" + item.day_turnover_rate + "|" + item.week_turnover_rate + "|" + item.month_turnover_rate + "|" + item.stockout + "|" + (item.monitorstatus == 0 ? "正在监控" : "停止监控") + "|" + (item.tortstatus == 1 ? "已侵权" : "未侵权");
                        list.Add(s);
                    }
                }

                var title = "";

                switch (t.Value)
                {
                    case 0:
                        title = "前100冗余金额sku分析";
                        break;
                    case 1:
                        title = "前100冗余个数sku分析";
                        break;
                    case 2:
                        title = "前100个数动销最快sku分析";
                        break;
                    case 3:
                        title = "前100金额动销最快sku分析";
                        break;
                }

                var filename = title +" "+ DateTime.Now.ToString("yyyyMMddHHmmss");
                var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
                ToCSV(list, listCol, filename, filepath);

                return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
            }

            return View("");
        }

        /// <summary>
        /// 仓库历史冗余图表展示
        /// </summary>
        /// <returns></returns>
        public ActionResult WHRedundancyChart(string warehousecode,DateTime day,string col,string colname,string warehousename)
        {

            ViewBag.warehousecode = warehousecode;
            ViewBag.day = day.ToString("yyyy-MM-dd");
            ViewBag.col = col;
            ViewBag.colname = colname;
            ViewBag.warehousename = warehousename;
            return View();
        }

        /// <summary>
        /// 获取过去两个月的历史数据
        /// </summary>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="day">结束日期</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult WHRedundancyChartJson(string warehousecode, DateTime day,string col)
        {
            var startDay = day.AddDays(-60);

            var obj = new Services.WareHouseServices().ListOver60DaysWarehouseRedundancy(warehousecode, startDay, day);

            var colname = new List<string>();
            var colval = new List<decimal>();

            for (var i = 0; i < 61; i++)
            {
                var item = obj.Where(a => a.day == startDay.AddDays(i)).FirstOrDefault();
                colname.Add(startDay.AddDays(i).ToString("MM-dd"));

                if (item == null)
                {
                    colval.Add(0);
                }
                else
                {
                    var propertys = item.GetType().GetProperties();
                    foreach (var a in propertys)
                    {
                        if (a.Name == col)
                        {
                            var value = a.GetValue(item, null);
                            try
                            {
                                var b = decimal.Parse(value.ToString());

                                if (a.Name.IndexOf("比例") > 0)
                                {
                                    b *= 100;
                                }

                                colval.Add(b);
                            }
                            catch
                            {
                                colval.Add(0);
                            }

                            break;
                        }
                    }
                }
            }

            return Json(new {
                col = colname,
                val = colval
            });
        }
    }
}