﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using Bailun.DC.Models;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class FinanceController : Base.BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public FinanceController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        public IActionResult Index()
        {
            return View();
        }

        public ActionResult Index2()
        {

            return View();
        }

        /// <summary>
        /// 获取资产负债表数据
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult IndexJson(int type, DateTime day, int paycompanyvalue)
        {
            var date = day;

            var list = new Services.FinanceReportServices().GetBalanceSheet(type, date, paycompanyvalue);

            foreach (var m in list)
            {
                m.cl_count = m.cl_count ?? 0;
                m.cl_dividends_payable = m.cl_dividends_payable ?? 0;
                m.cl_notes_payable = m.cl_notes_payable ?? 0;
                m.cl_oneyear_noncurrent_liabilities = m.cl_oneyear_noncurrent_liabilities ?? 0;
                m.cl_other_liabilities = m.cl_other_liabilities ?? 0;
                m.cl_payable_interest = m.cl_payable_interest ?? 0;
                m.cl_trading_financ_liabilities = m.cl_trading_financ_liabilities ?? 0;
                m.count_assets = m.count_assets ?? 0;
                m.count_liabilities = m.count_liabilities ?? 0;
                m.count_liabilities_and_oe = m.count_liabilities_and_oe ?? 0;
                m.fa_bill_receivable = m.fa_bill_receivable ?? 0;

                m.fa_count = m.fa_count ?? 0;
                m.fa_dividends_receivable = m.fa_dividends_receivable ?? 0;
                m.fa_interest_receivable = m.fa_interest_receivable ?? 0;
                m.fa_oneyear_noncurrent_assets = m.fa_oneyear_noncurrent_assets ?? 0;
                m.fa_other_assets = m.fa_other_assets ?? 0;
                m.fa_trading_finan_asset = m.fa_trading_finan_asset ?? 0;
                m.nca_avai_for_sale_fassets = m.nca_avai_for_sale_fassets ?? 0;
                m.nca_construction_in_process = m.nca_construction_in_process ?? 0;
                m.nca_count = m.nca_count ?? 0;
                m.nca_deferred_tax_assets = m.nca_deferred_tax_assets ?? 0;
                m.nca_development_expenditure = m.nca_development_expenditure ?? 0;
                m.nca_disposal_of_fixed_assets = m.nca_disposal_of_fixed_assets ?? 0;
                m.nca_engineering_material = m.nca_engineering_material ?? 0;


                m.nca_goodwill = m.nca_goodwill ?? 0;
                m.nca_heldon_investment = m.nca_heldon_investment ?? 0;
                m.nca_investment_property = m.nca_investment_property ?? 0;
                m.nca_longterm_equity_investment = m.nca_longterm_equity_investment ?? 0;
                m.nca_longterm_receivable = m.nca_longterm_receivable ?? 0;
                m.nca_longterm_unamortized_expenses = m.nca_longterm_unamortized_expenses ?? 0;
                m.nca_oil_and_gas_assets = m.nca_oil_and_gas_assets ?? 0;
                m.nca_intangible_assets = m.nca_intangible_assets ?? 0;
                m.nca_other_assets = m.nca_other_assets ?? 0;
                m.nca_productive_biological_asset = m.nca_productive_biological_asset ?? 0;
                m.ncl_anticipation_liabilities = m.ncl_anticipation_liabilities ?? 0;
                m.ncl_bonds_payable = m.ncl_bonds_payable ?? 0;
                m.ncl_count = m.ncl_count ?? 0;
                m.ncl_deferred_income_tax_liabilities = m.ncl_deferred_income_tax_liabilities ?? 0;
                m.ncl_longterm_loan = m.ncl_longterm_loan ?? 0;
                m.ncl_other_liabilities = m.ncl_other_liabilities ?? 0;


                m.ncl_special_payable = m.ncl_special_payable ?? 0;
                m.oe_capital_reserve = m.oe_capital_reserve ?? 0;
                m.oe_count = m.oe_count ?? 0;
                m.oe_inventory_amount = m.oe_inventory_amount ?? 0;
                m.oe_paicl_up_capital = m.oe_paicl_up_capital ?? 0;
                m.oe_surplus_public_accumulation = m.oe_surplus_public_accumulation ?? 0;
                m.oe_undistributed_profit = m.oe_undistributed_profit ?? 0;

                m.bank_account_balance = m.bank_account_balance ?? 0;
                m.withdraw_amount = m.withdraw_amount ?? 0;
                m.platform_balance = m.platform_balance ?? 0;
                m.logistics_prepayment = m.logistics_prepayment ?? 0;
                m.finished_prepayment = m.finished_prepayment ?? 0;
                m.semi_prepayment = m.semi_prepayment ?? 0;

                m.fba_inventory_amount = m.fba_inventory_amount ?? 0;
                m.not_fba_inventory_amount = m.not_fba_inventory_amount ?? 0;
                m.fba_transfer_amount = m.fba_transfer_amount ?? 0;
                m.not_fba_transfer_amount = m.not_fba_transfer_amount ?? 0;
                m.semi_inventory_amount = m.semi_inventory_amount ?? 0;
                m.semi_transfer_amount = m.semi_transfer_amount ?? 0;

                m.logistics_accounts_payable = m.logistics_accounts_payable ?? 0;
                m.finished_accounts_payable = m.finished_accounts_payable ?? 0;
                m.semi_accounts_payable = m.semi_accounts_payable ?? 0;


                //Add by Allan at 2019-01-30 16:04
                m.prepayment = Math.Abs(m.prepayment);

                //流动资产合计
                m.fa_count = m.monetary_fund + m.fa_trading_finan_asset + m.fa_bill_receivable + m.accounts_receivable + m.prepayment + m.fa_interest_receivable + m.fa_dividends_receivable + m.other_accounts_receivable + m.inventory_amount + m.fa_oneyear_noncurrent_assets + m.fa_other_assets;

                //非流动资产合计
                m.nca_count = m.nca_avai_for_sale_fassets + m.nca_heldon_investment + m.nca_longterm_receivable + m.nca_longterm_equity_investment + m.nca_investment_property + m.fixed_assets + m.nca_construction_in_process + m.nca_engineering_material + m.nca_disposal_of_fixed_assets + m.nca_productive_biological_asset + m.nca_oil_and_gas_assets + m.nca_intangible_assets + m.nca_development_expenditure + m.nca_goodwill + m.nca_longterm_unamortized_expenses + m.nca_deferred_tax_assets + m.nca_other_assets;

                //资产总计
                m.count_assets = m.fa_count + m.nca_count;

                //流动负债合计
                m.cl_count = m.short_term_borrow + m.cl_trading_financ_liabilities + m.cl_notes_payable + m.accounts_payable + m.advance_received + m.payable_remuneration + m.taxes_payable + m.cl_payable_interest + m.cl_dividends_payable + m.other_accounts_payable + m.cl_oneyear_noncurrent_liabilities + m.cl_other_liabilities;

                //非流动负债合计
                m.ncl_count = m.ncl_longterm_loan + m.ncl_bonds_payable + m.long_term_accounts_payable + m.ncl_special_payable + m.ncl_anticipation_liabilities + m.ncl_deferred_income_tax_liabilities + m.ncl_other_liabilities;

                //负债合计
                m.count_liabilities = m.cl_count + m.ncl_count;

                //所有者权益（或股东权益）合计
                m.oe_count = m.oe_paicl_up_capital + m.oe_capital_reserve + m.oe_inventory_amount + m.oe_surplus_public_accumulation + m.oe_undistributed_profit;

                //负债和所有者权益（或股东权益）总计
                m.count_liabilities_and_oe = m.count_liabilities + m.oe_count;
            }

            return Json(new
            {
                success = list.Count > 0,
                msg = list.Count == 0 ? "暂无数据" : "",
                data = list
            });
        }

        public ActionResult ExportIndex(int type, DateTime day, int paycompanyvalue)
        {
            var date = day;

            var list = new Services.FinanceReportServices().GetBalanceSheet(type, date, paycompanyvalue);

            foreach (var m in list)
            {
                m.cl_count = m.cl_count ?? 0;
                m.cl_dividends_payable = m.cl_dividends_payable ?? 0;
                m.cl_notes_payable = m.cl_notes_payable ?? 0;
                m.cl_oneyear_noncurrent_liabilities = m.cl_oneyear_noncurrent_liabilities ?? 0;
                m.cl_other_liabilities = m.cl_other_liabilities ?? 0;
                m.cl_payable_interest = m.cl_payable_interest ?? 0;
                m.cl_trading_financ_liabilities = m.cl_trading_financ_liabilities ?? 0;
                m.count_assets = m.count_assets ?? 0;
                m.count_liabilities = m.count_liabilities ?? 0;
                m.count_liabilities_and_oe = m.count_liabilities_and_oe ?? 0;
                m.fa_bill_receivable = m.fa_bill_receivable ?? 0;

                m.fa_count = m.fa_count ?? 0;
                m.fa_dividends_receivable = m.fa_dividends_receivable ?? 0;
                m.fa_interest_receivable = m.fa_interest_receivable ?? 0;
                m.fa_oneyear_noncurrent_assets = m.fa_oneyear_noncurrent_assets ?? 0;
                m.fa_other_assets = m.fa_other_assets ?? 0;
                m.fa_trading_finan_asset = m.fa_trading_finan_asset ?? 0;
                m.nca_avai_for_sale_fassets = m.nca_avai_for_sale_fassets ?? 0;
                m.nca_construction_in_process = m.nca_construction_in_process ?? 0;
                m.nca_count = m.nca_count ?? 0;
                m.nca_deferred_tax_assets = m.nca_deferred_tax_assets ?? 0;
                m.nca_development_expenditure = m.nca_development_expenditure ?? 0;
                m.nca_disposal_of_fixed_assets = m.nca_disposal_of_fixed_assets ?? 0;
                m.nca_engineering_material = m.nca_engineering_material ?? 0;


                m.nca_goodwill = m.nca_goodwill ?? 0;
                m.nca_heldon_investment = m.nca_heldon_investment ?? 0;
                m.nca_investment_property = m.nca_investment_property ?? 0;
                m.nca_longterm_equity_investment = m.nca_longterm_equity_investment ?? 0;
                m.nca_longterm_receivable = m.nca_longterm_receivable ?? 0;
                m.nca_longterm_unamortized_expenses = m.nca_longterm_unamortized_expenses ?? 0;
                m.nca_oil_and_gas_assets = m.nca_oil_and_gas_assets ?? 0;
                m.nca_intangible_assets = m.nca_intangible_assets ?? 0;
                m.nca_other_assets = m.nca_other_assets ?? 0;
                m.nca_productive_biological_asset = m.nca_productive_biological_asset ?? 0;
                m.ncl_anticipation_liabilities = m.ncl_anticipation_liabilities ?? 0;
                m.ncl_bonds_payable = m.ncl_bonds_payable ?? 0;
                m.ncl_count = m.ncl_count ?? 0;
                m.ncl_deferred_income_tax_liabilities = m.ncl_deferred_income_tax_liabilities ?? 0;
                m.ncl_longterm_loan = m.ncl_longterm_loan ?? 0;
                m.ncl_other_liabilities = m.ncl_other_liabilities ?? 0;


                m.ncl_special_payable = m.ncl_special_payable ?? 0;
                m.oe_capital_reserve = m.oe_capital_reserve ?? 0;
                m.oe_count = m.oe_count ?? 0;
                m.oe_inventory_amount = m.oe_inventory_amount ?? 0;
                m.oe_paicl_up_capital = m.oe_paicl_up_capital ?? 0;
                m.oe_surplus_public_accumulation = m.oe_surplus_public_accumulation ?? 0;
                m.oe_undistributed_profit = m.oe_undistributed_profit ?? 0;

                m.bank_account_balance = m.bank_account_balance ?? 0;
                m.withdraw_amount = m.withdraw_amount ?? 0;
                m.platform_balance = m.platform_balance ?? 0;
                m.logistics_prepayment = m.logistics_prepayment ?? 0;
                m.finished_prepayment = m.finished_prepayment ?? 0;
                m.semi_prepayment = m.semi_prepayment ?? 0;

                m.fba_inventory_amount = m.fba_inventory_amount ?? 0;
                m.not_fba_inventory_amount = m.not_fba_inventory_amount ?? 0;
                m.fba_transfer_amount = m.fba_transfer_amount ?? 0;
                m.not_fba_transfer_amount = m.not_fba_transfer_amount ?? 0;
                m.semi_inventory_amount = m.semi_inventory_amount ?? 0;
                m.semi_transfer_amount = m.semi_transfer_amount ?? 0;

                m.logistics_accounts_payable = m.logistics_accounts_payable ?? 0;
                m.finished_accounts_payable = m.finished_accounts_payable ?? 0;
                m.semi_accounts_payable = m.semi_accounts_payable ?? 0;


                //Add by Allan at 2019-01-30 16:04
                m.prepayment = Math.Abs(m.prepayment);

                //流动资产合计
                m.fa_count = m.monetary_fund + m.fa_trading_finan_asset + m.fa_bill_receivable + m.accounts_receivable + m.prepayment + m.fa_interest_receivable + m.fa_dividends_receivable + m.other_accounts_receivable + m.inventory_amount + m.fa_oneyear_noncurrent_assets + m.fa_other_assets;

                //非流动资产合计
                m.nca_count = m.nca_avai_for_sale_fassets + m.nca_heldon_investment + m.nca_longterm_receivable + m.nca_longterm_equity_investment + m.nca_investment_property + m.fixed_assets + m.nca_construction_in_process + m.nca_engineering_material + m.nca_disposal_of_fixed_assets + m.nca_productive_biological_asset + m.nca_oil_and_gas_assets + m.nca_intangible_assets + m.nca_development_expenditure + m.nca_goodwill + m.nca_longterm_unamortized_expenses + m.nca_deferred_tax_assets + m.nca_other_assets;

                //资产总计
                m.count_assets = m.fa_count + m.nca_count;

                //流动负债合计
                m.cl_count = m.short_term_borrow + m.cl_trading_financ_liabilities + m.cl_notes_payable + m.accounts_payable + m.advance_received + m.payable_remuneration + m.taxes_payable + m.cl_payable_interest + m.cl_dividends_payable + m.other_accounts_payable + m.cl_oneyear_noncurrent_liabilities + m.cl_other_liabilities;

                //非流动负债合计
                m.ncl_count = m.ncl_longterm_loan + m.ncl_bonds_payable + m.long_term_accounts_payable + m.ncl_special_payable + m.ncl_anticipation_liabilities + m.ncl_deferred_income_tax_liabilities + m.ncl_other_liabilities;

                //负债合计
                m.count_liabilities = m.cl_count + m.ncl_count;

                //所有者权益（或股东权益）合计
                m.oe_count = m.oe_paicl_up_capital + m.oe_capital_reserve + m.oe_inventory_amount + m.oe_surplus_public_accumulation + m.oe_undistributed_profit;

                //负债和所有者权益（或股东权益）总计
                m.count_liabilities_and_oe = m.count_liabilities + m.oe_count;
            }

            var colNames = new List<string>() { "数值" };
            colNames.AddRange(list.Select(p => p.statistical_time.ToString("yyyy-MM-dd")));
            
            var listresult = new List<string>();

            for (var i = 0; i < list.Count; i++)
            {
                var m0 = list[i];

                var listProperties = m0.GetType().GetProperties();
                var rowindex = 0;
                for(var o=0;o<listProperties.Length;o++)
                {
                    var descriptionName = "";
                    var v = (DescriptionAttribute[])listProperties[o].GetCustomAttributes(typeof(DescriptionAttribute), false);
                    if (v.Length > 0)
                    {
                        descriptionName = v[0].Description;
                    }

                    if (descriptionName == "")
                    {
                        continue;
                    }

                    var value = listProperties[o].GetValue(m0, null).ToString();

                    if (i == 0)  //添加字段名称
                    {
                        listresult.Add(descriptionName);
                    }

                    var temp = listresult[rowindex] + "|" + value;
                    listresult[rowindex] = temp;
                    rowindex++;
                }
            }

            var filename = "资产负债表 " + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(listresult, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
            
        }

        /// <summary>
        /// 更新资产负债表
        /// </summary>
        /// <param name="id"></param>
        /// <param name="c">更新字段</param>
        /// <param name="val">值</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult BalanceSheet(int id, string c, decimal val)
        {
            if (id <= 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "id必须大于0。"
                });
            }

            var result = new Services.FinanceReportServices().UpdateBalanceSheet(id, c, val);

            return Json(new
            {
                success = string.IsNullOrEmpty(result),
                msg = result

            });
        }

        /// <summary>
        /// 管理成本报表页面
        /// </summary>
        /// <returns></returns>
        public IActionResult AdministrativeCost()
        {
            var lastmonth = DateTime.Now;
            var day = DateTime.Now;

            var start = DateTime.Parse(lastmonth.Year + "-" + lastmonth.Month + "-01");
            var end = start.AddMonths(1).AddDays(-1);

            ViewBag.start = start;
            ViewBag.end = end;

            return View();
        }

        /// <summary>
        /// 管理成本报表数据
        /// </summary>
        /// <param name="t"></param>
        /// <param name="PayName"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult AdministrativeCostJson(int t, DateTime start,DateTime end,int? paycompanyid)
        {
            var url = ConfigHelper.GetByName("FeeUrl")+"?o=0";
            var cwurl = ConfigHelper.GetByName("cwUrl") + "?";
            
            url += "&startDate=" + start.ToString("yyyy-MM-dd") + "&endDate=" + end.ToString("yyyy-MM-dd");
            cwurl += "BeginRepayTime="+start.ToString("yyyy-MM-dd")+ "&EndRepayTime="+end.ToString("yyyy-MM-dd");

            if (paycompanyid.HasValue)
            {
                url += "&companyValue=" + paycompanyid.Value;
                cwurl += "&CompanyVal=" + paycompanyid.Value;
            }


            //利息支出
            var listInterest = new Services.FinanceReportServices().ListInterestExpense(cwurl);

            var list = new Services.FinanceReportServices().ListOtherCost(url);
            var listValue = new List<Tuple<string, List<decimal>>>();
            var listCol = new List<string>();
            var listColVal = new List<int>();

            if (list.Count > 0)
            {
                if (t == 2)  //按付款主体
                {
                    listCol = list.GroupBy(a => a.companyName).Select(p => p.Key).OrderBy(a=>a).ToList();
                    
                }
                else  //按部门
                {
                    listCol = list.GroupBy(a => a.departmentName).Select(p => p.Key).ToList();
                }

                for (var i=0;i< listCol.Count;i++)
                {
                    foreach (var item in list)
                    {
                        if (t == 2)  //按付款主体
                        {
                            if (item.companyName == listCol[i])
                            {
                                var obj = listValue.Where(a => a.Item1 == item.feeSuperType).FirstOrDefault();

                                if (obj == null)
                                {
                                    var listItems = new List<decimal>();
                                    while (listItems.Count < listCol.Count)
                                    {
                                        listItems.Add(0.00M);
                                    }

                                    listItems[i] = item.amountRmb;
                                    listValue.Add(new Tuple<string, List<decimal>>(item.feeSuperType, listItems));
                                }
                                else
                                {
                                    obj.Item2[i] += item.amountRmb;
                                }
                            }
                        }
                        else
                        {
                            if (item.departmentName == listCol[i])
                            {
                                var obj = listValue.Where(a => a.Item1 == item.feeSuperType).FirstOrDefault();

                                if (obj == null)
                                {
                                    var listItems = new List<decimal>();
                                    while (listItems.Count < listCol.Count)
                                    {
                                        listItems.Add(0.00M);
                                    }

                                    listItems[i] = item.amountRmb;
                                    listValue.Add(new Tuple<string, List<decimal>>(item.feeSuperType, listItems));
                                }
                                else
                                {
                                    obj.Item2[i] += item.amountRmb;
                                }
                            }
                        }
                    }
                }

                var listCount = new List<decimal>();

                if (listInterest.Count > 0)
                {
                    var obj = listValue.Where(a => a.Item1 == "利息支出").FirstOrDefault();
                    var index_Interest = -1;


                    if (t == 2)  //按付款主体
                    {
                        var clothindex = -1;
                        for (var i = 0; i<listCol.Count; i++)
                        {
                            if (listCol[i] == "广州电子服装仓")
                            {
                                clothindex = i;
                            }

                            if (listCol[i] == "广州百伦供应链科技有限公司")
                            {
                                index_Interest = i;
                            }
                        }

                        //广州电子服装仓
                        var clothVal = 0.00M;
                        var objCloth = listInterest.Where(a => a.CompanyVal != 1);
                        if (objCloth.Count() > 0)
                        {
                            clothVal = objCloth.Sum(a => a.RepayInterestRMB);
                        }

                        //广州百伦
                        var gzblVal = 0.00M;
                        var objGZBL = listInterest.Where(a => a.CompanyVal == 1);
                        if (objGZBL.Count() > 0)
                        {
                            gzblVal = objGZBL.Sum(a => a.RepayInterestRMB);
                        }

                        if (clothVal > 0 && clothindex == -1)
                        {
                            listCol.Add("广州电子服装仓");
                            clothindex = listCol.Count - 1;

                            foreach (var item in listValue)
                            {
                                item.Item2.Add(0);
                            }

                        }
                        if(gzblVal>0 && index_Interest==-1)
                        {
                            listCol.Add("广州百伦供应链科技有限公司");
                            index_Interest = listCol.Count - 1;

                            foreach (var item in listValue)
                            {
                                item.Item2.Add(0);
                            }
                        }

                        if (obj == null)
                        {
                            var _list = new List<decimal>();
                            for (var j = 0; j < listCol.Count; j++)
                            {
                                if (j == clothindex)
                                {
                                    _list.Add(clothVal);
                                }
                                else if (j == index_Interest)
                                {
                                    _list.Add(gzblVal);
                                }
                                else
                                {
                                    _list.Add(0);
                                }
                            }

                            listValue.Add(new Tuple<string, List<decimal>>("利息支出", _list));
                        }
                        else
                        {
                            obj.Item2[clothindex] = clothVal;
                            obj.Item2[index_Interest] = gzblVal;
                        }

                    }
                    else  //按部门
                    {
                        for (var i = 0; i < listCol.Count; i++)
                        {
                            if (listCol[i] == "财务部")
                            {
                                index_Interest = i;
                            }
                        }

                        var val = listInterest.Sum(a => a.RepayInterestRMB);

                        if (index_Interest == -1 && val > 0)
                        {
                            listCol.Add("财务部");
                            index_Interest = listCol.Count - 1;

                            foreach (var item in listValue)
                            {
                                item.Item2.Add(0);
                            }
                        }

                        if (obj == null)
                        {
                            var _list = new List<decimal>();
                            for (var j = 0; j < listCol.Count; j++)
                            {

                                if (j == index_Interest)
                                {
                                    _list.Add(val);
                                }
                                else
                                {
                                    _list.Add(0);
                                }
                            }

                            listValue.Add(new Tuple<string, List<decimal>>("利息支出", _list));
                        }
                        else
                        {
                            obj.Item2[index_Interest] = val;
                        }
                    }
                }

                foreach (var item in listValue)
                {
                    for (var i = 0; i < item.Item2.Count; i++)
                    {
                        var v = item.Item2[i];

                        item.Item2[i] = Math.Round(v, 2);

                        if (listCount.Count() > i)
                        {
                            listCount[i] += item.Item2[i];
                        }
                        else
                        {
                            listCount.Add(item.Item2[i]);
                        }
                    }

                    item.Item2.Add(item.Item2.Sum());
                }
                listValue.Add(new Tuple<string, List<decimal>>("总计", listCount));
            }
            
            return Json(new {
                success = list.Count>0,
                msg = list.Count>0?"":"成本接口返回了空记录。",
                col = listCol,
                list = listValue,
                amount = Math.Round(list.Sum(a=>a.amountRmb),2)
            });
        }

        [HttpPost]
        public JsonResult AdministrativeCostChildrenJson(int t, DateTime start, DateTime end, int? paycompanyid, string categoryname, string heads)
        {
            var url = ConfigHelper.GetByName("FeeUrl") + "?o=0";

            url += "&startDate=" + start.ToString("yyyy-MM-dd") + "&endDate=" + end.ToString("yyyy-MM-dd");

            if (paycompanyid.HasValue)
            {
                url += "&companyValue=" + paycompanyid.Value;
            }

            if (!string.IsNullOrEmpty(categoryname))
            {
                url += "&feeSuperType=" + categoryname;
            }

            var list = new Services.FinanceReportServices().ListOtherCost(url);
            var listValue = new List<Tuple<string, List<decimal>>>();
            var listCol = heads.Split("|").ToList();

            if (list.Count > 0)
            {
                
                for (var i = 0; i < listCol.Count; i++)
                {
                    foreach (var item in list)
                    {
                        if (t == 2)  //按付款主体
                        {
                            if (item.companyName == listCol[i])
                            {
                                var obj = listValue.Where(a => a.Item1 == item.feeSubType).FirstOrDefault();

                                if (obj == null)
                                {
                                    var listItems = new List<decimal>();
                                    while (listItems.Count < listCol.Count)
                                    {
                                        listItems.Add(0.00M);
                                    }

                                    listItems[i] = item.amountRmb;
                                    listValue.Add(new Tuple<string, List<decimal>>(item.feeSubType, listItems));
                                }
                                else
                                {
                                    obj.Item2[i] += item.amountRmb;
                                }
                            }
                        }
                        else
                        {
                            if (item.departmentName == listCol[i])
                            {
                                var obj = listValue.Where(a => a.Item1 == item.feeSubType).FirstOrDefault();

                                if (obj == null)
                                {
                                    var listItems = new List<decimal>();
                                    while (listItems.Count < listCol.Count)
                                    {
                                        listItems.Add(0.00M);
                                    }

                                    listItems[i] = item.amountRmb;
                                    listValue.Add(new Tuple<string, List<decimal>>(item.feeSubType, listItems));
                                }
                                else
                                {
                                    obj.Item2[i] += item.amountRmb;
                                }
                            }
                        }
                    }
                }
            }

            return Json(new
            {
                success = list.Count > 0,
                msg = list.Count > 0 ? "" : "管理成本接口返回了空记录。",
                col = listCol,
                list = listValue
            });
        }

        public ActionResult ListAdministrativeCost(DateTime start,DateTime end,int? paycompanyid,string headname,string categoryname,int type,int issub)
        {
            ViewBag.start = start;
            ViewBag.end = end;
            ViewBag.paycompanyid = paycompanyid??-1;
            ViewBag.headname = headname;
            ViewBag.categoryname = categoryname;
            ViewBag.type = type;
            ViewBag.isSub = issub;

            return View();
        }

        /// <summary>
        /// 获取管理成本明细列表
        /// </summary>
        /// <param name="paycompanyid">付款主体id</param>
        /// <param name="headname">列头名称</param>
        /// <param name="categoryname"></param>
        /// <param name="subname"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public string ListAdministrativeCostJson(DateTime start, DateTime end, int? paycompanyid, string headname, string categoryname, int type, int issub)
        {
            var url = ConfigHelper.GetByName("FeeUrl") + "?o=0";

            url += "&startDate=" + start.ToString("yyyy-MM-dd") + "&endDate=" + end.ToString("yyyy-MM-dd");

            if (paycompanyid.HasValue && paycompanyid.Value>0)
            {
                url += "&companyValue=" + paycompanyid.Value;
            }

            if (!string.IsNullOrEmpty(headname))
            {
                if (type == 1)
                {
                    url += "&departmentName=" + headname;
                }
                else
                {
                    var val = -1;
                    var objPayCompany = new Services.FinanceReportServices().GetPayCompanyByName(headname);

                    if (objPayCompany != null)
                    {
                        val = objPayCompany.company_value;
                    }

                    url += "&companyValue="+ val;
                }
                
            }

            if (!string.IsNullOrEmpty(categoryname))
            {
                if (issub == 0)
                {
                    url += "&feeSuperType=" + categoryname;
                }
                else
                {
                    url += "&feeSubType=" + categoryname;
                }
                
            }

            var obj = new Services.FinanceReportServices().ListOtherCost(url);

            if (obj.Count > 0)
            {
                var m = new Models.Api.mOtherFee {
                    no = "",
                    companyName = "",
                    amount = obj.Sum(a => a.amount),
                    amountRmb = obj.Sum(a => a.amountRmb),
                    currency = "",
                    departmentName = "",
                    feeSubType = "",
                    feeSuperType = "合计",
                };

                obj.Add(m);
            }

            var list = obj.Select(a => new {
                amount = a.amount.ToString("###,###.##"),
                amountRmb = a.amountRmb.ToString("###,###.##"),
                a.companyName,
                a.currency,
                a.departmentName,
                a.feeSubType,
                a.feeSuperType,
                a.no,
                a.manageCostType,
                a.receiveUnit,
                a.reason,
                payTime = a.payTime.HasValue?a.payTime.Value.ToString("yyyy-MM-dd HH:mm:ss"):""
            }).ToList();
            

            return JsonConvert.SerializeObject(new { total = list.Count, rows = list });
        }

        public ActionResult ListInterestExpense(DateTime start, DateTime end, int? paycompanyid, string headname, string categoryname, int type, int issub)
        {
            ViewBag.start = start;
            ViewBag.end = end;
            ViewBag.paycompanyid = paycompanyid ?? -1;
            ViewBag.headname = headname;
            ViewBag.categoryname = categoryname;
            ViewBag.type = type;
            ViewBag.isSub = issub;

            return View();
        }

        /// <summary>
        /// 获取利息支出明细列表
        /// </summary>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="paycompanyid"></param>
        /// <param name="headname"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public string ListInterestExpenseJson(DateTime start, DateTime end, int? paycompanyid, string headname, int type)
        {
            var cwurl = ConfigHelper.GetByName("cwUrl") + "?BeginRepayTime=" + start.ToString("yyyy-MM-dd") + "&EndRepayTime=" + end.ToString("yyyy-MM-dd");

            if (paycompanyid.HasValue && paycompanyid.Value>0)
            {
                cwurl += "&CompanyVal=" + paycompanyid.Value;
            }

            //利息支出
            var listInterest = new Services.FinanceReportServices().ListInterestExpense(cwurl);

            if (listInterest.Count > 0)
            {
                listInterest.Add(new Models.Api.mInterestExpense {
                    Company = "总计",
                    RepayInterest = listInterest.Sum(a=>a.RepayInterest),
                    RepayInterestRMB = listInterest.Sum(a=>a.RepayInterestRMB),
                    //ActualRepayTime = DateTime.Now,
                });
            }

            var list = listInterest.Select(a => new
            {
                ActualRepayTime = a.ActualRepayTime.HasValue?a.ActualRepayTime.Value.ToString("yyyy-MM-dd HH:mm:ss"):"",
                a.BankCard,
                a.BankCardUser,
                a.BankName,
                a.Company,
                a.Creditor,
                RepayInterest = a.RepayInterest.ToString("N2"),
                RepayInterestRMB = a.RepayInterestRMB.ToString("N2"),
            });

            return JsonConvert.SerializeObject(new { total = list.Count(), rows = list });
        }

        public ActionResult ExportListInterestExpense(DateTime start, DateTime end, int? paycompanyid, string headname, string categoryname, int type, int issub)
        {
            var cwurl = ConfigHelper.GetByName("cwUrl") + "?BeginRepayTime=" + start.ToString("yyyy-MM-dd") + "&EndRepayTime=" + end.ToString("yyyy-MM-dd");

            if (paycompanyid.HasValue && paycompanyid.Value > 0)
            {
                cwurl += "&CompanyVal=" + paycompanyid.Value;
            }

            //利息支出
            var listInterest = new Services.FinanceReportServices().ListInterestExpense(cwurl);

            var colNames = new List<string> {"借入公司主体名称","借款帐号","借款银行名称", "借款银行持卡人", "债权方",
                                             "本期归还利息", "本期归还利息RMB","实际还款时间" };

            var list = new List<string>();
            foreach (var item in listInterest)
            {
                list.Add(item.Company + "|" + item.BankCard + "|" + item.BankCardUser + "|" + item.BankName + "|" + item.Creditor + "|" +
                    item.RepayInterest + "|" + item.RepayInterestRMB+"|"+(item.ActualRepayTime.HasValue?item.ActualRepayTime.Value.ToString("yyyy-MM-dd"):"")
                    );
            }

            var filename = categoryname + "+" + headname + " 利息支出明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");

        }

        /// <summary>
        /// 导出分类管理成品明细
        /// </summary>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="paycompanyid"></param>
        /// <param name="headname"></param>
        /// <param name="categoryname"></param>
        /// <param name="type"></param>
        /// <param name="issub"></param>
        /// <returns></returns>
        public ActionResult ExportListAdministrativeCost(DateTime start, DateTime end, int? paycompanyid, string headname, string categoryname, int type, int issub)
        {
            var url = ConfigHelper.GetByName("FeeUrl") + "?o=0";

            url += "&startDate=" + start.ToString("yyyy-MM-dd") + "&endDate=" + end.ToString("yyyy-MM-dd");

            if (paycompanyid.HasValue && paycompanyid.Value > 0)
            {
                url += "&companyValue=" + paycompanyid.Value;
            }

            if (!string.IsNullOrEmpty(headname))
            {
                if (type == 1)
                {
                    url += "&departmentName=" + headname;
                }
                else
                {
                    url += "&companyValue=" + headname;
                }

            }

            if (!string.IsNullOrEmpty(categoryname))
            {
                if (issub == 0)
                {
                    url += "&feeSuperType=" + categoryname;
                }
                else
                {
                    url += "&feeSubType=" + categoryname;
                }

            }

            var obj = new Services.FinanceReportServices().ListOtherCost(url);

            var colNames = new List<string> {"部门名称","付款主体名称","父级分类", "子分类", "金额",
                                             "币种", "人民币金额" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.departmentName + "|" + item.companyName + "|" + item.feeSuperType + "|" + item.feeSubType + "|" + item.amount + "|" +
                    item.currency + "|" + item.amountRmb
                    );
            }

            var filename = categoryname+"+"+headname+" 管理成本明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
        }

        /// <summary>
        /// 导出管理成本明细
        /// </summary>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public IActionResult ExportAdministrativeCost(DateTime start, DateTime end, int? paycompanyid)
        {
            var url = ConfigHelper.GetByName("FeeUrl") + "?o=0";

            url += "&startDate=" + start.ToString("yyyy-MM-dd") + "&endDate=" + end.ToString("yyyy-MM-dd");

            if (paycompanyid.HasValue && paycompanyid.Value > 0)
            {
                url += "&companyValue=" + paycompanyid.Value;
            }
            

            var obj = new Services.FinanceReportServices().ListOtherCost(url);

            var colNames = new List<string> {"部门名称","付款主体名称","父级分类", "子分类", "金额",
                                             "币种", "人民币金额" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.departmentName+"|"+item.companyName+"|"+item.feeSuperType+"|"+item.feeSubType+"|"+item.amount+"|"+
                    item.currency+"|"+item.amountRmb
                    );
            }

            var filename = "管理成本明细"+DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\"+DateTime.Now.ToString("yyyy-MM-dd")+"\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/"+ DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename+".csv");
        }

        #region 资产负债表-子表

        public ActionResult MonetaryFund(DateTime date, int paycompanyid)
        {
            var m = new Services.FinanceReportServices().GetMonetaryFundCount(date, paycompanyid);

            ViewBag.m = m;
            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;

            return View();
        }

        /// <summary>
        /// 提现在途明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult WithDrawOnWay(DateTime date, int paycompanyid)
        {
            var _services = new Services.FinanceReportServices();

            var paycompany = _services.GetPayCompany(paycompanyid);
            //var list = _services.ListWithDrawOnWay(date, paycompanyid);

            ViewBag.PayCompanyName = paycompany != null ? paycompany.company_name : "";
            //ViewBag.list = list;
            ViewBag.date = date.ToString("yyyy-MM-dd HH:mm:ss");
            ViewBag.companyid = paycompanyid;
            return View();
        }

        public string WithDrawOnWayJson(BtTableParameter request, DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var obj = _services.ListWithDrawOnWay(request,date, paycompanyid,ref total);

            var list = obj.Select(a => new {
                sale_platform = a.sale_platform,
                platform = a.platform,
                pay_account = a.pay_account,
                bank_name = a.bank_name,
                bank_card_user = a.bank_card_user,
                amount_rmb = a.amount_rmb.ToString("N2"),
                statistical_time = a.statistical_time.ToString("yyyy-MM-dd HH:mm:ss")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        /// <summary>
        /// 导出提现在途明细
        /// </summary>
        /// <param name="date">统计日期</param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult WithDrawOnWayExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() {
                offset = 0,
                limit = 100000
            };

            var obj = _services.ListWithDrawOnWay(request, date, paycompanyid, ref total);

            var colNames = new List<string> {"销售平台名称","支付平台名称","银行帐号", "银行名称", "持卡人",
                                             "帐号余额", "日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.sale_platform + "|" + item.platform + "|" + item.pay_account + "|" + item.bank_name + "|" + item.bank_card_user + "|" +
                    item.amount_rmb.ToString("N2") + "|" + item.statistical_time.ToString("yyyy-MM-dd HH:mm:ss")
                    );
            }

            var filename = date.ToString("yyyy-MM-dd") + " 平台提现在途明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");

        }


        /// <summary>
        /// 第三方帐号余额明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult PlatformBalance(DateTime date, int paycompanyid)
        {
            //var _services = new Services.FinanceReportServices();
            //var paycompany = _services.GetPayCompany(paycompanyid);
            

            //ViewBag.PayCompanyName = paycompany != null ? paycompany.company_name : "";

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        public string PlatformBalanceJson(BtTableParameter request,DateTime date,int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPlatFormBalance(request,date, paycompanyid,ref total);

            var list = obj.Select(a => new {
                platformname = a.platformname,
                a.account,
                amount = a.amount.ToString("N2"),
                userable_amount = a.userable_amount.ToString("N2"),
                freeze_amount = a.freeze_amount.ToString("N2"),
                a.currency,
                amount_rmb = a.amount_rmb.ToString("N2"),
                userable_amount_rmb = a.userable_amount_rmb.ToString("N2"),
                freeze_amount_rmb = a.freeze_amount_rmb.ToString("N2"),
                puttime = a.puttime.ToString("yyyy-MM-dd"),
                day = a.day.ToString("yyyy-MM-dd")
            });
            
            return JsonConvert.SerializeObject(new { total=total,rows=list});
        }

        /// <summary>
        /// 导出第三方帐号余额明细
        /// </summary>
        /// <param name="date">统计日期</param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult PlatformBalanceExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter(){offset = 0,limit = 100000};

            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPlatFormBalance(request, date, paycompanyid, ref total);

            var colNames = new List<string> {"平台名称","帐号名称","总余额（原币）", "可用余额（原币）", "冻结余额（原币）",
                                             "币种", "总余额（人民币）","可用余额（人民币）","冻结余额（人民币）","放款日期","统计日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.platformname + "|" + item.account + "|" + item.amount.ToString("N2") + "|" + item.userable_amount.ToString("N2") + "|" + item.freeze_amount.ToString("N2") + "|" +
                    item.currency + "|" + item.amount_rmb.ToString("N2")+"|"+item.userable_amount_rmb.ToString("N2")+"|"+item.freeze_amount_rmb.ToString("N2")+"|"+ item.puttime.ToString("yyyy-MM-dd")+"|"+ item.day.ToString("yyyy-MM-dd")
                    );
            }

            var filename = date.ToString("yyyy-MM-dd") + " 第三方帐号余额明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");

        }

        /// <summary>
        /// 银行余额明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult BankBalance(DateTime date, int paycompanyid)
        {

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        public string BankBalanceJson(BtTableParameter request, DateTime date, int paycompanyid)
        {
            int total = 0;
            var _services = new Services.FinanceReportServices();

            //var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListBankBalance(request,date, paycompanyid,ref total);
            var list = obj.Select(a => new {
                a.company_name,
                a.bank_name,
                a.bank_card,
                a.bank_card_user,
                balance_rmb = a.balance_rmb.ToString("N2"),
                statistical_time = a.statistical_time.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new {total=total,rows=list});
        }

        public ActionResult BankBalanceExport(DateTime date, int paycompanyid)
        {
            int total = 0;
            var _services = new Services.FinanceReportServices();

            var request = new BtTableParameter()
            {
                offset = 0,
                limit = 100000
            };

            var obj = _services.ListBankBalance(request, date, paycompanyid, ref total);
            
            var colNames = new List<string> {"银行名称","银行卡号","持卡人", "帐号余额", "日期"};

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.bank_name + "|" + item.bank_card + "|" + item.bank_card_user + "|" + item.balance_rmb.ToString("N2") + "|" + item.statistical_time.ToString("yyyy-MM-dd")
                    );
            }

            var filename = date.ToString("yyyy-MM-dd") + " 银行余额明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
        }

        /// <summary>
        /// 获取存货FBA和非FBA的分别库存数
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult InventoryBalanceCount(DateTime date, int paycompanyid)
        {
            var m = new Services.FinanceReportServices().ListInventoryBalanceCount(date, paycompanyid);
            ViewBag.m = m;
            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        /// <summary>
        /// 获取存货明细
        /// </summary>
        /// <param name="date">日期</param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult InventoryBalance(DateTime date, int paycompanyid, int t)
        {

            ViewBag.t = t;
            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;

            return View();
        }

        /// <summary>
        /// 库存在库明细
        /// </summary>
        /// <param name="request"></param>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <param name="t"></param>
        /// <returns></returns>
        public string InventoryBalanceJson(BtTableParameter request, DateTime date, int paycompanyid, int t)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListInventoryBalance(request,date, paycompanyid, t,ref total);

            var list = obj.Select(a => new {
                company_name = paycompany!=null? paycompany.company_name:"",
                warehouse_name = a.warehouse_name,
                balance_rmb = a.balance_rmb.ToString("N2"),
                statistical_time = a.statistical_time.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        public ActionResult InventoryBalanceExport(DateTime date, int paycompanyid, int t)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var paycompany = _services.GetPayCompany(paycompanyid);

            var obj = _services.ListInventoryBalance(request, date, paycompanyid, t, ref total);

            //var list = obj.Select(a => new {
            //    company_name = paycompany != null ? paycompany.company_name : "",
            //    warehouse_name = a.warehouse_name,
            //    balance_rmb = a.balance_rmb.ToString("N2"),
            //    statistical_time = a.statistical_time.ToString("yyyy-MM-dd")
            //});

            var colNames = new List<string> {"仓库名称","存货余额","日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.warehouse_name + "|" + item.balance_rmb.ToString("N2") + "|" + item.statistical_time.ToString("yyyy-MM-dd"));
            }

            var typename = "";
            if (t == 0) //FBA在库明细
            {
                typename = "FBA仓在库明细";
            }
            else if (t == 1) //非FBA在库明细
            {
                typename = "非FBA仓在库明细";
            }
            else if (t == 3) //FBA在途明细
            {
                typename = "FBA仓在途明细";
            }
            else if (t == 4) //非FBA在途明细
            {
                typename = "非FBA仓在途明细";
            }


            var filename = date.ToString("yyyy-MM-dd") + typename + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
            
        }

        /// <summary>
        /// 半成品库存明细
        /// </summary>
        /// <param name="date">统计日期</param>
        /// <param name="paycompanyid">付款主体</param>
        /// <returns></returns>
        public ActionResult SemiFinishStock(DateTime date, int paycompanyid)
        {
            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }


        /// <summary>
        /// 半成品库存明细
        /// </summary>
        /// <param name="request"></param>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public string SemiFinishStockJson(BtTableParameter request, DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListSemiFinishDailyStock(request, date, paycompanyid, ref total);

            var list = obj.Select(a => new {
                a.warehouse_name,
                a.sku_code,
                a.stock_quantity,
                inventory_amount = a.inventory_amount.ToString("N2"),
                day = a.day.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        public ActionResult SemiTransferStock(DateTime date, int paycompanyid)
        {

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        /// <summary>
        /// 半成品在途库存
        /// </summary>
        /// <param name="request">分页信息</param>
        /// <param name="date">统计日期</param>
        /// <param name="paycompanyid">付款主体id</param>
        /// <returns></returns>
        public string SemiTransferStockJson(BtTableParameter request, DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListSemiTransferStock(request, date, paycompanyid, ref total);

            var list = obj.Select(a => new {
                a.warehouse_name,
                a.sku_code,
                a.transfer_quantity,
                inventory_amount = (a.transfer_quantity*a.unit_price).ToString("N2"),
                day = a.day.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }


        public ActionResult SemiFinishStockExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListSemiFinishDailyStock(request, date, paycompanyid, ref total);

            //var list = obj.Select(a => new {
            //    a.warehouse_name,
            //    a.sku_code,
            //    a.stock_quantity,
            //    inventory_amount = a.inventory_amount.ToString("N2"),
            //    update_time = a.update_time.ToString("yyyy-MM-dd HH:mm:ss")
            //});

            var colNames = new List<string> { "仓库名称", "Sku编码", "库存数量","库存金额","更新日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.warehouse_name + "|" + item.sku_code + "|" + item.stock_quantity+"|"+ item.inventory_amount.ToString("N2")+"|"+item.day.ToString("yyyy-MM-dd"));
            }
            var filename = date.ToString("yyyy-MM-dd") + "半成品在库明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
        }

        public ActionResult SemiTransferStockExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListSemiTransferStock(request, date, paycompanyid, ref total);

            var colNames = new List<string> { "仓库名称", "Sku编码", "库存数量", "库存金额", "更新日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.warehouse_name + "|" + item.sku_code + "|" + item.transfer_quantity + "|" + (item.unit_price*item.transfer_quantity).ToString("N2") + "|" + item.day.ToString("yyyy-MM-dd"));
            }
            var filename = date.ToString("yyyy-MM-dd") + "半成品在途明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");

        }

        /// <summary>
        /// 短期借款明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult ShortBorrow(DateTime date, int paycompanyid)
        {

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        public string ShortBorrowJson(BtTableParameter request, DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListShorBorrow(request,date, paycompanyid,ref total);

            var list = obj.Select(a => new {
                a.company_name,
                a.bank_card,
                a.bank_name,
                a.bank_card_user,
                a.creditor,
                balance_rmb = a.balance_rmb.ToString("N2"),
                statistical_time = a.statistical_time.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        public ActionResult PrePayCount(DateTime date, int paycompanyid)
        {
            var _services = new Services.FinanceReportServices();
            var list = _services.ListPrePayCount(date, paycompanyid, 1);

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            ViewBag.list = list;
            return View();
        }

        /// <summary>
        /// 商品供应商 预付款明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult PrePay(DateTime date, int paycompanyid,int finish)
        {
            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            ViewBag.finish = finish;
            return View();
        }

        public string PrePayJson(BtTableParameter request,DateTime date, int paycompanyid,int? finish)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            //var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPrePay(request,date, paycompanyid,1,finish,ref total);

            var list = obj.Select(a => new {
                a.supplier_name,
                is_finish = (a.is_finish == 0 ? "半成品" : "成品"),
                a.pay_company_name,
                start_amount = a.start_amount.ToString("N2"),
                putting_amount = ((a.putting_amount + a.express_amount + a.adjust_amount - a.return_amount - a.return_express).ToString("N2")),
                pay_amount = (a.pay_amount - a.receive_amount).ToString("N2"),
                end_amount = a.end_amount.ToString("N2"),
                day = a.day.Value.ToString("yyyy-MM-dd"),
            });

            return JsonConvert.SerializeObject(new { total=total,rows = list });
        }

        public ActionResult PrePayExport(DateTime date, int paycompanyid, int? finish)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter()
            {
                offset = 0,
                limit = 100000
            };
            var obj = _services.ListPrePay(request, date, paycompanyid, 1, finish, ref total);

            var colNames = new List<string> {"供应商名称","是否成品","公司主体", "期初金额", "借方发生额",
                                             "贷方发生额", "期末金额","日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.supplier_name + "|" + (item.is_finish == 0 ? "半成品" : "成品") + "|" + item.pay_company_name + "|" + item.start_amount.ToString("N2") + "|" + ((item.putting_amount + item.express_amount + item.adjust_amount - item.return_amount - item.return_express).ToString("N2")) + "|" +
                    (item.pay_amount - item.receive_amount).ToString("N2") + "|" + item.end_amount.ToString("N2")+"|"+ item.day.Value.ToString("yyyy-MM-dd"));
            }

            var filename = date.ToString("yyyy-MM-dd") +((finish??0)==1?"成品":"半成品") + " 商品供应商预付款明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");


        }

        /// <summary>
        /// 物流供应商 预付款明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult PrePayLogistics(DateTime date, int paycompanyid)
        {
            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        public string PrePayLogisticsJson(BtTableParameter request,DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            //var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPrePayLogistics(request, date, paycompanyid, 1, ref total);

            var list = obj.Select(a => new {
                a.supplier_name,
                a.pay_company_name,
                start_amount = a.start_amount.ToString("N2"),
                borrow_amount = a.borrow_amount.ToString("N2"),
                loan_amount = a.loan_amount.ToString("N2"),
                end_amount = a.end_amount.ToString("N2"),
                day = a.day.Value.ToString("yyyy-MM-dd"),
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        public ActionResult PrePayLogisticsExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter()
            {
                offset = 0,
                limit = 100000
            };

            var obj = _services.ListPrePayLogistics(request, date, paycompanyid, 1, ref total);
            var colNames = new List<string> {"供应商名称","公司主体", "期初金额", "借方发生额","贷方发生额", "期末金额","日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.supplier_name + "|" + item.pay_company_name + "|" + item.start_amount.ToString("N2") + "|" + item.borrow_amount.ToString("N2") + "|" +item.loan_amount.ToString("N2")+"|"+item.end_amount.ToString("N2")+"|"+item.day.Value.ToString("yyyy-MM-dd"));
            }

            var filename = date.ToString("yyyy-MM-dd") + " 物流供应商预付款明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
        }

        /// <summary>
        /// 应付款统计
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult CopeWithCount(DateTime date, int paycompanyid)
        {
            var _services = new Services.FinanceReportServices();
            var list = _services.ListPrePayCount(date, paycompanyid, 0);

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            ViewBag.list = list;
            return View();
        }

        /// <summary>
        /// 应付款明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult CopeWith(DateTime date, int paycompanyid,int finish)
        {

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            ViewBag.finish = finish;
            return View();
        }

        public string CopeWithJson(BtTableParameter request,DateTime date, int paycompanyid,int? finish)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPrePay(request,date, paycompanyid, 0, finish, ref total);

            var list = obj.Select(a=>new {
                supplier_name = a.supplier_name,
                is_finish = (a.is_finish == 0 ? "半成品" : "成品"),
                a.pay_company_name,
                start_amount = a.start_amount.ToString("N2"),
                putting_amount = (a.putting_amount + a.express_amount + a.adjust_amount - a.return_amount - a.return_express).ToString("N2"),
                pay_amount = (a.pay_amount - a.receive_amount).ToString("N2"),
                end_amount = a.end_amount.ToString("N2"),
                day = a.day.Value.ToString("yyyy-MM-dd"),
            });
            return JsonConvert.SerializeObject(new { total=total,rows=list});
        }

        public ActionResult CopeWithExport(DateTime date, int paycompanyid, int? finish)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() {offset = 0,limit = 100000};
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPrePay(request, date, paycompanyid, 0, finish, ref total);

            var colNames = new List<string> {"供应商名称","是否成品","公司主体", "期初金额", "借方发生额",
                                             "贷方发生额", "期末金额","统计日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.supplier_name + "|" + (item.is_finish == 0 ? "半成品" : "成品") + "|" + item.pay_company_name + "|" + item.start_amount.ToString("N2") + "|" + ((item.putting_amount + item.express_amount + item.adjust_amount - item.return_amount - item.return_express).ToString("N2")) + "|" +
                    (item.pay_amount - item.receive_amount).ToString("N2") + "|" + item.end_amount.ToString("N2") + "|" + item.day.Value.ToString("yyyy-MM-dd"));
            }

            var filename = date.ToString("yyyy-MM-dd") + ((finish ?? 0) == 1 ? "成品" : "半成品") + " 商品供应商应付款明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");


        }

        /// <summary>
        /// 物流供应商应付款明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult CopeWithLogistics(DateTime date, int paycompanyid)
        {

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        /// <summary>
        /// 物流供应商应付账款
        /// </summary>
        /// <param name="request"></param>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public string CopeWithLogisticsJson(BtTableParameter request, DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPrePayLogistics(request, date, paycompanyid, 0, ref total);
            
            var list = obj.Select(a => new {
                a.supplier_name,
                a.pay_company_name,
                start_amount = a.start_amount.ToString("N2"),
                borrow_amount = a.borrow_amount.ToString("N2"),
                loan_amount = a.loan_amount.ToString("N2"),
                end_amount = a.end_amount.ToString("N2"),
                day = a.day.Value.ToString("yyyy-MM-dd"),
            });
            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        public ActionResult CopeWithLogisticsExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListPrePayLogistics(request, date, paycompanyid, 0, ref total);
            
            var colNames = new List<string> { "供应商名称", "公司主体", "期初金额", "借方发生额", "贷方发生额", "期末金额", "日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.supplier_name + "|" + item.pay_company_name + "|" + item.start_amount.ToString("N2") + "|" + item.borrow_amount.ToString("N2") + "|" + item.loan_amount.ToString("N2") + "|" + item.end_amount.ToString("N2") + "|" + item.day.Value.ToString("yyyy-MM-dd"));
            }

            var filename = date.ToString("yyyy-MM-dd") + " 物流供应商应付款明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");

        }


        /// <summary>
        /// 其他应收款明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult OtherReceivable(DateTime date, int paycompanyid)
        {

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        public string OtherReceivableJson(BtTableParameter request,DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListOtherCost(request,date, paycompanyid, 1,ref total);

            var list = obj.Select(a => new {
                company_name = (paycompany==null?"":paycompany.company_name),
                a.borrower_or_payer,
                start_amount = a.start_amount.ToString("N2"),
                debit_amount = a.debit_amount.ToString("N2"),
                credit_amount = a.credit_amount.ToString("N2"),
                end_amount = a.end_amount.ToString("N2"),
                day = a.day.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        public ActionResult OtherReceivableExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListOtherCost(request, date, paycompanyid, 1, ref total);

            //var list = obj.Select(a => new {
            //    company_name = (paycompany == null ? "" : paycompany.company_name),
            //    a.borrower_or_payer,
            //    start_amount = a.start_amount.ToString("N2"),
            //    debit_amount = a.debit_amount.ToString("N2"),
            //    credit_amount = a.credit_amount.ToString("N2"),
            //    end_amount = a.end_amount.ToString("N2"),
            //    day = a.day.ToString("yyyy-MM-dd")
            //});

            var colNames = new List<string> { "借款方", "期初金额", "借方发生额", "贷方发生额", "期末金额", "统计日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.borrower_or_payer + "|" + item.start_amount.ToString("N2") + "|" + item.debit_amount.ToString("N2") + "|" + item.credit_amount.ToString("N2") + "|" + item.end_amount.ToString("N2") + "|" + item.day.ToString("yyyy-MM-dd"));
            }

            var filename = date.ToString("yyyy-MM-dd") + " 其他应收款明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");


        }

        /// <summary>
        /// 其他应付款明细
        /// </summary>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <returns></returns>
        public ActionResult OtherPayable(DateTime date, int paycompanyid)
        {

            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;
            return View();
        }

        public string OtherPayableJson(BtTableParameter request,DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();

            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListOtherCost(request,date, paycompanyid, 2,ref total);
            var list = obj.Select(a => new {
                company_name = paycompany!=null?paycompany.company_name:"",
                a.borrower_or_payer,
                start_amount = a.start_amount.ToString("N2"),
                debit_amount = a.debit_amount.ToString("N2"),
                credit_amount = a.credit_amount.ToString("N2"),
                end_amount = a.end_amount.ToString("N2"),
                day = a.day.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

        public ActionResult OtherPayableExport(DateTime date, int paycompanyid)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var paycompany = _services.GetPayCompany(paycompanyid);
            var obj = _services.ListOtherCost(request, date, paycompanyid, 2, ref total);
            
            var colNames = new List<string> { "还款方","期初金额", "借方发生额", "贷方发生额", "期末金额", "日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.borrower_or_payer + "|" + item.start_amount.ToString("N2") + "|" + item.debit_amount.ToString("N2") + "|" + item.credit_amount.ToString("N2") + "|" + item.end_amount.ToString("N2") + "|" + item.day.ToString("yyyy-MM-dd"));
            }

            var filename = date.ToString("yyyy-MM-dd") + " 其他应付款明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");


        }

        /// <summary>
        /// 固定资产一级明细
        /// </summary>
        /// <returns></returns>
        public ActionResult ListFixedAssets(DateTime date,int paycompanyid)
        {
            ViewBag.date = date;
            ViewBag.paycompanyid = paycompanyid;

            return View();
        }

        /// <summary>
        /// 固定资产一级明细
        /// </summary>
        /// <param name="request"></param>
        /// <param name="date"></param>
        /// <param name="paycompanyid"></param>
        /// <param name="companyvalue"></param>
        /// <returns></returns>
        public string ListFixedAssetsJson(BtTableParameter request, DateTime date, int paycompanyid,int? companyvalue)
        {
            var total = 0;

            var obj = new Services.FinanceReportServices().ListFixedAssets(request, date, paycompanyid, companyvalue, ref total);

            var countM = new dc_fixed_assets_detail();
            if (obj.Count > 0)
            {
                countM = (new dc_fixed_assets_detail
                {
                    company_name = "合计：",
                    debit_amount = obj.Sum(a => a.debit_amount.Value),
                    credit_amount = obj.Sum(a => a.credit_amount.Value),
                });
            }
            
            var list = obj.Select(a => new {
                day = a.day.HasValue?a.day.Value.ToString("yyyy-MM-dd"):"",
                company_value = a.company_value.HasValue?a.company_value.Value+"":"",
                a.company_name,
                start_amount = a.start_amount.HasValue?a.start_amount.Value.ToString("N2"):"",
                debit_amount = a.debit_amount.HasValue?a.debit_amount.Value.ToString("N2"):"",
                credit_amount = a.credit_amount.HasValue ? a.credit_amount.Value.ToString("N2"):"",
                end_amount = a.end_amount.HasValue?a.end_amount.Value.ToString("N2"):"",
            });

            return JsonConvert.SerializeObject(new { total=total,rows = list, count_row = new {
                countM.company_name,
                debit_amount = countM.debit_amount.HasValue?countM.debit_amount.Value.ToString("N2"):"0",
                credit_amount = countM.credit_amount.HasValue?countM.credit_amount.Value.ToString("N2"):"0"
            } });
        }

        public ActionResult ListFixedAssetsExport(DateTime date, int paycompanyid, int? companyvalue)
        {
            var total = 0;
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var obj = new Services.FinanceReportServices().ListFixedAssets(request, date, paycompanyid, companyvalue, ref total);

            var colNames = new List<string> { "采购公司", "期初金额", "借方发生额", "贷方发生额", "期末金额", "统计日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.company_name + "|" + (item.start_amount.HasValue ? item.start_amount.Value.ToString("N2") : "") + "|" + (item.debit_amount.HasValue ? item.debit_amount.Value.ToString("N2") : "") + "|" + (item.credit_amount.HasValue ? item.credit_amount.Value.ToString("N2") : "") + "|" + (item.end_amount.HasValue ? item.end_amount.Value.ToString("N2") : "") + "|" + (item.day.HasValue ? item.day.Value.ToString("yyyy-MM-dd") : ""));
            }

            var filename = date.ToString("yyyy-MM-dd") + " 固定资产明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");


        }

        /// <summary>
        /// 固定资产二级明细
        /// </summary>
        /// <param name="companyvalue"></param>
        /// <returns></returns>
        public ActionResult ListFixedAssetsDetails(int companyvalue,DateTime date)
        {

            ViewBag.date = date;
            ViewBag.companyvalue = companyvalue;
            return View();
        }

        /// <summary>
        /// 固定资产二级明细
        /// </summary>
        /// <param name="request"></param>
        /// <param name="companyvalue"></param>
        /// <param name="date"></param>
        /// <returns></returns>
        public string ListFixedAssetsDetailsJson(BtTableParameter request, int? companyvalue, DateTime date)
        {
            var total = 0;
            var obj = new Services.FinanceReportServices().ListFixedAssetsDetails(request, date, companyvalue, ref total);

            var countM = new mFixedAssetsDetail();
            if (obj.Count>0)
            {
                countM = (new mFixedAssetsDetail {
                    buyno = "合计：",
                    amount = obj.Sum(a=>a.amount.Value)
                });

            }

            var list = obj.Select(a => new
            {
                a.buyno,
                pay_time = a.pay_time.HasValue?a.pay_time.Value.ToString("yyyy-MM-dd HH:mm:ss"):"",
                a.skuname,
                amount = a.amount.HasValue?a.amount.Value.ToString("N2"):"",
                creditamount = 0,
                day = a.day.HasValue?a.day.Value.ToString("yyyy-MM-dd"):""
            }).ToList();



            return JsonConvert.SerializeObject(new { total=total,rows=list,count_row=new {
                buyno = countM.buyno,
                amount = countM.amount.HasValue?countM.amount.Value.ToString("N2"):"0",
            }
            });
        }

        public ActionResult ListFixedAssetsDetailsExport(int? companyvalue, DateTime date)
        {
            var total = 0;
            var request = new BtTableParameter() { offset = 0, limit = 100000 };
            var obj = new Services.FinanceReportServices().ListFixedAssetsDetails(request, date, companyvalue, ref total);

            var colNames = new List<string> { "其他采购单号", "出纳付款时间", "采购物品", "本期借方发生额", "本期贷方发生额", "统计日期" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.buyno + "|" + (item.pay_time.HasValue ? item.pay_time.Value.ToString("yyyy-MM-dd HH:mm:ss") : "") + "|" + (item.skuname) + "|" + (item.amount.HasValue ? item.amount.Value.ToString("N2") : "") + "|" + "0" + "|" + (item.day.HasValue ? item.day.Value.ToString("yyyy-MM-dd") : ""));
            }

            var filename = date.ToString("yyyy-MM-dd") + " 固定资产二级明细" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, filename, filepath);

            return File("~/Files/Report/" + DateTime.Now.ToString("yyyy-MM-dd") + "/" + filename + ".csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", filename + ".csv");
            
        }

        #endregion

        #region 平台余额

        public ActionResult ListAccoutBalanceCount()
        {
            return View();
        }

        /// <summary>
        /// 平台账号余额管理列表数据
        /// </summary>
        /// <returns></returns>
        public string ListAccoutBalanceCountJson(BtTableParameter request, DateTime day, string platformcode)
        {

            var services = new Services.FinanceReportServices();
            var total = 0;
            var list = services.ListCount(day, platformcode, request.pageIndex, request.limit, request.sort, request.order, ref total);

            var countM = services.ListCounts(day, platformcode);

            countM.platformname = "总计：";
            countM.amount = Math.Round(countM.amount, 2, MidpointRounding.AwayFromZero);
            countM.amount_rmb = Math.Round(countM.amount_rmb, 2, MidpointRounding.AwayFromZero);
            countM.amount_sales = Math.Round(countM.amount_sales, 2, MidpointRounding.AwayFromZero);
            countM.before_balance = Math.Round(countM.before_balance, 2, MidpointRounding.AwayFromZero);
            countM.freeze_amount = Math.Round(countM.freeze_amount, 2, MidpointRounding.AwayFromZero);
            countM.freeze_amount_rmb = Math.Round(countM.freeze_amount_rmb, 2, MidpointRounding.AwayFromZero);
            countM.userable_amount = Math.Round(countM.userable_amount, 2, MidpointRounding.AwayFromZero);
            countM.userable_amount_rmb = Math.Round(countM.userable_amount_rmb, 2, MidpointRounding.AwayFromZero);
            countM.withdraw_amount = Math.Round(countM.withdraw_amount, 2, MidpointRounding.AwayFromZero);


            //pagination.records = total;
            //pagination.total = total / pagination.rows + (total % pagination.rows > 0 ? 1 : 0);

            var obj = list.Select(p => new {
                day = p.day.ToString("yyyy-MM-dd"),
                p.account,
                p.currency,
                p.amount,
                p.userable_amount,
                p.freeze_amount,
                p.exchangerate,
                p.amount_rmb,
                p.userable_amount_rmb,
                p.freeze_amount_rmb,
                p.platformcode,
                p.platformname,
                puttime = p.puttime.ToString("yyyy-MM-dd")
            });
            
            return JsonConvert.SerializeObject(new { total = obj.Count(), rows = obj,count_row=countM });
        }

        /// <summary>
        /// 上传平台账号余额明细
        /// </summary>
        /// <returns></returns>
        public JsonResult UpdateBalanceCount()
        {
            if (Request.Form.Files.Count == 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            var file = Request.Form.Files[0];
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true);
            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();
                var list = new List<dc_platform_balance>();
                var service = new Services.FinanceReportServices();
                var listRate = new List<Tuple<string, decimal>>();
                var commonServices = new Services.CommonServices();

                for (var i = 0; i < tb.Value.Rows.Count; i++)
                {
                    var row = tb.Value.Rows[i];

                    try
                    {
                        var platformcode = row["平台名称"].ToString();

                        if (string.IsNullOrEmpty(platformcode))
                        {
                            continue;
                        }

                        //var account = row["平台账号"].ToString();
                        var currency = row["币种"].ToString();
                        var day = DateTime.Parse(row["销售额统计日期"].ToString());

                        if (string.IsNullOrEmpty(platformcode))
                        {
                            return Json(new
                            {
                                success = false,
                                msg = "平台编码不能为空！",
                            });
                        }

                        if (string.IsNullOrEmpty(currency))
                        {
                            return Json(new {
                                success = false,
                                msg = "币种不能为空！"
                            });
                        }

                        var objplatform = service.GetPlatformByName(platformcode);
                        if (objplatform == null)
                        {
                            return Json(new
                            {
                                success = false,
                                msg = "系统找不到该销售平台【" + platformcode + "】，请检测平台名称是否正确或联系管理员。",
                            });
                        }

                        var rate = listRate.Where(a => a.Item1 == currency).FirstOrDefault();
                        if (rate == null)
                        {
                            var objRate = Services.CommonServices.GetExchangeRate(currency, "CNY");
                            rate = new Tuple<string, decimal>(currency, objRate);

                            listRate.Add(rate);
                        }

                        var m = new Services.FinanceReportServices().GetPlatformBalance(platformcode, currency, day);

                        //区分销售和财务
                        if ((row["平台每日到账额"].ToString() == "")) //销售
                        {
                            var amount = decimal.Parse(row["总余额"].ToString().Trim());
                            var userable = decimal.Parse(row["可用余额"].ToString().Trim());
                            var freezeamount = decimal.Parse(row["冻结余额"].ToString().Trim());
                            var saleday = DateTime.Parse(row["初始额统计日期"].ToString());
                            var puttime = DateTime.Parse(row["放款时间"].ToString());
                            var dailysale = decimal.Parse(row["平台每天总销售额"].ToString().Trim());
                            var notes = row["备注"].ToString();

                            if (puttime < DateTime.Parse("1999-01-01"))
                            {
                                return Json(new
                                {
                                    success = false,
                                    msg = "请填写正确的放款时间！",
                                });
                            }

                            if (m != null && m.amount_sales > 0)
                            {
                                return Json(new {
                                    success = false,
                                    msg = "平台【"+platformcode+"】，币种【"+m.currency+"】在"+day.ToShortDateString()+"已经导入了数据，请删除该数据后重新导入。"
                                });
                            }

                            list.Add(new dc_platform_balance
                            {
                                id= (m!=null?m.id:0),
                                account = "",
                                currency = currency,
                                amount = amount,
                                exchangerate = rate.Item2,
                                freeze_amount = freezeamount,
                                userable_amount = userable,
                                day = day,
                                delstatus = 0,
                                platformcode = objplatform.english_name,
                                platformname = objplatform.china_name,
                                paycompanyid = 2, //默认设置香港百伦

                                amount_rmb = amount * rate.Item2,
                                freeze_amount_rmb = freezeamount * rate.Item2,
                                userable_amount_rmb = userable * rate.Item2,
                                puttime = puttime,
                                notes = notes,
                                saleday = saleday,
                                fromsource = "",
                                amount_sales = dailysale,
                                withdraw_amount = (m!=null?m.withdraw_amount:0),
                                before_balance = (m!=null?m.before_balance:0),
                            });

                        }
                        else
                        {
                            var withdrawamount = decimal.Parse(row["平台每日到账额"].ToString());

                            if (m != null && m.withdraw_amount != 0)
                            {
                                return Json(new
                                {
                                    success = false,
                                    msg = "平台【" + platformcode + "】在" + day + "已经导入了数据，请删除该数据后重新导入。"
                                });
                            }

                            list.Add(new dc_platform_balance {
                                id = (m!=null?m.id:0),
                                account = "",
                                currency = currency,
                                amount = (m!=null?m.amount:0),
                                amount_rmb = (m!=null?m.amount_rmb:0),
                                amount_sales = (m!=null?m.amount_sales:0),
                                before_balance = (m!=null?m.before_balance:0),
                                day = day,
                                delstatus = 0,
                                exchangerate = rate.Item2,
                                freeze_amount =(m!=null?m.freeze_amount:0),
                                freeze_amount_rmb=(m!=null?m.freeze_amount_rmb:0),
                                fromsource = (m!=null?m.fromsource:""),
                                notes = (m!=null?m.notes:""),
                                paycompanyid = (m!=null?m.paycompanyid:0),
                                platformcode = objplatform.english_name,
                                platformname = objplatform.china_name,
                                puttime = (m!=null?m.puttime: DateTime.Parse("1999-01-01")),
                                saleday  = (m!=null?m.saleday: DateTime.Parse("1999-01-01")),
                                userable_amount = (m!=null?m.userable_amount:0),
                                userable_amount_rmb = (m!=null?m.userable_amount_rmb:0),
                                withdraw_amount = withdrawamount,
                            });
                        }
                        
                        //if (string.IsNullOrEmpty(account))
                        //{
                        //    return Json(new
                        //    {
                        //        success = false,
                        //        msg = "平台帐号不能为空！",
                        //    });
                        //}
                        
                    }
                    catch (Exception ex)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = "导入失败，异常信息：" + ex.Message
                        });
                    }
                }

                if (list.Count == 0)
                {
                    return Json(new
                    {
                        success = false,
                        msg = "表格没有数据。",
                    });

                }

                var result = service.AddPlatformBalances(list);
                return Json(new
                {
                    success = string.IsNullOrEmpty(result),
                    msg = result
                });
            }
            else
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件"
                });
            }
        }

        public string UpdateBalanceTest()
        {
            var result = new Services.FinanceReportServices().ListPlatformBalance(DateTime.Parse("2019-02-20"));

            return result;
        }

        /// <summary>
        /// 平台账号余额明细页面
        /// </summary>
        /// <returns></returns>
        public ActionResult ListAccountBalance()
        {
            return View();
        }

        /// <summary>
        /// 平台账号余额明细数据
        /// </summary>
        /// <param name="pagination"></param>
        /// <param name="day"></param>
        /// <param name="code"></param>
        /// <returns></returns>
        public string ListAccountBalanceJson(BtTableParameter request, DateTime day, string code)
        {
            var services = new Services.FinanceReportServices();
            var total = 0;
            var list = services.List(day, code, request.pageIndex, request.limit, request.sort, request.order, ref total);

            //pagination.records = total;
            //pagination.total = total / pagination.rows + (total % pagination.rows > 0 ? 1 : 0);

            var obj = list.Select(p => new {
                p.id,
                day = p.day.ToString("yyyy-MM-dd"),
                p.account,
                p.amount,
                p.amount_rmb,
                p.currency,
                p.exchangerate,
                p.freeze_amount,
                p.freeze_amount_rmb,
                p.userable_amount,
                p.userable_amount_rmb,
                p.platformcode,
                p.platformname,
                puttime = p.puttime.ToString("yyyy-MM-dd"),
                p.notes,
                p.amount_sales,
                p.before_balance,
                p.withdraw_amount,
                p.fromsource,
            });

            return JsonConvert.SerializeObject(new { total = obj.Count(), rows = obj });

        }

        /// <summary>
        /// 获取平台余额汇总
        /// </summary>
        /// <param name="day"></param>
        /// <param name="code"></param>
        /// <returns></returns>
        public JsonResult ListAccountBalanceSum(DateTime day, string code)
        {
            var m = new Services.FinanceReportServices().ListSum(day, code);

            return Json(m);
        }

        /// <summary>
        /// 删除账号余额记录
        /// </summary>
        /// <param name="id">账号余额id</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult DelAccountBalance(int id)
        {
            var service = new Services.FinanceReportServices();
            var result = service.DelPlatformBalance(id);

            return Json(new
            {
                success = string.IsNullOrEmpty(result),
                msg = result,
            });
        }

        /// <summary>
        /// 更新平台余额的提现金额
        /// </summary>
        /// <param name="id"></param>
        /// <param name="balance"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SavePlatformBalance(int id, decimal balance)
        {
            var service = new Services.FinanceReportServices();
            var result = service.UpdatePlatformBalance(id, balance);

            return Json(new
            {
                success = string.IsNullOrEmpty(result),
                msg = result,
            });
        }

        #endregion

        #region 每日销售额

        /// <summary>
        /// 每日销售额统计
        /// </summary>
        public ActionResult DailySalesCount()
        {
            return View();
        }

        /// <summary>
        /// 每日销售额统计
        /// </summary>
        /// <returns></returns>
        public string DailySalesCountJson(BtTableParameter request, DateTime day, string platformcode)
        {
            var services = new Services.FinanceReportServices();
            var total = 0;
            var list = services.ListDailyPlatformAmountCount(day, platformcode, request.pageIndex, request.limit, request.sort, request.order, ref total);

            var obj = list.Select(p => new {
                day = p.day.ToString("yyyy-MM-dd"),
                p.account,
                p.currency,
                p.platformcode,
                p.platformname,
                p.put_amount,
                p.put_amount_rmb,
                put_amount_time = p.put_amount_time.ToString("yyyy-MM-dd"),
                p.freeze_amount,
            });
            
            return JsonConvert.SerializeObject(new { total = obj.Count(), rows = obj });
        }

        /// <summary>
        /// 每日销售额明细
        /// </summary>
        /// <returns></returns>
        public ActionResult DailySales()
        {
            return View();
        }

        /// <summary>
        /// 每日销售额明细
        /// </summary>
        /// <param name="pagination"></param>
        /// <param name="day"></param>
        /// <param name="code"></param>
        /// <returns></returns>
        public string DailySalesJson(BtTableParameter request, DateTime day, string code)
        {
            var services = new Services.FinanceReportServices();
            var total = 0;
            var list = services.ListDailyPlatformAmount(day, code, request.pageIndex, request.limit, request.sort, request.order, ref total);

            var obj = list.Select(p => new {
                day = p.day.ToString("yyyy-MM-dd"),
                put_amount_time = p.put_amount_time.ToString("yyyy-MM-dd"),
                p.account,
                p.currency,
                p.platformcode,
                p.platformname,
                p.freeze_amount,
                p.freeze_amount_rmb,
                p.putcount,
                p.put_amount,
                p.put_amount_rmb,
                p.id,
            });

            return JsonConvert.SerializeObject(new { total = obj.Count(), rows = obj });
        }

        /// <summary>
        /// 上传每日销售额
        /// </summary>
        /// <returns></returns>
        public JsonResult UploadDailySales()
        {
            if (Request.Form.Files.Count == 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            var file = Request.Form.Files[0];
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true);
            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();
                var list = new List<dc_daily_platformamout>();
                var service = new Services.FinanceReportServices();
                var listRate = new List<Tuple<string, decimal>>();
                var commonServices = new Services.CommonServices();

                for (var i = 0; i < tb.Value.Rows.Count; i++)
                {
                    var row = tb.Value.Rows[i];

                    try
                    {
                        var platformcode = row["平台名称"].ToString();
                        var account = row["平台账号"].ToString();
                        var currency = row["币种"].ToString();
                        var puttime = DateTime.Parse(row["放款时间"].ToString());
                        var put_amount = decimal.Parse(row["放款金额"].ToString());
                        var freeze_amount = decimal.Parse(row["冻结金额"].ToString());
                        var count = int.Parse(row["月放款次数"].ToString());
                        var day = DateTime.Parse(row["统计日期"].ToString());


                        if (string.IsNullOrEmpty(platformcode))
                        {
                            return Json(new
                            {
                                success = false,
                                msg = "平台编码不能为空！",
                            });
                        }

                        if (puttime < DateTime.Parse("1999-01-01"))
                        {
                            return Json(new
                            {
                                success = false,
                                msg = "请填写正确的放款时间！",
                            });
                        }

                        var objplatform = service.GetPlatformByName(platformcode);
                        if (objplatform == null)
                        {
                            return Json(new
                            {
                                success = false,
                                msg = "系统找不到该销售平台【" + platformcode + "】，请检测平台名称是否正确或联系管理员。",
                            });
                        }

                        var rate = listRate.Where(a => a.Item1 == currency).FirstOrDefault();
                        if (rate == null)
                        {
                            var objRate = Services.CommonServices.GetExchangeRate(currency, "CNY");
                            rate = new Tuple<string, decimal>(currency, objRate);

                            listRate.Add(rate);
                        }

                        list.Add(new dc_daily_platformamout
                        {
                            account = account,
                            currency = currency,
                            day = day,
                            delstatus = 0,
                            platformcode = objplatform.english_name,
                            platformname = objplatform.china_name,
                            put_amount_time = puttime,
                            put_amount = put_amount,
                            put_amount_rmb = put_amount * rate.Item2,
                            freeze_amount = freeze_amount,
                            freeze_amount_rmb = freeze_amount * rate.Item2,
                            putcount = count,
                        });

                    }
                    catch (Exception ex)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = "导入失败，异常信息：" + ex.Message
                        });
                    }
                }

                if (list.Count == 0)
                {
                    return Json(new
                    {
                        success = false,
                        msg = "表格没有数据。",
                    });

                }

                var result = service.AddDailySale(list);
                return Json(new
                {
                    success = string.IsNullOrEmpty(result),
                    msg = result
                });
            }
            else
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件"
                });
            }
        }

        /// <summary>
        /// 删除每日销售额
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult DelDailySales(int id)
        {
            var service = new Services.FinanceReportServices();
            var result = service.DeleteDailySale(id);

            return Json(new
            {
                success = string.IsNullOrEmpty(result),
                msg = result,
            });
        }

        #endregion

        
        #region Common

        /// <summary>
        /// 获取平台列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListPlatform()
        {
            var service = new Services.FinanceReportServices();
            var list = service.ListPlatforms().Select(p => new {
                code = p.english_name,
                name = p.china_name
            });

            return Json(list);
        }

        /// <summary>
        /// 获取采购公司列表（固定资产）
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListCompanyValue()
        {
            var list = Services.CommonServices.ListCompanyValue();

            return Json(list);
        }


        #endregion

    }
}