﻿using System;
using System.Collections.Generic;
using System.Text;
using Bailun.DC.Models;
using Dapper;
using MySql.Data.MySqlClient;
using System.Linq;
using Bailun.DC.Models.Warehouse;

namespace Bailun.DC.Services
{
    public class WareHouseServices
    {

        /// <summary>
        /// 获取环球仓库类型
        /// </summary>
        /// <returns></returns>
        public List<string> ListWareHouseType()
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = "select hq_type from dc_base_warehouse group by hq_type";

                return cn.Query<string>(sql).AsList();

            }
        }

        /// <summary>
        /// 获取仓库列表
        /// </summary>
        /// <param name="warehousetype">仓库类型</param>
        /// <returns></returns>
        public List<dc_base_warehouse> List(string warehousetype,int? areaid)
        {
            var param = new DynamicParameters();

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = "select * from dc_base_warehouse where 1=1 ";

                if (!string.IsNullOrWhiteSpace(warehousetype))
                {
                    sql += " and hq_type=@type";
                    param.Add("type", warehousetype);
                }
                if (areaid.HasValue)
                {
                    sql += " and area_id="+areaid.Value;
                }

                
                return cn.Query<dc_base_warehouse>(sql,param).AsList();
            }
        }

        /// <summary>
        /// 获取逻辑仓库库存
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="warehousetype">仓库类型</param>
        /// <param name="warehouse">仓库编码</param>
        /// <param name="total">符合条件的记录总数</param>
        /// <returns></returns>
        public List<Models.Stock.mLogicWarehouse> ListLogicWarehouseStock(BtTableParameter parameter, string warehousetype, string warehouse,ref int total)
        {
            var sqlparam = new DynamicParameters();
            var sqlwhere = " where 1=1 ";
            var sql = @"select hq_type,warehouse_code,warehouse_name,sum(usable_stock) usable_stock,sum(amount_stock) amount_stock,sum(quantity_purchase) quantity_purchase,sum(purchase_amount) purchase_amount,sum(quantity_transfer) quantity_transfer,sum(amount_transit) amount_transit,sum(oneday_total_sales) oneday_total_sales,sum(amount_onedaysale) amount_onedaysale,sum(sevenday_total_sales) sevenday_total_sales,sum(fourteenday_total_sales) fourteenday_total_sales,sum(thirtyday_total_sales) thirtyday_total_sales from dc_skuwarehouse_stock_sales  ";

            //var sqlcount = "select t1.warehouse_code from dc_skuwarehouse_stock_sales t1 ";

            if (!string.IsNullOrWhiteSpace(warehousetype))
            {
                sqlwhere += " and hq_type=@hq_type";
                sqlparam.Add("hq_type", warehousetype);
            }
            if (!string.IsNullOrWhiteSpace(warehouse))
            {
                sqlwhere += " and warehouse_code=@warehouse_code";
                sqlparam.Add("warehouse_code", warehouse);
            }

            sqlwhere += " group by warehouse_code";

            var sqlorder = "";

            if (!string.IsNullOrWhiteSpace(parameter.sort))
            {
                sqlorder += " order by " + parameter.sort;

                if (!string.IsNullOrWhiteSpace(parameter.order))
                {
                    sqlorder += " " + parameter.order;
                }
            }
            else
            {
                sqlwhere += " order by usable_stock desc";
            }


            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.Page<Models.Stock.mLogicWarehouse>(parameter.pageIndex, parameter.limit, sql+ sqlwhere+ sqlorder, ref total, sqlparam);
                return obj.AsList();
            }
        }

        /// <summary>
        /// 逻辑仓库库存 统计
        /// </summary>
        /// <param name="warehousetype"></param>
        /// <param name="warehouse"></param>
        /// <returns></returns>
        public Models.Stock.mLogicWarehouse LogicWarehouseStockCount(string warehousetype, string warehouse)
        {
            var sqlparam = new DynamicParameters();
            var sqlwhere = " where 1=1 ";
            var sql = @"select sum(usable_stock) usable_stock,sum(amount_stock) amount_stock,sum(quantity_purchase) quantity_purchase,sum(purchase_amount) purchase_amount,sum(quantity_transfer) quantity_transfer,sum(amount_transit) amount_transit,sum(oneday_total_sales) oneday_total_sales,sum(amount_onedaysale) amount_onedaysale,sum(sevenday_total_sales) sevenday_total_sales,sum(fourteenday_total_sales) fourteenday_total_sales,sum(thirtyday_total_sales) thirtyday_total_sales from dc_skuwarehouse_stock_sales ";

            if (!string.IsNullOrWhiteSpace(warehousetype))
            {
                sqlwhere += " and hq_type=@hq_type";
                sqlparam.Add("hq_type", warehousetype);
            }
            if (!string.IsNullOrWhiteSpace(warehouse))
            {
                sqlwhere += " and warehouse_code=@warehouse_code";
                sqlparam.Add("warehouse_code", warehouse);
            }
            
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirst<Models.Stock.mLogicWarehouse>(sql + sqlwhere, sqlparam,null,2*60);
                return obj;
            }
        }

        /// <summary>
        /// Sku仓库列表
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="code">仓库编码</param>
        /// <param name="categoryid">分类id</param>
        /// <param name="minordercount">14日均销量 min值</param>
        /// <param name="maxordercount">14日均销量 max值</param>
        /// <param name="stockmin">库存 min值</param>
        /// <param name="stockmax">库存 max值</param>
        /// <param name="stockamountmin">库存金额 min值</param>
        /// <param name="stockamountmax">库存金额 max值</param>
        /// <param name="total">符合条件的总记录数</param>
        /// <returns></returns>
        public List<Models.Stock.mSkuWarehouse> ListWareHouseSku(BtTableParameter parameter, string code, int? categoryid, int? minordercount, int? maxordercount, int? stockmin, int? stockmax, decimal? stockamountmin, decimal? stockamountmax, string skucategoryids,int? push_status, ref int total)
        {
            var sqlparam = new DynamicParameters();

            var sql = @"select t1.*,t2.category_name,t2.sku_image,t2.sku_title_cn,t2.sku_title_en  ";

            var sqlwhere = @" from dc_skuwarehouse_stock_sales t1
                                         left join dc_base_sku t2 on t1.bailun_sku = t2.bailun_sku where 1=1 ";

            if (!string.IsNullOrWhiteSpace(code))
            {
                sqlwhere += " and t1.warehouse_code=@warehouse_code";
                sqlparam.Add("warehouse_code", code);
            }

            if (categoryid.HasValue)
            {
                sqlwhere += " and t2.category_id=@category_id";
                sqlparam.Add("category_id", categoryid.Value);
            }

            if (minordercount.HasValue && minordercount.Value>0)
            {
                sqlwhere += " and t1.fourteenday_average_sales>=@minordercount";
                sqlparam.Add("minordercount", minordercount.Value);
            }

            if (maxordercount.HasValue && maxordercount.Value > 0)
            {
                sqlwhere += " and t1.fourteenday_average_sales<@maxordercount";
                sqlparam.Add("maxordercount", maxordercount.Value);
            }

            if (stockmin.HasValue)
            {
                sqlwhere += " and t1.usable_stock>=@stockmin";
                sqlparam.Add("stockmin", stockmin.Value);
            }
            if (stockmax.HasValue)
            {
                sqlwhere += " and t1.usable_stock<@stockmax";
                sqlparam.Add("stockmax", stockmax.Value);
            }
            if (stockamountmin.HasValue)
            {
                sqlwhere += " and t1.amount_stock>=@stockamountmin";
                sqlparam.Add("stockamountmin", stockamountmin.Value);
            }
            if (stockamountmax.HasValue)
            {
                sqlwhere += " and t1.amount_stock<@stockamountmax";
                sqlparam.Add("stockamountmax", stockamountmax.Value);
            }
            if (!string.IsNullOrWhiteSpace(skucategoryids))
            {
                var arr = skucategoryids.Split('|').Where(a => !string.IsNullOrEmpty(a)).ToList();
                if (arr.Count > 0)
                {
                    //获取选中分类下所有的分类
                    var AllCategory = Services.CommonServices.GetCategoryList(0);
                    var listcategory = new List<Models.Common.CategoryDto>();

                    foreach (var item in arr)
                    {
                        listcategory.AddRange(Services.CommonServices.GetCategoryListAll(AllCategory, int.Parse(item)));
                    }

                    var s = string.Join(",", listcategory.Select(a => a.C_ID));
                    if (!string.IsNullOrEmpty(s))
                    {
                        sqlwhere += " and t2.category_id in (" + s + ")";
                    }
                }
            }
            if (push_status.HasValue)
            {
                sqlwhere += " and t2.push_status="+push_status.Value;
            }


            var sqlsort = "";

            if (!string.IsNullOrEmpty(parameter.sort))
            {
                sqlsort += " order by " + parameter.sort + " " + parameter.order;
            }
            else
            {
                sqlsort += " order by usable_stock desc";
            }

            
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.Page<Models.Stock.mSkuWarehouse>(parameter.pageIndex, parameter.limit, sql + sqlwhere+ sqlsort, ref total, sqlparam, "select count(*) from (select t1.id " + sqlwhere + ") tb");

                return obj.AsList();
            }
        }

        /// <summary>
        /// 根据仓库设置属性获取仓库列表
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        public List<dc_base_warehouse> ListWarehouseByExtType(string type)
        {
            var param = new DynamicParameters();

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = "select * from dc_base_warehouse ";

                if (!string.IsNullOrWhiteSpace(type))
                {
                    sql += " where warehouse_type_ex=@type";
                    param.Add("type", type);
                }


                return cn.Query<dc_base_warehouse>(sql, param).AsList();
            }
        }

        /// <summary>
        /// 获取仓库所在国家
        /// </summary>
        /// <returns></returns>
        public List<mWareHouseArea> ListWarehouseArea()
        {
            var sql = "select area_id as id,area_name as name from dc_base_warehouse where area_id is not null group by area_id ";

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.Query<mWareHouseArea>(sql);

                return obj.AsList();
            }
            
        }

        /// <summary>
        /// 数据仓分组列表
        /// </summary>
        /// <returns></returns>
        public List<string> ListGroupName()
        {
            var sql = "select groupname from dc_sku_monitor group by groupname";
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.Query<string>(sql);

                return obj.AsList();
            }
        }

        /// <summary>
        /// 获取仓库详情
        /// </summary>
        /// <param name="code">仓库编码</param>
        /// <returns></returns>
        public dc_base_warehouse GetWarehouse(string code)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = "select * from dc_base_warehouse where warehouse_code=@warehouse_code";
                var sqlparam = new DynamicParameters();
                sqlparam.Add("warehouse_code", code);

                return cn.QueryFirstOrDefault<dc_base_warehouse>(sql, sqlparam);

            }

        }

        /// <summary>
        /// 获取逻辑仓库里面有的仓库
        /// </summary>
        /// <param name="warehousetype"></param>
        /// <returns></returns>
        public List<dc_base_warehouse> ListWarehouseFromStockAndSales(string warehousetype)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sqlparam = new DynamicParameters();
                var sql = "select warehouse_code,warehouse_name from dc_skuwarehouse_stock_sales where 1=1 ";
                if (!string.IsNullOrEmpty(warehousetype))
                {
                    sql += " and hq_type=@hq_type";
                    sqlparam.Add("hq_type",warehousetype);
                }

                sql += "  group by warehouse_code";

                return cn.Query<dc_base_warehouse>(sql, sqlparam).AsList();
            }

        }

        /// <summary>
        /// 获取仓库 库存分析报表
        /// </summary>
        /// <param name="request">分页信息</param>
        /// <param name="warehousetype">仓库类型</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="total">符合条件的总记录数</param>
        /// <returns></returns>
        public List<dc_mid_warehouse_redundancy> ListWarehouseRedundancy(BtTableParameter request, string warehousetype, string warehousecode,DateTime? day,ref int total)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sqlparam = new DynamicParameters();
                var sql = "select t1.* from dc_mid_warehouse_redundancy t1 ";

                if (!string.IsNullOrEmpty(warehousetype))
                {
                    sql += " join dc_base_warehouse t2 on t1.warehouse_code=t2.warehouse_code and t2.hq_type=@warehousetype";
                    sqlparam.Add("warehousetype", warehousetype);
                }

                sql+= " where 1=1 ";

                if (day.HasValue)
                {
                    sql += " and t1.day=@day";
                    sqlparam.Add("day", day.Value.ToString("yyyy-MM-dd"));
                }

                if (!string.IsNullOrEmpty(warehousecode))
                {
                    sql += " and t1.warehouse_code=@code";
                    sqlparam.Add("code", warehousecode);
                }

                if (!string.IsNullOrEmpty(request.sort))
                {
                    sql += " order by t1."+request.sort+" "+request.order;
                }


                var obj = cn.Page<dc_mid_warehouse_redundancy>(request.pageIndex, request.limit, sql, ref total,sqlparam);

                return obj.AsList();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="warehousetype"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public dc_mid_warehouse_redundancy ListWarehouseRedundancyCount(string warehousetype, string warehousecode,DateTime? day)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sqlparam = new DynamicParameters();
                var sql = @"select sum(skucount) skucount,sum(productcount) productcount,sum(amount_total) amount_total,sum(skusales_count) skusales_count,(sum(skusales_count)/sum(skucount))skusales_rate,sum(daily_productsale_count) daily_productsale_count,(sum(daily_productsale_count)/sum(productcount)) productsale_rate,sum(dailysale_amount) dailysale_amount,(sum(dailysale_amount)/sum(amount_total)) saleamount_rate, sum(redundancy_sku_count) redundancy_sku_count,(sum(redundancy_sku_count)/sum(skucount)) redundancy_sku_rate,sum(redundancy_product_count) redundancy_product_count,(sum(redundancy_product_count)/sum(productcount)) redundancy_product_rate,sum(redundancy_amount) redundancy_amount,(sum(redundancy_amount)/sum(amount_total)) redundancy_amount_rate  from dc_mid_warehouse_redundancy t1 ";

                if (!string.IsNullOrEmpty(warehousetype))
                {
                    sql += " join dc_base_warehouse t2 on t1.warehouse_code=t2.warehouse_code and t2.hq_type=@warehousetype";
                    sqlparam.Add("warehousetype", warehousetype);
                }

                sql += " where 1=1 ";

                if (day.HasValue)
                {
                    sql += " and t1.day=@day";
                    sqlparam.Add("day", day.Value.ToString("yyyy-MM-dd"));
                }

                if (!string.IsNullOrEmpty(warehousecode))
                {
                    sql += " and t1.warehouse_code=@code";
                    sqlparam.Add("code", warehousecode);
                }

                var obj = cn.QueryFirstOrDefault<dc_mid_warehouse_redundancy>(sql,sqlparam);

                return obj;
            }
        }

        /// <summary>
        /// 获取sku冗余前100的数据
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public List<List<dc_mid_skuwarehouse_redundancy>> GetSkuRedundancy(string warehousecode,DateTime day)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                //前100冗余金额sku分析
                var sql1 = "select bailun_sku,productcount,amount_total,daily_productsale_count,productsale_rate,dailysale_amount,saleamount_rate,redundancy_product_count,redundancy_product_rate,redundancy_amount,redundancy_amount_rate from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode+ "' and day='"+day.ToString("yyyy-MM-dd")+ "' order by redundancy_amount desc limit 100";

                //前100冗余个数sku分析
                var sql2 = "select bailun_sku,productcount,amount_total,daily_productsale_count,productsale_rate,dailysale_amount,saleamount_rate,redundancy_product_count,redundancy_product_rate,redundancy_amount,redundancy_amount_rate from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode + "' and day='" + day.ToString("yyyy-MM-dd") + "' order by redundancy_product_count desc limit 100";

                //前100个数动销最快sku分析
                var sql3 = "select bailun_sku,productcount,amount_total,yesterdaysale_count,yesterdaysale_amount,sale_3d_avg,sale_7d_avg,sale_14d_avg,sale_30d_avg,day_turnover_rate,week_turnover_rate,month_turnover_rate,stockout from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode + "' and day='" + day.ToString("yyyy-MM-dd") + "' order by productsale_rate desc limit 100";

                //前100金额动销最快sku分析
                var sql4 = "select bailun_sku,productcount,amount_total,yesterdaysale_count,yesterdaysale_amount,sale_3d_avg,sale_7d_avg,sale_14d_avg,sale_30d_avg,day_turnover_rate,week_turnover_rate,month_turnover_rate,stockout from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode + "' and day='" + day.ToString("yyyy-MM-dd") + "' order by saleamount_rate desc limit 100";

                var obj1 = cn.Query<dc_mid_skuwarehouse_redundancy>(sql1);
                var obj2 = cn.Query<dc_mid_skuwarehouse_redundancy>(sql2);
                var obj3 = cn.Query<dc_mid_skuwarehouse_redundancy>(sql3);
                var obj4 = cn.Query<dc_mid_skuwarehouse_redundancy>(sql4);

                var list = new List<List<dc_mid_skuwarehouse_redundancy>>();

                list.Add(obj1.AsList());
                list.Add(obj2.AsList());
                list.Add(obj3.AsList());
                list.Add(obj4.AsList());

                return list;
            }
        }

        /// <summary>
        /// 获取sku冗余前100的数据
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <param name="day"></param>
        /// <param name="t"></param>
        /// <returns></returns>
        public List<dc_mid_skuwarehouse_redundancy> GetSkuRedundancyByType(string warehousecode, DateTime day, int? t)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                //前100冗余金额sku分析
                var sql1 = "select bailun_sku,productcount,amount_total,daily_productsale_count,productsale_rate,dailysale_amount,saleamount_rate,redundancy_product_count,redundancy_product_rate,redundancy_amount,redundancy_amount_rate,onway_count,sku_product_code,bailun_sku_name,monitorstatus,tortstatus from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode + "' and day='" + day.ToString("yyyy-MM-dd") + "' order by redundancy_amount desc limit 100";

                //前100冗余个数sku分析
                var sql2 = "select bailun_sku,productcount,amount_total,daily_productsale_count,productsale_rate,dailysale_amount,saleamount_rate,redundancy_product_count,redundancy_product_rate,redundancy_amount,redundancy_amount_rate,onway_count,sku_product_code,bailun_sku_name,monitorstatus,tortstatus from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode + "' and day='" + day.ToString("yyyy-MM-dd") + "' order by redundancy_product_count desc limit 100";

                //前100个数动销最快sku分析
                var sql3 = "select bailun_sku,productcount,amount_total,yesterdaysale_count,yesterdaysale_amount,sale_3d_avg,sale_7d_avg,sale_14d_avg,sale_30d_avg,day_turnover_rate,week_turnover_rate,month_turnover_rate,stockout,onway_count,sku_product_code,bailun_sku_name,monitorstatus,tortstatus from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode + "' and day='" + day.ToString("yyyy-MM-dd") + "' order by productsale_rate desc limit 100";

                //前100金额动销最快sku分析
                var sql4 = "select bailun_sku,productcount,amount_total,yesterdaysale_count,yesterdaysale_amount,sale_3d_avg,sale_7d_avg,sale_14d_avg,sale_30d_avg,day_turnover_rate,week_turnover_rate,month_turnover_rate,stockout,onway_count,sku_product_code,bailun_sku_name,monitorstatus,tortstatus from dc_mid_skuwarehouse_redundancy where warehouse_code='" + warehousecode + "' and day='" + day.ToString("yyyy-MM-dd") + "' order by saleamount_rate desc limit 100";

                
                var list = new List<dc_mid_skuwarehouse_redundancy>();

                if (t.Value == 0)
                {
                    list = cn.Query<dc_mid_skuwarehouse_redundancy>(sql1).AsList();
                }
                else if (t.Value == 1)
                {
                    list = cn.Query<dc_mid_skuwarehouse_redundancy>(sql2).AsList();
                }
                else if (t.Value == 2)
                {
                    list = cn.Query<dc_mid_skuwarehouse_redundancy>(sql3).AsList();
                }
                else if (t.Value == 3)
                {
                    list = cn.Query<dc_mid_skuwarehouse_redundancy>(sql4).AsList();
                }

                return list;
            }
        }

        /// <summary>
        /// 获取仓库前两个月的冗余数据
        /// </summary>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="start">开始日期</param>
        /// <param name="end">结束日期</param>
        /// <returns></returns>
        public List<dc_mid_warehouse_redundancy> ListOver60DaysWarehouseRedundancy(string warehousecode, DateTime start, DateTime end)
        {
             using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sqlparam = new DynamicParameters();
                var sql = "select * from dc_mid_warehouse_redundancy where warehouse_code=@code and day>=@startday and day<=@endday order by day";

                sqlparam.Add("code", warehousecode);
                sqlparam.Add("startday", start);
                sqlparam.Add("endday", end);

                var obj = cn.Query<dc_mid_warehouse_redundancy>(sql, sqlparam);

                return obj.AsList();
            }
        }

    }
}
