﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using Bailun.DC.Models.DataWareHouse;
using Bailun.DC.Models;
using Bailun.DC.Common;

namespace Bailun.DC.Services.DataWareHouse
{
    public class TbConfigServices
    {
        #region 数据仓库-表结构配置

        /// <summary>
        /// 获取表配置列表
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="code">code关键字</param>
        /// <param name="total">符合条件的记录数</param>
        /// <returns></returns>
        public List<sys_table_info> ListTbConfig(BtTableParameter parameter, string code,ref int total)
        {
            var sql = "select * from sys_table_info where 1=1 ";
            var sqlparam = new DynamicParameters();

            if (!string.IsNullOrEmpty(code))
            {
                sql += " and code like @code ";
                sqlparam.Add("code", "%"+code+"%");
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.Page<sys_table_info>(parameter.pageIndex, parameter.limit, sql, ref total).AsList();

                return obj;
            }

        }

        /// <summary>
        /// 获取库存结构详情
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public sys_table_info GetTbConfig(int id)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirstOrDefault<sys_table_info>("select * from sys_table_info where id=" + id);

                return obj;
            }
        }

        /// <summary>
        /// 保存库存配置信息
        /// </summary>
        /// <param name="m"></param>
        /// <param name="username"></param>
        /// <returns></returns>
        public string SaveTbConfig(sys_table_info m,string username)
        {
            try
            {
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    var obj = cn.QueryFirstOrDefault<sys_table_info>("select * from sys_table_info where code='" + m.code+"'");


                    if (obj == null)
                    {
                        obj = new sys_table_info
                        {
                            createtime = DateTime.Now,
                            createusername = username,
                            code = m.code,
                        };
                    }

                    obj.name = m.name??"";
                    obj.decimals = m.decimals;
                    obj.fieldtype = m.fieldtype??"";
                    obj.lastupdatetime = DateTime.Now;
                    obj.lastupdateusername = username;
                    obj.length = m.length;
                    obj.note = m.note??"";
                    obj.type = m.type;

                    if (obj.id > 0)
                    {
                        cn.Update(obj);
                    }
                    else
                    {
                        cn.Insert(obj);
                    }
                }

                return "";
            }
            catch (Exception ex)
            {

                return ex.Message;
            }
            
        }

        #endregion




    }
}
