﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;

namespace Bailun.DC.Web.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }

        [HttpPost]
        public JsonResult ListWarehouseType()
        {
            var result = new Services.WareHouseServices().ListWareHouseType().Where(a=>!string.IsNullOrEmpty(a));
            return Json(result);
        }

        /// <summary>
        /// 获取仓库列表
        /// </summary>
        /// <param name="warehousetype"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListWareHouse(string warehousetype)
        {
            var result = new Services.WareHouseServices().List(warehousetype);

            var list = result.Select(p => new {
                p.warehouse_code,
                p.warehouse_name
            });

            return Json(list);
        }

        /// <summary>
        /// 获取sku分类列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListSkuCategory()
        {
            var result = new Services.SkuInfoServices().ListSkuCategory();
            return Json(result);
        }
    }
}