﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Bailun.DC.Services;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class WarehouseController : Controller
    {

        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// 逻辑仓库 库存
        /// </summary>
        /// <returns></returns>
        public ActionResult LogicWarehouse()
        {
            return View();
        }

        /// <summary>
        /// 逻辑仓库 库存列表
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="warehousetype">仓库类型</param>
        /// <param name="warehouse">仓库编码</param>
        /// <returns></returns>
        public string LogicWarehouseJson(BtTableParameter parameter,string warehousetype,string warehousecode)
        {
            var service = new Services.WareHouseServices();
            var total = 0;
            var obj = service.ListLogicWarehouseStock(parameter, warehousetype, warehousecode, ref total);

            var countM = service.LogicWarehouseStockCount(warehousetype, warehousecode);

            countM.warehouse_name = "总计";
            countM.amount_onedaysale = Math.Round(countM.amount_onedaysale??0, 2, MidpointRounding.AwayFromZero);
            countM.amount_stock = Math.Round(countM.amount_stock , 2, MidpointRounding.AwayFromZero);
            countM.amount_transit = Math.Round(countM.amount_transit??0, 2, MidpointRounding.AwayFromZero);
            countM.purchase_amount = Math.Round(countM.purchase_amount ?? 0, 2, MidpointRounding.AwayFromZero);

            var list = obj.Select(p => new {
                amount_onedaysale = p.amount_onedaysale??0,
                amount_stock = p.amount_stock,
                amount_transit = p.amount_transit??0.00M,
                fourteenday_total_sales = p.fourteenday_total_sales??0,
                noshippingcount = p.noshippingcount??0,
                nostockcount = p.nostockcount??0,
                oneday_total_sales = p.oneday_total_sales??0,
                purchase_amount = p.purchase_amount??0,
                quantity_purchase = p.quantity_purchase??0,
                quantity_transfer = p.quantity_transfer??0,
                sevenday_total_sales = p.sevenday_total_sales??0,
                thirtyday_total_sales = p.thirtyday_total_sales??0,
                p.usable_stock,
                p.warehouse_code,
                p.warehouse_name,
            });
            
            return JsonConvert.SerializeObject(new { total = total, rows = list, count_row = countM }); 
        }

        /// <summary>
        /// Sku仓库
        /// </summary>
        /// <param name="code">仓库编码</param>
        /// <returns></returns>
        public ActionResult ListWareHouseSku(string code)
        {
            ViewBag.warehousecode = code;
            return View();
        }

        /// <summary>
        /// Sku仓库
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="code">仓库编码</param>
        /// <param name="categoryid">sku分类id</param>
        /// <param name="minordercount">14日均销量 最小值</param>
        /// <param name="maxordercount">14日均销量 最大值</param>
        /// <param name="stockmin">库存 最小值</param>
        /// <param name="stockmax">库存 最大值</param>
        /// <param name="stockamountmin">库存金额 最小值</param>
        /// <param name="stockamountmax">库存金额 最大值</param>
        /// <returns></returns>
        public string ListWareHouseSkuJson(BtTableParameter parameter, string code, int? categoryid, int? minordercount, int? maxordercount, int? stockmin, int? stockmax, decimal? stockamountmin, decimal? stockamountmax)
        {
            var total = 0;
            var obj = new Services.WareHouseServices().ListWareHouseSku(parameter, code, categoryid, minordercount, maxordercount, stockmin, stockmax, stockamountmin, stockamountmax, ref total);

            var list = obj.Select(p => new {
                amount_onedaysale = p.amount_onedaysale??0,
                amount_stock = p.amount_stock??0,
                amount_transit = p.amount_transit??0,
                p.bailun_sku,
                p.category_name,
                noshippingcount = p.noshippingcount??0,
                nostockcount = p.nostockcount??0,
                oneday_total_sales = p.oneday_total_sales??0,
                purchase_amount = p.purchase_amount??0,
                quantity_purchase = p.quantity_purchase??0,
                quantity_transfer = p.quantity_transfer??0,
                sevenday_total_sales = p.sevenday_total_sales??0,

                p.sku_image,
                p.sku_title_cn,
                p.sku_title_en,
                thirtyday_total_sales = p.thirtyday_total_sales??0,
                usable_stock = p.usable_stock??0,
                p.warehouse_code,
                p.warehouse_name,
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }

    }
}