﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Bailun.DC.Services;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class SkuController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// Sku列表
        /// </summary>
        /// <returns></returns>
        public ActionResult ListSku()
        {
            return View();
        }

        /// <summary>
        /// sku列表
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="sku"></param>
        /// <param name="skuname"></param>
        /// <returns></returns>
        public string ListSkuJson(BtTableParameter parameter,string sku,string skuname)
        {
            var total = 0;
            var services = new Services.SkuInfoServices();
            var obj = services.ListSku(parameter,sku,skuname,ref total);

            var countM = services.ListSkuCount(sku, skuname);

            countM.sku_title_cn = "总计：";
            countM.amount_onedaysale = Math.Round(countM.amount_onedaysale ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.amount_stock = Math.Round(countM.amount_stock ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.amount_transit = Math.Round(countM.amount_transit ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.purchase_amount = Math.Round(countM.purchase_amount ?? 0, 2, MidpointRounding.AwayFromZero);

            var list = obj.Select(p => new {
                amount_onedaysale = p.amount_onedaysale??0,
                amount_stock = p.amount_stock??0,
                amount_transit = p.amount_transit??0,
                p.bailun_sku,
                p.category_name,
                fourteenday_total_sales = p.fourteenday_total_sales??0,
                noshippingcount = p.noshippingcount??0,
                nostockcount = p.nostockcount??0,
                oneday_total_sales = p.oneday_total_sales??0,
                purchase_amount = p.purchase_amount??0,
                quantity_purchase = p.quantity_purchase??0,
                quantity_transfer = p.quantity_transfer??0,
                sevenday_total_sales = p.sevenday_total_sales??0,
                p.sku_image,
                p.sku_title_cn,
                p.sku_title_en,
                thirtyday_total_sales = p.thirtyday_total_sales??0,
                usable_stock = p.usable_stock??0,
            });


            return JsonConvert.SerializeObject(new { total = total, rows = list, count_row=countM });
        }

    }
}