﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class OrdersController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }


        /// <summary>
        /// 亚马逊销售统计
        /// </summary>
        /// <returns></returns>
        public ActionResult AmazonSaleStatistics()
        {
            return View();
        }

        /// <summary>
        /// 亚马逊销售统计
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="sellaccount">销售帐号</param>
        /// <param name="website">站点</param>
        /// <param name="start">付款开始时间</param>
        /// <param name="end">付款结束时间</param>
        /// <returns></returns>
        public string ListAmazonSaleStatisticsJson(BtTableParameter parameter, string sellaccount, string website, DateTime start, DateTime end)
        {
            var total = 0;
            var service = new Services.OrdersServices();

            var objwithdraw = new Services.PlatformSiteServices().GetPlatformLossWithdraw().Where(a => a.english_name == "Amazon").FirstOrDefault();
            

            var list = service.ListAmazonStatistics(parameter, sellaccount, website, start, end, ref total);

            var countM = service.ListAmazonStatisticsCount(sellaccount, website, start, end);
            countM.website = "总计：";
            countM.amount_product = Math.Round(countM.amount_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_count = Math.Round(countM.cost_count, 2, MidpointRounding.AwayFromZero);
            countM.cost_product = Math.Round(countM.cost_product, 2, MidpointRounding.AwayFromZero);
            countM.fba_fee = Math.Round(countM.fba_fee, 2, MidpointRounding.AwayFromZero);
            countM.fba_profit = Math.Round(countM.fba_profit, 2, MidpointRounding.AwayFromZero);
            countM.forecast_profit_count = Math.Round(countM.forecast_profit_count, 2, MidpointRounding.AwayFromZero);
            countM.head_fee = Math.Round(countM.head_fee, 2, MidpointRounding.AwayFromZero);
            //countM.nofba_forecast_logisticsfee = Math.Round(countM.nofba_forecast_logisticsfee, 2, MidpointRounding.AwayFromZero);
            //countM.nofba_forecast_profit = Math.Round(countM.nofba_forecast_profit, 2, MidpointRounding.AwayFromZero);
            countM.nofba_logisticsfee = Math.Round(countM.nofba_logisticsfee, 2, MidpointRounding.AwayFromZero);
            countM.nofba_profit = Math.Round(countM.nofba_profit, 2, MidpointRounding.AwayFromZero);
            countM.platform_fee = Math.Round(countM.platform_fee, 2, MidpointRounding.AwayFromZero);

            countM.profit_count = Math.Round(countM.profit_count, 2, MidpointRounding.AwayFromZero);
            countM.amount_prepaid = Math.Round(countM.amount_prepaid, 2, MidpointRounding.AwayFromZero);
            countM.amount_refund = Math.Round(countM.amount_refund, 2, MidpointRounding.AwayFromZero);
            countM.loss_withdrawal = countM.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0);
            countM.profit_rate = Math.Round((countM.profit_count / countM.amount_product), 2, MidpointRounding.AwayFromZero);


            var obj = list.Select(p => new
            {
                p.platform_type,
                p.seller_account,
                p.website,
                amount_product = p.amount_product.ToString("###,###.##"),
                cost_product = p.cost_product.ToString("###,###.##"),
                platform_fee = p.platform_fee.ToString("###,###.##"),
                head_fee = p.head_fee>0?p.head_fee.ToString("###,###.##"):"0",
                p.order_count,
                loss_withdrawal = (p.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0))>0? (p.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0)).ToString("###,###.##"):"0",
                cost_count = p.cost_count.ToString("###,###.##"),
                forecast_profit_count = p.forecast_profit_count.ToString("###,###.##"),
                nofba_logisticsfee = p.nofba_logisticsfee>0?p.nofba_logisticsfee.ToString("###,###.##"):"0",
                nofba_forecast_logisticsfee = p.nofba_forecast_logisticsfee.ToString("###,###.##"),
                forecast_profit_rate = (100*p.forecast_profit_rate).ToString("###,###.##"),
                profit_count = p.profit_count.ToString("###,###.##"),
                profit_rate = (100*p.profit_rate).ToString("###,###.##"),
                p.currency,
                amount_prepaid = p.amount_prepaid.ToString("###,###.##"),
                amount_refund = p.amount_refund>0?p.amount_refund.ToString("###,###.##"):"0",
            });

            return JsonConvert.SerializeObject(new { total = total, rows = obj,count_row=new {
                countM.website,
                amount_product = countM.amount_product.ToString("###,###.##"),
                cost_product = countM.cost_product.ToString("###,###.##"),
                platform_fee = countM.platform_fee.ToString("###,###.##"),
                head_fee = countM.head_fee.ToString("###,###.##"),
                countM.order_count,
                loss_withdrawal = countM.loss_withdrawal>0? countM.loss_withdrawal.ToString("###,###.##"):"0",
                cost_count = countM.cost_count.ToString("###,###.##"),
                forecast_profit_count = countM.forecast_profit_count.ToString("###,###.##"),
                nofba_logisticsfee = countM.nofba_logisticsfee.ToString("###,###.##"),
                nofba_forecast_logisticsfee = countM.nofba_forecast_logisticsfee.ToString("###,###.##"),
                forecast_profit_rate = (100 * countM.forecast_profit_rate).ToString("###,###.##"),
                profit_count = countM.profit_count.ToString("###,###.##"),
                profit_rate = (100 * countM.profit_rate).ToString("###,###.##"),
                countM.currency,
                amount_prepaid = countM.amount_prepaid.ToString("###,###.##"),
                amount_refund = countM.amount_refund > 0 ? countM.amount_refund.ToString("###,###.##") : "0",
            }
            });
        }

        /// <summary>
        /// FBA销售统计
        /// </summary>
        /// <returns></returns>
        public ActionResult FBASaleStatistics()
        {
            return View();
        }

        /// <summary>
        /// FBA销售统计数据
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="sellaccount">销售帐号</param>
        /// <param name="website">站点</param>
        /// <param name="start">开始时间</param>
        /// <param name="end">结束时间</param>
        /// <returns></returns>
        public string ListFBASaleStatisticsJson(BtTableParameter parameter, string sellaccount, string website, DateTime start, DateTime end)
        {
            var total = 0;
            var service = new Services.OrdersServices();

            var objwithdraw = new Services.PlatformSiteServices().GetPlatformLossWithdraw().Where(a => a.english_name == "Amazon").FirstOrDefault();
            var list = service.ListFBAStatistics(parameter, sellaccount, website, start, end, ref total);

            var countM = service.ListFBAStatisticsCount(sellaccount, website, start, end);
            countM.website = "总计：";
            countM.amount_product = Math.Round(countM.amount_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_count = Math.Round(countM.cost_count, 2, MidpointRounding.AwayFromZero);
            countM.cost_product = Math.Round(countM.cost_product, 2, MidpointRounding.AwayFromZero);
            countM.fba_fee = Math.Round(countM.fba_fee, 2, MidpointRounding.AwayFromZero);
            countM.fba_profit = Math.Round(countM.fba_profit, 2, MidpointRounding.AwayFromZero);
            countM.forecast_profit_count = Math.Round(countM.forecast_profit_count, 2, MidpointRounding.AwayFromZero);
            countM.head_fee = Math.Round(countM.head_fee, 2, MidpointRounding.AwayFromZero);
            countM.nofba_forecast_logisticsfee = Math.Round(countM.nofba_forecast_logisticsfee, 2, MidpointRounding.AwayFromZero);
            countM.nofba_forecast_profit = Math.Round(countM.nofba_forecast_profit, 2, MidpointRounding.AwayFromZero);
            countM.nofba_logisticsfee = Math.Round(countM.nofba_logisticsfee, 2, MidpointRounding.AwayFromZero);
            countM.nofba_profit = Math.Round(countM.nofba_profit, 2, MidpointRounding.AwayFromZero);
            countM.platform_fee = Math.Round(countM.platform_fee, 2, MidpointRounding.AwayFromZero);

            countM.profit_count = Math.Round(countM.profit_count, 2, MidpointRounding.AwayFromZero);
            countM.amount_prepaid = Math.Round(countM.amount_prepaid, 2, MidpointRounding.AwayFromZero);
            countM.amount_refund = Math.Round(countM.amount_refund, 2, MidpointRounding.AwayFromZero);
            countM.loss_withdrawal = countM.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0);
            countM.cost_fba_fee = Math.Round(countM.cost_fba_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_paypal_fee = Math.Round(countM.cost_paypal_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_package = Math.Round(countM.cost_package, 2, MidpointRounding.AwayFromZero);
            countM.profit_rate = Math.Round((countM.profit_count / countM.amount_product), 2, MidpointRounding.AwayFromZero);


            var obj = list.Select(p => new
            {
                p.platform_type,
                p.seller_account,
                p.website,
                amount_product = p.amount_product.ToString("###,###.##"),
                cost_product = p.cost_product.ToString("###,###.##"),
                platform_fee = p.platform_fee.ToString("###,###.##"),
                head_fee = p.head_fee.ToString("###,###.##"),
                p.order_count,
                loss_withdrawal = (p.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0)) > 0 ? (p.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0)).ToString("###,###.##") : "0",
                cost_count = p.cost_count.ToString("###,###.##"),
                forecast_profit_count = p.forecast_profit_count.ToString("###,###.##"),
                nofba_logisticsfee = p.nofba_logisticsfee > 0 ? p.nofba_logisticsfee.ToString("###,###.##") : "0",
                nofba_forecast_logisticsfee = p.nofba_forecast_logisticsfee.ToString("###,###.##"),
                forecast_profit_rate = (100 * p.forecast_profit_rate).ToString("###,###.##"),
                profit_count = p.profit_count.ToString("###,###.##"),
                profit_rate = (100 * p.profit_rate).ToString("###,###.##"),
                amount_prepaid = p.amount_prepaid.ToString("###,###.##"),
                amount_refund = p.amount_refund > 0 ? p.amount_refund.ToString("###,###.##") : "0",
                cost_fba_fee = p.cost_fba_fee>0?p.cost_fba_fee.ToString("###,###.##"):"0",
                cost_paypal_fee = p.cost_paypal_fee>0?p.cost_paypal_fee.ToString("###,###.##"):"0",
                cost_package = p.cost_package>0?p.cost_package.ToString("###,###.##"):"0",
            });

            return JsonConvert.SerializeObject(new { total = total, rows = obj,
                count_row = new
                {
                    countM.website,
                    amount_product = countM.amount_product.ToString("###,###.##"),
                    cost_product = countM.cost_product.ToString("###,###.##"),
                    platform_fee = countM.platform_fee.ToString("###,###.##"),
                    head_fee = countM.head_fee.ToString("###,###.##"),
                    countM.order_count,
                    loss_withdrawal = countM.loss_withdrawal > 0 ? countM.loss_withdrawal.ToString("###,###.##") : "0",
                    cost_count = countM.cost_count.ToString("###,###.##"),
                    forecast_profit_count = countM.forecast_profit_count.ToString("###,###.##"),
                    nofba_logisticsfee = countM.nofba_logisticsfee.ToString("###,###.##"),
                    nofba_forecast_logisticsfee = countM.nofba_forecast_logisticsfee.ToString("###,###.##"),
                    forecast_profit_rate = (100 * countM.forecast_profit_rate).ToString("###,###.##"),
                    profit_count = countM.profit_count.ToString("###,###.##"),
                    profit_rate = (100 * countM.profit_rate).ToString("###,###.##"),
                    countM.currency,
                    amount_prepaid = countM.amount_prepaid.ToString("###,###.##"),
                    amount_refund = countM.amount_refund > 0 ? countM.amount_refund.ToString("###,###.##") : "0",
                    cost_fba_fee = countM.cost_fba_fee > 0 ? countM.cost_fba_fee.ToString("###,###.##") : "0",
                    cost_paypal_fee = countM.cost_paypal_fee > 0 ? countM.cost_paypal_fee.ToString("###,###.##") : "0",
                    cost_package = countM.cost_package > 0 ? countM.cost_package.ToString("###,###.##") : "0",
                }
            });
        }

        /// <summary>
        /// 订单流水
        /// </summary>
        /// <returns></returns>
        public ActionResult ListOrder(string platform)
        {

            ViewBag.platform = platform;
            return View();
        }

        /// <summary>
        /// 订单流水数据
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="platform">平台</param>
        /// <param name="account">帐号</param>
        /// <param name="website">站点</param>
        /// <param name="start">付款开始时间</param>
        /// <param name="end">付款结束时间</param>
        /// <param name="orderno">平台订单号</param>
        /// <param name="sku">sku编码</param>
        /// <returns></returns>
        public string ListOrderJson(BtTableParameter parameter, string platform, string account, string website, DateTime? start, DateTime? end,string orderno,string sku)
        {
            var total = 0;
            var service = new Services.OrdersServices();
            var obj = service.ListOrders(parameter, platform, website, account, start, end, orderno, sku, ref total);

            var countM = service.ListOrdersCount(platform, website, account, start, end, orderno, sku);
            countM.amount_adjustment = Math.Round(countM.amount_adjustment, 2, MidpointRounding.AwayFromZero);
            countM.amount_gift_wrap = Math.Round(countM.amount_gift_wrap, 2, MidpointRounding.AwayFromZero);
            countM.amount_product = Math.Round(countM.amount_product, 2, MidpointRounding.AwayFromZero);
            countM.amount_refund = Math.Round(countM.amount_refund, 2, MidpointRounding.AwayFromZero);
            countM.amount_shipping = Math.Round(countM.amount_shipping, 2, MidpointRounding.AwayFromZero);
            countM.amount_tax = Math.Round(countM.amount_tax, 2, MidpointRounding.AwayFromZero);
            countM.amount_total = Math.Round(countM.amount_total, 2, MidpointRounding.AwayFromZero);

            countM.cost_estimate_logistics = Math.Round(countM.cost_estimate_logistics, 2, MidpointRounding.AwayFromZero);
            countM.cost_fba_fee = Math.Round(countM.cost_fba_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_first = Math.Round(countM.cost_first, 2, MidpointRounding.AwayFromZero);
            countM.cost_package = Math.Round(countM.cost_package, 2, MidpointRounding.AwayFromZero);
            countM.cost_paypal_fee = Math.Round(countM.cost_paypal_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_platform_fee = Math.Round(countM.cost_platform_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_product = Math.Round(countM.cost_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_promotion = Math.Round(countM.cost_promotion, 2, MidpointRounding.AwayFromZero);
            countM.cost_refund_commisson = Math.Round(countM.cost_refund_commisson, 2, MidpointRounding.AwayFromZero);
            countM.cost_shipping = Math.Round(countM.cost_shipping, 2, MidpointRounding.AwayFromZero);
            countM.cost_total = Math.Round(countM.cost_total, 2, MidpointRounding.AwayFromZero);
            countM.profit_total = Math.Round(countM.profit_total, 2, MidpointRounding.AwayFromZero);
            countM.website = "总计：";
                

            var list = obj.Select(p => new {
                p.origin_order_id,
                p.platform_type,
                p.website,
                p.seller_account,
                p.platform_order_type,
                p.bailun_order_status,
                p.bailun_payment_status,
                p.bailun_shipping_status,
                p.order_currency,
                amount_total = p.amount_total>0? p.amount_total.ToString("###,###.##"):"0",
                amount_shipping = p.amount_shipping>0? p.amount_shipping.ToString("###,###.##"):"0",
                amount_product = p.amount_product>0? p.amount_product.ToString("###,###.##"):"0",
                amount_adjustment = p.amount_adjustment>0? p.amount_adjustment.ToString("###,###.##"):"0",
                cost_promotion = p.cost_promotion>0? p.cost_promotion.ToString("###,###.##"):"0",
                cost_platform_fee = p.cost_platform_fee>0? p.cost_platform_fee.ToString("###,###.##"):"0",
                cost_product = p.cost_product>0? p.cost_product.ToString("###,###.##"):"0",
                cost_first = p.cost_first>0? p.cost_first.ToString("###,###.##"):"0",
                cost_package = p.cost_package>0? p.cost_package.ToString("###,###.##"):"0",
                cost_fba_fee = p.cost_fba_fee>0? p.cost_fba_fee.ToString("###,###.##"):"0",
                cost_total = p.cost_total>0? p.cost_total.ToString("###,###.##"):"0",
                profit_total = p.profit_total>0? p.profit_total.ToString("###,###.##"):"0",
                create_time = p.create_time.ToString("yyyy-MM-dd HH:mm:ss"),
                order_update_time = p.order_update_time.ToString("yyyy-MM-dd HH:mm:ss"),
                p.salecount
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list,count_row = countM });
        }


        /// <summary>
        /// 财务费用
        /// </summary>
        /// <param name="platform"></param>
        /// <returns></returns>
        public ActionResult FinanceFee(string platform)
        {
            ViewBag.platform = platform;
            return View();
        }

        /// <summary>
        /// 财务费用
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="platform"></param>
        /// <param name="feetype"></param>
        /// <param name="feecharacter"></param>
        /// <param name="account"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="orderno"></param>
        /// <returns></returns>
        public string FinanceFeeJson(BtTableParameter parameter, string platform, int feetype, int feecharacter, string account, DateTime? start, DateTime? end, string orderno)
        {
            var total = 0;
            var service = new Services.OrdersServices();
            var obj = service.ListFinanceFee(parameter, platform, feetype, feecharacter, account, start, end, orderno, ref total);

            var countM = service.ListFinanceFeeCount(platform, feetype, feecharacter, account, start, end, orderno);
            countM.amount_adjustment = Math.Round(countM.amount_adjustment, 2, MidpointRounding.AwayFromZero);
            countM.amount_gift_wrap = Math.Round(countM.amount_gift_wrap, 2, MidpointRounding.AwayFromZero);
            countM.amount_product = Math.Round(countM.amount_product, 2, MidpointRounding.AwayFromZero);
            countM.amount_refund = Math.Round(countM.amount_refund, 2, MidpointRounding.AwayFromZero);
            countM.amount_shipping = Math.Round(countM.amount_shipping, 2, MidpointRounding.AwayFromZero);
            countM.amount_tax = Math.Round(countM.amount_tax, 2, MidpointRounding.AwayFromZero);
            countM.amount_total = Math.Round(countM.amount_total, 2, MidpointRounding.AwayFromZero);

            countM.cost_estimate_logistics = Math.Round(countM.cost_estimate_logistics, 2, MidpointRounding.AwayFromZero);
            countM.cost_fba_fee = Math.Round(countM.cost_fba_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_first = Math.Round(countM.cost_first, 2, MidpointRounding.AwayFromZero);
            countM.cost_package = Math.Round(countM.cost_package, 2, MidpointRounding.AwayFromZero);
            countM.cost_paypal_fee = Math.Round(countM.cost_paypal_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_platform_fee = Math.Round(countM.cost_platform_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_product = Math.Round(countM.cost_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_promotion = Math.Round(countM.cost_promotion, 2, MidpointRounding.AwayFromZero);
            countM.cost_refund_commisson = Math.Round(countM.cost_refund_commisson, 2, MidpointRounding.AwayFromZero);
            countM.cost_shipping = Math.Round(countM.cost_shipping, 2, MidpointRounding.AwayFromZero);
            countM.cost_total = Math.Round(countM.cost_total, 2, MidpointRounding.AwayFromZero);
            countM.profit_total = Math.Round(countM.profit_total, 2, MidpointRounding.AwayFromZero);
            countM.website = "总计：";

            var list = obj.Select(p => new {
                p.origin_order_id,
                p.platform_type,
                p.website,
                p.seller_account,
                p.platform_order_type,
                p.bailun_sku,
                amount_product = p.amount_product>0? (p.amount_product*p.seller_order_exchange_rate).ToString("###,###.##"):"0",
                cost_first = p.cost_first>0? p.cost_first.ToString("###,###.##"):"0",
                amount_shipping = p.amount_shipping>0? (p.amount_shipping * p.seller_order_exchange_rate).ToString("###,###.##"):"0",
                cost_promotion= p.cost_promotion>0? (p.cost_promotion * p.seller_order_exchange_rate).ToString("###,###.##"):"0",
                cost_shipping = p.cost_shipping>0? p.cost_shipping.ToString("###,###.##"):"0",
                cost_fba_fee = p.cost_fba_fee>0? (p.cost_fba_fee * p.seller_order_exchange_rate).ToString("###,###.##"):"0",
                cost_platform_fee = p.cost_platform_fee>0? (p.cost_platform_fee * p.seller_order_exchange_rate).ToString("###,###.##"):"0",
                platform_fee_rate = (p.cost_platform_fee/ p.amount_product *100).ToString("###,###.##"),
                cost_package = p.cost_package>0? p.cost_package.ToString("###,###.##"):"0",
                losswithdrawal = p.losswithdrawal>0? p.losswithdrawal.ToString("###,###.##"):"0",
                amount_total = p.amount_total>0? p.amount_total.ToString("###,###.##"):"0",
                cost_total = p.cost_total>0? p.cost_total.ToString("###,###.##"):"0",
                paid_time = p.paid_time.ToString("yyyy-MM-dd HH:mm:ss")
            });


            return JsonConvert.SerializeObject(new { total = total, rows = list,count_row=countM });
        }

        /// <summary>
        /// FBA费用异常订单
        /// </summary>
        /// <returns></returns>
        public ActionResult FBAAbnormalOrder()
        {
            return View();
        }


        /// <summary>
        /// FBA费用异常订单
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="account">销售帐号</param>
        /// <param name="website">站点</param>
        /// <param name="orderno">订单号</param>
        /// <param name="start">付款开始时间</param>
        /// <param name="end">付款结束时间</param>
        /// <returns></returns>
        public string FBAabnormalOrderJson(BtTableParameter parameter, string account, string website, string orderno, DateTime? start, DateTime? end)
        {
            var total = 0;
            var obj = new Services.OrdersServices().ListFbaAbnormalOrder(parameter, account, website, start, end, orderno, ref total);

            var list = obj.Select(p => new {
                average_fba_fee = p.average_fba_fee>0?p.average_fba_fee.ToString("###,###.##"):"0",
                p.bailun_sku,
                cost_fba_fee = p.cost_fba_fee>0? p.cost_fba_fee.ToString("###,###.##"):"0",
                create_time = p.create_time.ToString("yyyy-MM-dd HH:mm:ss"),
                fba_fee_rmb = p.fba_fee_rmb>0? p.fba_fee_rmb.ToString("###,###.##"):"0",
                max_fba_fee = p.max_fba_fee>0? p.max_fba_fee.ToString("###,###.##"):"0",
                min_fba_fee = p.min_fba_fee>0? p.min_fba_fee.ToString("###,###.##"):"0",
                p.order_currency,
                p.origin_order_id,
                p.platform_type,
                p.product_code,
                p.seller_account,
                seller_order_exchange_rate = p.seller_order_exchange_rate>0?p.seller_order_exchange_rate.ToString("###,###.##"):"0",
                p.website,
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });
        }


        /// <summary>
        /// 平台费异常订单
        /// </summary>
        /// <returns></returns>
        public ActionResult PlatformFeeAbnormal(string platform)
        {
            ViewBag.platform = platform;
            return View();
        }

        /// <summary>
        /// 平台费异常订单
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="account"></param>
        /// <param name="website"></param>
        /// <param name="orderno"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public string PlatformFeeAbnormalJson(BtTableParameter parameter,string platform,string account,string website,string orderno,DateTime? start,DateTime? end)
        {
            var total = 0;
            var service = new Services.OrdersServices();
            var obj = service.ListPlatformFeeAbnormal(parameter, platform, account, website, orderno, start, end, ref total);

            var countM = service.ListPlatformFeeAbnormalCount(platform, account, website, orderno, start, end);
            countM.amount_product = Math.Round(countM.amount_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_platform_fee = Math.Round(countM.cost_platform_fee, 2, MidpointRounding.AwayFromZero);
            countM.seller_account = "总计：";

            var list = obj.Select(p => new {
                p.origin_order_id,
                p.bailun_order_id,
                p.seller_account,
                amount_product = p.amount_product>0? p.amount_product.ToString("###,###.##"):"0",
                cost_platform_fee = p.cost_platform_fee>0? p.cost_platform_fee.ToString("###,###.##"):"0",
                platform_fee_rate = p.platform_fee_rate>0? (p.platform_fee_rate*100).ToString("###,###.##"):"0",
                p.platform_type,
                p.website,
                create_time = p.create_time.ToString("yyyy-MM-dd HH:mm:ss")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list,count_row = countM });
        }


        /// <summary>
        /// 平台利润统计
        /// </summary>
        /// <returns></returns>
        public ActionResult PlatformProfitCount()
        {
            return View();
        }

        /// <summary>
        /// 平台利润统计数据
        /// </summary>
        /// <param name="platform">平台类型</param>
        /// <param name="start">付款开始时间</param>
        /// <param name="end">付款结束时间</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult PlatformProfitCountJson(string platform,DateTime? start,DateTime? end)
        {
            var result = new Services.OrdersServices().ListPlatformProfit(platform, start, end);

            if (result.Count > 0)
            {
                var m = new Models.Orders.mPlatformProfit
                {
                    platform = "总计",
                    ordercount = result.Sum(a => a.ordercount),
                    saleamount = result.Sum(a => a.saleamount),
                    customerprice = result.Sum(a => a.customerprice) / result.Count,
                    platformfee = result.Sum(a => a.platformfee),
                    profit = result.Sum(a => a.profit),
                    profitrate = result.Sum(a => a.profit) / result.Sum(a => a.saleamount),
                    returnamount = result.Sum(a => a.returnamount),
                    returnamountrate = result.Sum(a => a.returnamount)/ result.Sum(a => a.saleamount),
                    cost_first = result.Sum(a => a.cost_first),
                    cost_handle_bailun = result.Sum(a => a.cost_handle_bailun),
                    cost_handle_platform = result.Sum(a => a.cost_handle_platform),
                    cost_tail = result.Sum(a => a.cost_tail),
                    amount_prepaid = result.Sum(a=>a.amount_prepaid),
                    
                };

                result.Add(m);
            }


            var list = result.Select(p => new {
                p.platform,
                customerprice = p.customerprice > 0 ? p.customerprice.ToString("###,###.##") : "0",
                p.ordercount,
                platformfee = p.platformfee > 0 ? p.platformfee.ToString("###,###.##") : "0",
                profit = p.profit > 0 ? p.profit.ToString("###,###.##") : "0",
                profitrate = p.profitrate > 0 ? (p.profitrate * 100).ToString("###,###.##") : "0",
                returnamount = p.returnamount > 0 ? p.returnamount.ToString("###,###.##") : "0",
                returnamountrate = p.returnamountrate.ToString("N4"), 
                saleamount = p.saleamount > 0 ? p.saleamount.ToString("###,###.##") : "0",

                cost_first = p.cost_first > 0 ? p.cost_first.ToString("###,###.##") : "0",
                cost_handle_bailun = p.cost_handle_bailun > 0 ? p.cost_handle_bailun.ToString("###,###.##") : "0",
                cost_handle_platform = p.cost_handle_platform > 0 ? p.cost_handle_platform.ToString("###,###.##") : "0",
                cost_tail = p.cost_tail > 0 ? p.cost_tail.ToString("###,###.##") : "0",
                amount_prepaid = p.amount_prepaid.ToString("N2"), 
            });
            
            return Json(list);
        }

        /// <summary>
        /// 平台利润，按站点
        /// </summary>
        /// <param name="platform">平台编码</param>
        /// <param name="start">开始时间</param>
        /// <param name="end">结束时间</param>
        /// <returns></returns>
        public ActionResult PlatformProfitCountByWebSite(string platform,DateTime? start,DateTime? end)
        {
            ViewBag.platform = platform;
            ViewBag.start = start.HasValue?start.Value.ToString("yyyy-MM-dd"):"";
            ViewBag.end = end.HasValue?end.Value.ToString("yyyy-MM-dd"):"";

            return View();
        }

        /// <summary>
        /// 平台利润，按站点
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="parameter"></param>
        /// <returns></returns>
        public string PlatformProfitCountByWebSiteJson(string platform, DateTime? start, DateTime? end,BtTableParameter parameter)
        {
            var total = 0;
            var service = new Services.OrdersServices();
            var result = service.ListPlatformProfitByWebSite(platform, start, end,parameter,ref total);
            
            var countM = service.ListPlatformProfitByWebSiteCount(platform, start, end, parameter, ref total);
            countM.website = "合计：";
            countM.cost_first = Math.Round(countM.cost_first, 2, MidpointRounding.AwayFromZero);
            countM.cost_handle_bailun = Math.Round(countM.cost_handle_bailun, 2, MidpointRounding.AwayFromZero);
            countM.cost_handle_platform = Math.Round(countM.cost_handle_platform, 2, MidpointRounding.AwayFromZero);
            countM.cost_tail = Math.Round(countM.cost_tail, 2, MidpointRounding.AwayFromZero);
            countM.customerprice = Math.Round(countM.customerprice, 2, MidpointRounding.AwayFromZero);
            countM.platformfee = Math.Round(countM.platformfee, 2, MidpointRounding.AwayFromZero);
            countM.profit = Math.Round(countM.profit, 2, MidpointRounding.AwayFromZero);
            countM.returnamount = Math.Round(countM.returnamount, 2, MidpointRounding.AwayFromZero);
            countM.saleamount = Math.Round(countM.saleamount, 2, MidpointRounding.AwayFromZero);
            countM.amount_prepaid = Math.Round(countM.amount_prepaid, 2, MidpointRounding.AwayFromZero);

            var list = result.Select(p => new {
                p.platform,
                customerprice = p.customerprice > 0 ? p.customerprice.ToString("###,###.##") : "0",
                p.ordercount,
                platformfee = p.platformfee > 0 ? p.platformfee.ToString("###,###.##") : "0",
                profit = p.profit > 0 ? p.profit.ToString("###,###.##") : "0",
                profitrate = p.profitrate > 0 ? (p.profitrate * 100).ToString("###,###.##") : "0",
                returnamount = p.returnamount > 0 ? p.returnamount.ToString("###,###.##") : "0",
                returnamountrate = p.returnamountrate > 0 ? (p.returnamountrate * 100).ToString("###,###.##") : "0",
                saleamount = p.saleamount > 0 ? p.saleamount.ToString("###,###.##") : "0",

                cost_first = p.cost_first > 0 ? p.cost_first.ToString("###,###.##") : "0",
                cost_handle_bailun = p.cost_handle_bailun > 0 ? p.cost_handle_bailun.ToString("###,###.##") : "0",
                cost_handle_platform = p.cost_handle_platform > 0 ? p.cost_handle_platform.ToString("###,###.##") : "0",
                cost_tail = p.cost_tail > 0 ? p.cost_tail.ToString("###,###.##") : "0",
                p.website,
                amount_prepaid = p.amount_prepaid>0?p.amount_prepaid.ToString("###,###.##"):"0",
            });

            return JsonConvert.SerializeObject(new { total=total,rows = list,count_row=countM});
        }


        /// <summary>
        /// 订单明细列表
        /// </summary>
        /// <returns></returns>
        public ActionResult ListOrderDetail(string platform, string website,string account, DateTime? start, DateTime? end, string orderno,int? showsingle,string col,string coltitle)
        {

            ViewBag.platform = platform;
            ViewBag.website = website;
            ViewBag.start = start.HasValue ? start.Value.ToString("yyyy-MM-dd") : "";
            ViewBag.end = end.HasValue ? end.Value.ToString("yyyy-MM-dd") : "";
            ViewBag.orderno = orderno;
            ViewBag.account = account;
            ViewBag.showsingle = (showsingle ?? 0);
            ViewBag.col = col;
            ViewBag.coltitle = coltitle;

            return View();
        }

        /// <summary>
        /// 订单明细列表 数据
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <param name="start">付款开始时间</param>
        /// <param name="end">付款结束时间</param>
        /// <param name="orderno">百伦订单号</param>
        /// <returns></returns>
        public string ListOrderDetailJson(BtTableParameter parameter,string platform,string website,string account,DateTime? start,DateTime? end,string orderno)
        {
            var total = 0;
            var service = new Services.OrdersServices();
            var obj = service.ListPlatformProfitOrders(parameter, platform, website, account, start, end, orderno, ref total);

            var countM = service.ListPlatformProfitOrdersCount(platform, website, account, start, end, orderno);

            countM.bailun_order_id = "总计";
            countM.amount_total = Math.Round((countM.amount_total), 2, MidpointRounding.AwayFromZero);
            countM.amount_product = Math.Round((countM.amount_product), 2, MidpointRounding.AwayFromZero);
            countM.amount_shipping = Math.Round((countM.amount_shipping), 2, MidpointRounding.AwayFromZero);
            countM.amount_tax = Math.Round((countM.amount_tax), 2, MidpointRounding.AwayFromZero);
            countM.amount_adjustment = Math.Round((countM.amount_adjustment), 2, MidpointRounding.AwayFromZero);
            countM.amount_gift_wrap = Math.Round((countM.amount_gift_wrap), 2, MidpointRounding.AwayFromZero);
            countM.amount_refund = Math.Round((countM.amount_refund), 2, MidpointRounding.AwayFromZero);

            countM.cost_total = Math.Round(countM.cost_total, 2, MidpointRounding.AwayFromZero);
            countM.cost_promotion = Math.Round(countM.cost_promotion, 2, MidpointRounding.AwayFromZero);
            countM.cost_platform_fee = Math.Round(countM.cost_platform_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_product = Math.Round(countM.cost_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_shipping = Math.Round(countM.cost_shipping, 2, MidpointRounding.AwayFromZero);
            countM.cost_package = Math.Round(countM.cost_package, 2, MidpointRounding.AwayFromZero);
            countM.cost_fba_fee = Math.Round(countM.cost_fba_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_paypal_fee = Math.Round(countM.cost_paypal_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_refund_commisson = Math.Round(countM.cost_refund_commisson, 2, MidpointRounding.AwayFromZero);
            countM.cost_handle_bailun = Math.Round(countM.cost_handle_bailun, 2, MidpointRounding.AwayFromZero);
            countM.cost_handle_platform = Math.Round(countM.cost_handle_platform, 2, MidpointRounding.AwayFromZero);
            countM.cost_first = Math.Round(countM.cost_first, 2, MidpointRounding.AwayFromZero);
            countM.cost_tail = Math.Round(countM.cost_tail, 2, MidpointRounding.AwayFromZero);
            countM.profit_total = Math.Round(countM.profit_total, 2, MidpointRounding.AwayFromZero);
            countM.amount_prepaid = Math.Round(countM.amount_prepaid, 2, MidpointRounding.AwayFromZero);

            var list = obj.Select(p => new
            {
                p.origin_order_id,
                p.bailun_order_id,
                p.platform_type,
                p.website,
                p.seller_account,
                p.order_currency,

                amount_total = Math.Round((p.amount_total * p.seller_order_exchange_rate),2,MidpointRounding.AwayFromZero),
                amount_product = Math.Round((p.amount_product * p.seller_order_exchange_rate),2,MidpointRounding.AwayFromZero),
                amount_shipping = Math.Round((p.amount_shipping * p.seller_order_exchange_rate),2,MidpointRounding.AwayFromZero),
                amount_tax = Math.Round((p.amount_tax * p.seller_order_exchange_rate),2,MidpointRounding.AwayFromZero),
                amount_adjustment = Math.Round((p.amount_adjustment * p.seller_order_exchange_rate),2,MidpointRounding.AwayFromZero),
                amount_gift_wrap = Math.Round((p.amount_gift_wrap * p.seller_order_exchange_rate),2,MidpointRounding.AwayFromZero),
                amount_refund = Math.Round((p.amount_refund * p.seller_order_exchange_rate),2,MidpointRounding.AwayFromZero),

                cost_total = Math.Round(p.cost_total,2,MidpointRounding.AwayFromZero),
                cost_promotion = Math.Round(p.cost_promotion * p.seller_order_exchange_rate,2,MidpointRounding.AwayFromZero),
                cost_platform_fee = Math.Round(p.cost_platform_fee * p.seller_order_exchange_rate,2,MidpointRounding.AwayFromZero),
                cost_product = Math.Round(p.cost_product,2,MidpointRounding.AwayFromZero),
                cost_shipping = Math.Round(p.cost_shipping,2,MidpointRounding.AwayFromZero),
                cost_package = Math.Round(p.cost_package,2,MidpointRounding.AwayFromZero),
                cost_fba_fee = Math.Round(p.cost_fba_fee * p.seller_order_exchange_rate,2,MidpointRounding.AwayFromZero),
                cost_paypal_fee = Math.Round(p.cost_paypal_fee*p.seller_order_exchange_rate,2,MidpointRounding.AwayFromZero),
                cost_refund_commisson = Math.Round(p.cost_refund_commisson*p.seller_order_exchange_rate,2,MidpointRounding.AwayFromZero),
                cost_handle_bailun = Math.Round(p.cost_handle_bailun,2,MidpointRounding.AwayFromZero),
                cost_handle_platform = Math.Round(p.cost_handle_platform,2,MidpointRounding.AwayFromZero),
                cost_first = Math.Round(p.cost_first,2,MidpointRounding.AwayFromZero),
                cost_tail = Math.Round(p.cost_tail,2,MidpointRounding.AwayFromZero),
                profit_total = Math.Round(p.profit_total,2,MidpointRounding.AwayFromZero),
                profit_rate = Math.Round(p.profit_rate*100,2,MidpointRounding.AwayFromZero),
                amount_prepaid = Math.Round(p.amount_prepaid,2,MidpointRounding.AwayFromZero), 

                create_time = p.create_time.ToString("yyyy-MM-dd HH:mm:ss"),
                paid_time = p.paid_time.ToString("yyyy-MM-dd HH:mm:ss"),
                
            });

            return JsonConvert.SerializeObject(new { total=total,rows = list,count_row = countM});

        }

        /// <summary>
        /// 非FBA销售订单
        /// </summary>
        /// <param name="fba">是否fba订单，1：是，0：否</param>
        /// <returns></returns>
        public ActionResult SkuOrderList(int fba)
        {
            ViewBag.isfba = fba;
            return View();
        }

        /// <summary>
        /// FBA销售订单
        /// </summary>
        /// <returns></returns>
        public ActionResult FBASkuOrderList()
        {
            return View();
        }

        /// <summary>
        /// 销售订单 sku维度
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="warehousetype">仓库类型</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="orderstatus">订单状态</param>
        /// <param name="shippingstatus">发货状态</param>
        /// <param name="orderno">订单号</param>
        /// <param name="sku">sku编码</param>
        /// <returns></returns>
        public string SkuOrderListJson(BtTableParameter parameter, string warehousetype, string warehousecode,string seller,DateTime? start,DateTime? end, string orderstatus, string shippingstatus, string orderno, string sku,int isfba)
        {
            var total = 0;
            var service = new Services.OrdersServices();
            var obj = service.ListSkuOrder(parameter, warehousetype, warehousecode, seller, start, end, orderno, sku, orderstatus, shippingstatus, ref total, isfba);
            var countM = service.ListSkuOrderCount(warehousetype, warehousecode, seller, start, end, orderno, sku, orderstatus, shippingstatus, isfba);

            countM.sku_image = "总计：";

            return JsonConvert.SerializeObject(new { total = total, rows = obj,count_row = countM });
        }

        /// <summary>
        /// 订单汇总
        /// </summary>
        /// <returns></returns>
        public ActionResult OrderSaleCount()
        {
            return View();
        }

        /// <summary>
        /// 订单汇总数据
        /// </summary>
        /// <returns></returns>
        public string OrderSaleCountJson(BtTableParameter parameter,string platform,string account,string website,string warehousecode, DateTime? start,DateTime? end,string sku)
        {
            var total = 0;
            var service = new Services.OrdersServices();

            var obj = service.ListSkuSaleCount(parameter, platform, account, website, warehousecode, start, end, sku, ref total);
            var countM = service.ListSkuSaleCounts(platform, account, website, warehousecode, start, end, sku);
            countM.warehouse_name = "总计：";

            return JsonConvert.SerializeObject(new { total = total, rows = obj,count_row = countM });
        }

        #region Ebay

        /// <summary>
        /// Ebay销售统计
        /// </summary>
        /// <returns></returns>
        public ActionResult EbaySaleStatistics()
        {
            return View();
        }

        /// <summary>
        /// Ebay销售统计 Json
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="selleraccount"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="warehousetype"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public string EbaySaleStatisticsJson(BtTableParameter parameter, string selleraccount, string website, DateTime start, DateTime end, string warehousetype, string warehousecode)
        {
            var total = 0;
            var services = new Services.OrdersServices();
            var objwithdraw = new Services.PlatformSiteServices().GetPlatformLossWithdraw().Where(a => a.english_name == "Ebay").FirstOrDefault();

            var list = services.ListEbayStatistics(parameter, website, selleraccount, start, end, warehousetype, warehousecode, ref total);

            var countM = services.ListEbayStatisticsCount(website, selleraccount, start, end, warehousetype, warehousecode);
            
            countM.website = "总计：";
            countM.amount_product = Math.Round(countM.amount_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_product = Math.Round(countM.cost_product, 2, MidpointRounding.AwayFromZero);
            countM.cost_platform_fee = Math.Round(countM.cost_platform_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_package = Math.Round(countM.cost_package, 2, MidpointRounding.AwayFromZero);
            countM.cost_paypal_fee = Math.Round(countM.cost_paypal_fee, 2, MidpointRounding.AwayFromZero);
            countM.cost_first = Math.Round(countM.cost_first, 2, MidpointRounding.AwayFromZero);
            countM.loss_withdrawal = countM.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0);
            countM.cost_total = Math.Round(countM.cost_total, 2, MidpointRounding.AwayFromZero);
            countM.cost_shipping = Math.Round(countM.cost_shipping, 2, MidpointRounding.AwayFromZero);
            countM.amount_refund = Math.Round(countM.amount_refund, 2, MidpointRounding.AwayFromZero);
            countM.amount_prepaid = Math.Round(countM.amount_prepaid, 2, MidpointRounding.AwayFromZero);
            countM.profit_total = Math.Round(countM.profit_total, 2, MidpointRounding.AwayFromZero);
            countM.profit_rate = Math.Round((countM.profit_total / countM.amount_product), 2, MidpointRounding.AwayFromZero);
            

            var obj = list.Select(p => new
            {
                p.platform_type,
                p.seller_account,
                p.website,
                amount_product = p.amount_product.ToString("N2"),
                cost_product = p.cost_product.ToString("N2"),
                cost_platform_fee = p.cost_platform_fee.ToString("N2"),
                cost_package = p.cost_package.ToString("N2"),
                cost_paypal_fee = p.cost_paypal_fee.ToString("N2"),
                cost_first = p.cost_first.ToString("N2"),
                p.order_count,
                loss_withdrawal = (p.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0)) > 0 ? (p.amount_product * (objwithdraw == null ? 0 : objwithdraw.Loss_withdrawal_percent ?? 0)).ToString("###,###.##") : "0",

                cost_total = p.cost_total.ToString("N2"),
                cost_shipping = p.cost_shipping.ToString("N2"),
                amount_refund = p.amount_refund.ToString("N2"),
                amount_prepaid = p.amount_prepaid.ToString("N2"),
                profit_total = p.profit_total.ToString("N2"),
                profit_rate = (100 * p.profit_rate).ToString("N2"),
            });

            return JsonConvert.SerializeObject(new
            {
                total = total,
                rows = obj,
                count_row = new
                {
                    countM.website,
                    amount_product = countM.amount_product.ToString("N2"),
                    cost_product = countM.cost_product.ToString("N2"),
                    cost_platform_fee = countM.cost_platform_fee.ToString("N2"),
                    cost_package = countM.cost_package.ToString("N2"),
                    cost_paypal_fee = countM.cost_paypal_fee.ToString("N2"),
                    cost_first = countM.cost_first.ToString("N2"),
                    countM.order_count,
                    loss_withdrawal = countM.loss_withdrawal.ToString("N2"),
                    cost_total = countM.cost_total.ToString("N2"),
                    cost_shipping = countM.cost_shipping.ToString("N2"),
                    amount_refund = countM.amount_refund.ToString("N2"),
                    amount_prepaid = countM.amount_prepaid.ToString("N2"),
                    profit_total = countM.profit_total.ToString("N2"),
                    profit_rate = (100 * countM.profit_rate).ToString("N2"),
                }
            });
        }


        #endregion

        #region Common

        /// <summary>
        /// 获取平台列表
        /// </summary>
        /// <returns></returns>
        public JsonResult ListPlatform()
        {
            var result = Services.CommonServices.ListPlatForm();
            return Json(result);
        }

        /// <summary>
        /// 获取帐号列表
        /// </summary>
        /// <param name="platform">平台编码</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListAccount(string platform)
        {
            var result = Services.CommonServices.ListAccount(platform);
            return Json(result);
        }

        /// <summary>
        /// 获取站点列表
        /// </summary>
        /// <param name="platform">平台编码</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListWebSite(string platform)
        {
            var result = Services.CommonServices.ListWebSite(platform);
            return Json(result);
        }

        /// <summary>
        /// 销售员列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListSeller()
        {
            var result = Services.CommonServices.ListSeller();
            return Json(result);
        }

        /// <summary>
        /// 获取百伦Sku分类
        /// </summary>
        /// <param name="level"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListSkuCategory(int level=1)
        {
            var obj = Services.CommonServices.GetCategoryList(level);

            return Json(obj);
        }

        /// <summary>
        /// 获取百伦sku的所有分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListSkuCategoryAll()
        {
            var obj = Services.CommonServices.GetCategoryListAll(null, 0);

            return Json(obj);
        }

        #endregion
    }
}