﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class InventoryController : Controller
    {
        /// <summary>
        /// 数据仓页面
        /// </summary>
        /// <returns></returns>
        public IActionResult DataWareHouse()
        {
            return View();
        }

        /// <summary>
        /// 数据仓数据
        /// </summary>
        /// <param name="request"></param>
        /// <param name="warehousetype"></param>
        /// <param name="warehousecode"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="monitorstatus"></param>
        /// <param name="cleanstatus"></param>
        /// <param name="infringestatus"></param>
        /// <param name="skutip"></param>
        /// <param name="storestart"></param>
        /// <param name="storeend"></param>
        /// <param name="skucategory"></param>
        /// <param name="searchkey"></param>
        /// <returns></returns>
        public string DataWareHouseJson(Models.BtTableParameter request, string warehousetype, string warehousecode, DateTime? start, DateTime? end, int? monitorstatus, int? cleanstatus, int? infringestatus, string skutip, int? storestart, int? storeend, int? skucategory, string searchkey)
        {
            var service = new Services.SkuMonitorServices();

            var total = 0;
            var obj = service.List(request.pageIndex, request.limit, warehousetype, warehousecode, start, end, monitorstatus, cleanstatus, infringestatus, skutip, storestart, storeend, skucategory, searchkey, ref total);

            var countM = service.ListCount(warehousetype, warehousecode, start, end, monitorstatus, cleanstatus, infringestatus, skutip, storestart, storeend, skucategory, searchkey);

            countM.skuname = "总计：";
            countM.inventoryamount = Math.Round(countM.inventoryamount, 2, MidpointRounding.AwayFromZero);
            countM.purchaseonwayamount = Math.Round(countM.purchaseonwayamount, 2, MidpointRounding.AwayFromZero);
            countM.sevendaysales_amount = Math.Round(countM.sevendaysales_amount, 2, MidpointRounding.AwayFromZero);
            countM.allotamount = Math.Round(countM.allotamount, 2, MidpointRounding.AwayFromZero);

            var list = obj.Select(p => new {
                p.id,
                allotamount = p.buyprice*p.allotcount,
                p.allotcount,
                p.avg_fourteensales,
                p.avg_sevendaysales,
                p.avg_thirtysales,
                p.avg_yesterdaysales,
                p.buyprice,
                p.categoryname,
                clearancestatus = p.clearancestatus==1?"正在清货":"否",
                inventoryamount = p.inventoryamount.ToString("###,###.##"),
                p.inventorycount,
                monitorstatus = p.monitorstatus==1?"正在监控":"停止监控",
                p.nosendcount,
                p.nostockcount,
                purchaseonwayamount = (p.purchaseonwaycount*p.buyprice).ToString("###,###.##"),
                p.purchaseonwaycount,
                sevendaysales_amount = p.sevendaysales_amount.ToString("###,###.##"),
                p.sku,
                p.skuname,
                p.stockcount,
                p.str_skutag,
                tortstatus = p.tortstatus==1?"已侵权":"否",
                p.warehousecode,
                p.warehousename,
                p.warehousetype,
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list,count_row = countM });
        }

        /// <summary>
        /// Sku库存分析报表（财务）
        /// </summary>
        /// <returns></returns>
        public ActionResult SkuInventory()
        {
            return View();
        }

        /// <summary>
        /// Sku库存分析报表数据
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehouse">仓库编码</param>
        /// <param name="date">月份</param>
        /// <returns></returns>
        public string ListSkuInventoryJson(Models.BtTableParameter parameter,string sku,string warehouse,DateTime? date)
        {
            var total = 1;

            var service = new Services.InventoryServices();
            var obj = service.ListSkuStockAnalyze(parameter, sku, warehouse, date, ref total);

            var countM = service.ListSkuStockAnalyzeCount(sku, warehouse, date);
            countM.bailun_sku = "总计：";
            countM.exportamount = Math.Round(countM.exportamount ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.inboundamount = Math.Round(countM.inboundamount ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.instant_inventory_amount = Math.Round(countM.instant_inventory_amount ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.purchase_inbound_amount = Math.Round(countM.purchase_inbound_amount ?? 0, 2, MidpointRounding.AwayFromZero);
            countM.transfer_inbound_amount = Math.Round(countM.transfer_inbound_amount ?? 0, 2, MidpointRounding.AwayFromZero);

            foreach (var item in obj)
            {
                item.exportamount = item.exportamount ?? 0;
                item.inboundamount = item.inboundamount ?? 0;
                item.instant_inventory_amount = item.instant_inventory_amount ?? 0;
                item.inv_age_0to1_month = item.inv_age_0to1_month ?? 0;
                item.inv_age_1to2_year = item.inv_age_1to2_year ?? 0;
                item.inv_age_1to3_month = item.inv_age_1to3_month ?? 0;
                item.inv_age_2to3_year = item.inv_age_2to3_year ?? 0;
                item.inv_age_3to6_month = item.inv_age_3to6_month ?? 0;
                item.inv_age_6to12_month = item.inv_age_6to12_month ?? 0;
                item.inv_age_gt3_year = item.inv_age_gt3_year ?? 0;
                item.month_total_exports = item.month_total_exports ?? 0;

                item.purchase_price = item.purchase_price ?? 0;
                item.quantity_begin_month_inventory = item.quantity_begin_month_inventory ?? 0;
                item.quantity_damaged = item.quantity_damaged ?? 0;
                item.quantity_end_month_inventory = item.quantity_end_month_inventory ?? 0;
                item.quantity_purchase_inbound = item.quantity_purchase_inbound ?? 0;
                item.quantity_inner_purchase = item.quantity_inner_purchase ?? 0;
                item.quantity_instant_inventory = item.quantity_instant_inventory ?? 0;
                item.quantity_overflow = item.quantity_overflow ?? 0;
                item.quantity_purchase_transit = item.quantity_purchase_transit ?? 0;

                item.quantity_sales = item.quantity_sales ?? 0;
                item.quantity_sku_changed = item.quantity_sku_changed ?? 0;
                item.quantity_transfer_transit = item.quantity_transfer_transit ?? 0;
                item.turnover_date = item.turnover_date ?? 0;
                item.turnover_rate = item.turnover_rate ?? 0;
            }

            return  JsonConvert.SerializeObject(new { total = total,rows = obj, count_row = countM});
        }


    }
}