﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    public class dc_platform_balance
    {
        public int id { get; set; }

        /// <summary>
        /// 平台编码
        /// </summary>
        public string platformcode { get; set; }

        /// <summary>
        /// 平台名称
        /// </summary>
        public string platformname { get; set; }

        /// <summary>
        /// 账户名称
        /// </summary>
        public string account { get; set; }


        /// <summary>
        /// 初始额统计日期
        /// </summary>
        public DateTime day { get; set; }


        /// <summary>
        /// 是否删除，1：已删除，0：未删除
        /// </summary>
        public int delstatus { get; set; }

        /// <summary>
        /// 付款主体
        /// </summary>
        public int paycompanyid { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string currency { get; set; }

        /// <summary>
        /// 总余额（原币种）
        /// </summary>
        public decimal amount { get; set; }

        /// <summary>
        /// 可用余额（原币种）
        /// </summary>
        public decimal userable_amount { get; set; }

        /// <summary>
        /// 冻结余额（原币种）
        /// </summary>
        public decimal freeze_amount { get; set; }

        /// <summary>
        /// 汇率（兑换人民币）
        /// </summary>
        public decimal exchangerate { get; set; }

        /// <summary>
        /// 总余额（人民币）
        /// </summary>
        public decimal amount_rmb { get; set; }

        /// <summary>
        /// 可用余额（人民币）
        /// </summary>
        public decimal userable_amount_rmb { get; set; }

        /// <summary>
        /// 冻结余额（人民币）
        /// </summary>
        public decimal freeze_amount_rmb { get; set; }

        /// <summary>
        /// 放款时间
        /// </summary>
        public DateTime puttime { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string notes { get; set; }

        /// <summary>
        /// 来源
        /// </summary>
        public string fromsource { get; set; }

        /// <summary>
        /// 上一期期末余额
        /// </summary>
        public decimal before_balance { get; set; }

        /// <summary>
        /// 本期销售额
        /// </summary>
        public decimal amount_sales { get; set; }

        /// <summary>
        /// 本期提现金额
        /// </summary>
        public decimal withdraw_amount { get; set; }

        /// <summary>
        /// 销售额统计日期
        /// </summary>
        public DateTime? saleday { get; set; }

    }
}
