﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Stock
{
    /// <summary>
    /// Sku库存分析报表
    /// Create by Allan
    /// At 2019-02-24
    /// </summary>
    public class mSkuStockAnalyze
    {
        /// <summary>
        /// 主键
        /// </summary>
        /// <returns></returns>
        public int id { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        /// <returns></returns>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        /// <returns></returns>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 百伦SKU
        /// </summary>
        /// <returns></returns>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 月初库存数
        /// </summary>
        /// <returns></returns>
        public int? quantity_begin_month_inventory { get; set; }

        /// <summary>
        /// 采购在途数
        /// </summary>
        /// <returns></returns>
        public int? quantity_purchase_transit { get; set; }

        /// <summary>
        /// 调拨在途数
        /// </summary>
        /// <returns></returns>
        public int? quantity_transfer_transit { get; set; }

        /// <summary>
        /// 采购入库数
        /// </summary>
        /// <returns></returns>
        public int? quantity_purchase_inbound { get; set; }

        /// <summary>
        /// 采购入库金额
        /// </summary>
        public decimal? purchase_inbound_amount { get; set; }

        /// <summary>
        /// 调拨入库数
        /// </summary>
        public int? quantity_transfer_inbound { get; set; }

        /// <summary>
        /// 调拨入库金额
        /// </summary>
        public decimal? transfer_inbound_amount { get; set; }

        /// <summary>
        /// 入库金额
        /// </summary>
        public decimal? inboundamount { get; set; }

        /// <summary>
        /// 报损数
        /// </summary>
        /// <returns></returns>
        public int? quantity_damaged { get; set; }

        /// <summary>
        /// 报溢数
        /// </summary>
        /// <returns></returns>
        public int? quantity_overflow { get; set; }

        /// <summary>
        /// sku转换数量
        /// </summary>
        /// <returns></returns>
        public int? quantity_sku_changed { get; set; }

        /// <summary>
        /// 销售数量
        /// </summary>
        /// <returns></returns>
        public int? quantity_sales { get; set; }

        /// <summary>
        /// 月末库存数
        /// </summary>
        /// <returns></returns>
        public int? quantity_end_month_inventory { get; set; }

        /// <summary>
        /// 周转率
        /// </summary>
        /// <returns></returns>
        public decimal? turnover_rate { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        /// <returns></returns>
        public int? turnover_date { get; set; }

        /// <summary>
        /// 库龄(0-1)月
        /// </summary>
        /// <returns></returns>
        public int? inv_age_0to1_month { get; set; }

        /// <summary>
        /// 库龄(1-3)月
        /// </summary>
        /// <returns></returns>
        public int? inv_age_1to3_month { get; set; }

        /// <summary>
        /// 库龄(3-6)月
        /// </summary>
        /// <returns></returns>
        public int? inv_age_3to6_month { get; set; }

        /// <summary>
        /// 库龄(6-12)月
        /// </summary>
        /// <returns></returns>
        public int? inv_age_6to12_month { get; set; }

        /// <summary>
        /// 库龄(1-2)年
        /// </summary>
        /// <returns></returns>
        public int? inv_age_1to2_year { get; set; }

        /// <summary>
        /// 库龄(2-3)年
        /// </summary>
        /// <returns></returns>
        public int? inv_age_2to3_year { get; set; }

        /// <summary>
        /// 库龄大于3年
        /// </summary>
        /// <returns></returns>
        public int? inv_age_gt3_year { get; set; }

        /// <summary>
        /// 即时库存数
        /// </summary>
        /// <returns></returns>
        public int? quantity_instant_inventory { get; set; }

        /// <summary>
        /// 即时库存金额
        /// </summary>
        public decimal? instant_inventory_amount { get; set; }

        /// <summary>
        /// 本月累计出口数
        /// </summary>
        /// <returns></returns>
        public int? month_total_exports { get; set; }

        /// <summary>
        /// 本月累计出口金额
        /// </summary>
        public decimal? exportamount { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        /// <returns></returns>
        public DateTime? gmt_create { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        /// <returns></returns>
        public DateTime? gmt_modified { get; set; }

        /// <summary>
        /// 采购单价
        /// </summary>
        /// <returns></returns>
        public decimal? purchase_price { get; set; }

        /// <summary>
        /// 内购数量
        /// </summary>
        public int? quantity_inner_purchase { get; set; }

    }
}
