﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Orders
{

    /// <summary>
    /// 订单信息
    /// </summary>
    public class dc_base_oms_order
    {
        public int id { get; set; }

        /// <summary>
        /// 平台订单号
        /// </summary>
        public string origin_order_id { get; set; }

        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 交易号
        /// </summary>
        public string transaction_id { get; set; }

        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime pay_time { get; set; }

        /// <summary>
        /// 支付方法
        /// </summary>
        public string pay_method { get; set; }

        /// <summary>
        /// 支付账号
        /// </summary>
        public string pay_account { get; set; }

        /// <summary>
        /// 支付状态
        /// </summary>
        public string pay_status { get; set; }

        /// <summary>
        /// 收款账号
        /// </summary>
        public string collection_account { get; set; }

        /// <summary>
        /// 平台订单类型
        /// </summary>
        public string platform_order_type { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }

        /// <summary>
        /// 订单创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 订单付款时间
        /// </summary>
        public DateTime paid_time { get; set; }

        /// <summary>
        /// 订单退款时间
        /// </summary>
        public DateTime refund_time { get; set; }

        /// <summary>
        /// 销售账号Id
        /// </summary>
        public string seller_id { get; set; }

        /// <summary>
        /// 账号id
        /// </summary>
        public int bailun_account_id { get; set; }

        /// <summary>
        /// 环球账号
        /// </summary>
        public string hq_account { get; set; }

        /// <summary>
        /// 销售账号
        /// </summary>
        public string seller_account { get; set; }

        /// <summary>
        /// 暂时不知道意思
        /// </summary>
        public string seller_order_id { get; set; }

        /// <summary>
        /// 销售账号邮箱
        /// </summary>
        public string seller_email { get; set; }

        /// <summary>
        /// 订单更新时间
        /// </summary>
        public DateTime order_update_time { get; set; }

        /// <summary>
        /// 百伦订单号
        /// </summary>
        public string bailun_order_id { get; set; }

        /// <summary>
        /// 平台订单状态
        /// </summary>
        public string platform_order_status { get; set; }

        /// <summary>
        /// 百伦订单状态
        /// </summary>
        public string bailun_order_status { get; set; }

        /// <summary>
        /// 百伦付款状态
        /// </summary>
        public string bailun_payment_status { get; set; }

        /// <summary>
        /// 百伦合并状态
        /// </summary>
        public string bailun_merge_status { get; set; }

        /// <summary>
        /// 百伦拦截状态
        /// </summary>
        public string bailun_interception_status { get; set; }

        /// <summary>
        /// 百伦发货状态
        /// </summary>
        public string bailun_shipping_status { get; set; }

        /// <summary>
        /// 销售订单汇率
        /// </summary>
        public decimal seller_order_exchange_rate { get; set; }

        /// <summary>
        /// 销售其他汇率
        /// </summary>
        public decimal seller_other_exchange_rate { get; set; }

        /// <summary>
        /// 财务订单汇率
        /// </summary>
        public decimal finance_order_exchange_rate { get; set; }

        /// <summary>
        /// 财务其他汇率
        /// </summary>
        public decimal finance_other_exchange_rate { get; set; }

        /// <summary>
        /// 订单币种
        /// </summary>
        public string order_currency { get; set; }

        /// <summary>
        /// 其他币种e.g.平台费
        /// </summary>
        public string other_currency { get; set; }

        /// <summary>
        /// 销售额
        /// </summary>
        public decimal amount_sales { get; set; }

        /// <summary>
        /// 收入总金额-原币种
        /// </summary>
        public decimal amount_total { get; set; }

        /// <summary>
        /// 运费收入金额-原币种
        /// </summary>
        public decimal amount_shipping { get; set; }

        /// <summary>
        /// 产品金额-原币种
        /// </summary>
        public decimal amount_product { get; set; }

        /// <summary>
        /// 税费收入金额-原币种
        /// </summary>
        public decimal amount_tax { get; set; }

        /// <summary>
        /// 调整金额-原币种
        /// </summary>
        public decimal amount_adjustment { get; set; }

        /// <summary>
        /// 礼品包装金额-原币种
        /// </summary>
        public decimal amount_gift_wrap { get; set; }

        /// <summary>
        /// 退款金额-原币种
        /// </summary>
        public decimal amount_refund { get; set; }

        /// <summary>
        /// 预付款-收钱没发货-人民币
        /// </summary>
        public decimal amount_prepaid { get; set; }

        /// <summary>
        /// 总支出费用-人民币
        /// </summary>
        public decimal cost_total { get; set; }

        /// <summary>
        /// 促销费用-原币种
        /// </summary>
        public decimal cost_promotion { get; set; }

        /// <summary>
        /// 平台费用
        /// </summary>
        public decimal cost_platform_fee { get; set; }

        /// <summary>
        /// 产品成本费用-人民币
        /// </summary>
        public decimal cost_product { get; set; }

        /// <summary>
        /// 发货支出费用-人民币
        /// </summary>
        public decimal cost_shipping { get; set; }

        /// <summary>
        /// 包装费用-人民币
        /// </summary>
        public decimal cost_package { get; set; }

        /// <summary>
        /// fba费用
        /// </summary>
        public decimal cost_fba_fee { get; set; }

        /// <summary>
        /// paypal费用-原币种
        /// </summary>
        public decimal cost_paypal_fee { get; set; }

        /// <summary>
        /// 退款佣金费用
        /// </summary>
        public decimal cost_refund_commisson { get; set; }

        /// <summary>
        /// 估算运费-人民币
        /// </summary>
        public decimal cost_estimate_logistics { get; set; }

        /// <summary>
        /// 头程费-人民币
        /// </summary>
        public decimal cost_first { get; set; }

        /// <summary>
        /// 处理费-百伦收取-人民币
        /// </summary>
        public decimal cost_handle_bailun { get; set; }

        /// <summary>
        /// 处理费-平台收取-人民币
        /// </summary>
        public decimal cost_handle_platform { get; set; }

        /// <summary>
        /// 尾程费-人民币
        /// </summary>
        public decimal cost_tail { get; set; }


        /// <summary>
        /// 利润=总收入-总支出
        /// </summary>
        public decimal profit_total { get; set; }

        /// <summary>
        /// 利润率
        /// </summary>
        public decimal profit_rate { get; set; }

        /// <summary>
        /// 收货国家
        /// </summary>
        public string receipt_country { get; set; }

        /// <summary>
        /// 收货城市
        /// </summary>
        public string receipt_city { get; set; }

        /// <summary>
        /// 收货州或区域
        /// </summary>
        public string receipt_area { get; set; }

        /// <summary>
        /// 收货街道
        /// </summary>
        public string receipt_address { get; set; }

        /// <summary>
        /// 收货门牌
        /// </summary>
        public string receipt_address_2 { get; set; }

        /// <summary>
        /// 收货邮编
        /// </summary>
        public string receipt_postal_code { get; set; }

        /// <summary>
        /// 收货人
        /// </summary>
        public string receiver { get; set; }

        /// <summary>
        /// 收货电话
        /// </summary>
        public string receiver_phone { get; set; }

        /// <summary>
        /// 买家账号Id
        /// </summary>
        public string buyer_id { get; set; }

        /// <summary>
        /// 买家账号
        /// </summary>
        public string buyer_name { get; set; }

        /// <summary>
        /// 买家账号
        /// </summary>
        public string buyer_email { get; set; }

        /// <summary>
        /// 是否FBA费用异常
        /// </summary>
        public int has_fba_exception { get; set; }

        /// <summary>
        /// 是否平台费用异常
        /// </summary>
        public int has_platform_exception { get; set; }

        /// <summary>
        /// 是否被平台取消
        /// </summary>
        public int has_cancle { get; set; }

        /// <summary>
        /// 区域Id
        /// </summary>
        public int area_id { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// sku数量
        /// </summary>
        public int salecount { get; set; }

        /// <summary>
        /// 平台费用比例
        /// </summary>
        public decimal platform_fee_rate { get; set; }

        /// <summary>
        /// 订单里百伦SKU总数量
        /// </summary>
        public int quantity_bailun_sku { get; set; }

        /// <summary>
        /// 订单总数
        /// </summary>
        public int order_count { get; set; }

        /// <summary>
        /// 提现损耗
        /// </summary>
        public decimal loss_withdrawal { get; set; }

    }
}
