﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Purchase
{
    /// <summary>
    /// 采购单信息
    /// </summary>
    public class mPurchase
    {
        /// <summary>
        /// 采购单编号
        /// </summary>
        public string purchase_id { get; set; }

        /// <summary>
        /// 采购状态
        /// </summary>
        public int buy_status { get; set; }

        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 主图
        /// </summary>
        public string sku_image { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string category_name { get; set; }

        /// <summary>
        /// 英文标题
        /// </summary>
        public string sku_title_en { get; set; }

        /// <summary>
        /// 中文标题
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 颜色
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 规格
        /// </summary>
        public string character { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 采购数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// 合计金额
        /// </summary>
        public decimal amount { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string currency { get; set; }

        /// <summary>
        /// 是否调拨
        /// </summary>
        public int has_transfer { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string supplier_name { get; set; }

        /// <summary>
        /// 采购员
        /// </summary>
        public string buyer_name { get; set; }

        /// <summary>
        /// 起始仓库名称
        /// </summary>
        public string warehouse_name_from { get; set; }

        /// <summary>
        /// 目标仓库名称
        /// </summary>
        public string warehouse_name_to { get; set; }

        /// <summary>
        /// 已发货数量
        /// </summary>
        public int sendcount { get; set; }

        /// <summary>
        /// 未发货数量
        /// </summary>
        public int nosendcount { get; set; }

        /// <summary>
        /// 已到货数量
        /// </summary>
        public int arrivalcount { get; set; }

        /// <summary>
        /// 未到货数量
        /// </summary>
        public int noarrivalcount { get; set; }

        /// <summary>
        /// 校验数量
        /// </summary>
        public int checkcount { get; set; }

        /// <summary>
        /// 校验通过数量
        /// </summary>
        public int check_success_count { get; set; }

        /// <summary>
        /// 校验不通过数量
        /// </summary>
        public int check_fail_count { get; set; }

        /// <summary>
        /// 质检数量
        /// </summary>
        public int qccount { get; set; }

        /// <summary>
        /// 质检通过数量
        /// </summary>
        public int qccount_success { get; set; }

        /// <summary>
        /// 质检不通过数量
        /// </summary>
        public int qccount_fail { get; set; }

        /// <summary>
        /// 缺失数量
        /// </summary>
        public int losscount { get; set; }

        /// <summary>
        /// 报损数量
        /// </summary>
        public int breakcount { get; set; }

        /// <summary>
        /// 退货数量
        /// </summary>
        public int  returncount {get;set;}

        /// <summary>
        /// 换货数量
        /// </summary>
        public int exchangecount { get; set; }

        /// <summary>
        /// 入库数量
        /// </summary>
        public int putincount { get; set; }

        /// <summary>
        /// 待调拨数量
        /// </summary>
        public int waitallotcount { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime update_time { get; set; }

        /// <summary>
        /// 同步时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

    }

    /// <summary>
    /// 采购单状态
    /// </summary>
    public enum EnumPurchaseStatus
    {
        //0待确认, 1已确认,2主管已审核3,发货入库中,4：采购完成, -2拆分订单, -1作废
        待确认 = 0,
        已确认 = 1,
        主管已审核 = 2,
        发货入库中 = 3,
        采购完成 = 4,
        拆分订单 = -2,
        作废 = -1
    }
}
