﻿Vue.component('el-table-control', {
    props: {
        //编码
        code: {
            type: String
        },
        //列
        listColumn: {
            type: Array
        },
        //过虑条件参数
        filterParams: {
            type: Object
        },
        //绑定值
        value: {
            default: null
        }
    },
    //双向绑定
    model: {
        prop: "value",
        event: "change"
    },
    //监听
    watch: {
        value: {
            handler(val) {
                this.$set(this, "listData", val || [])
            },
            deep: true,
            immediate: true
        },
        listData: {
            handler(val) {
                this.$emit("change", val)
            },
            deep: true
        }
    },
    data: function () {
        return {
            isFirst: false,
            listData: [],
            olistColumn: [],
            setting: {},
            rows: [],
            row: null
        }
    },
    methods: {
        //清空排序
        clearSort: function () {
            this.$refs.table.clearSort();
        },
        //清空列值
        clearColumnValue: function () {
            var that = this;
            if (that.setting.isShowColumnSearch && that.setting.listColumn && that.setting.listColumn.length) {
                that.setting.listColumn.forEach(function (l) {
                    l.value = null;
                })
            }
        },
        //清空选择
        clearSelection: function () {
            this.$refs.table.clearSelection();
        },
        //关闭弹出窗
        closeDialog() {
            this.$emit("close-dialog")
        },
        //弹出窗
        showDialog(title, form, code) {
            this.$emit("show-dialog", title, form, code)
        },
        //获取表单组件信息
        getTable: function () {
            var that = this;
            that.$http({
                method: 'get',
                url: "/Component/Table/Get",
                params: { code: that.code }
            }).then(function (response) {
                var result = response.data;
                if (response.status === 200 && result.result && result.data) {
                    that.setting = $.extend({}, result.data);
                    that.$emit("init", that.setting);
                    //引用JS脚本
                    if (that.setting.listJavascriptSrc) {
                        that.setting.listJavascriptSrc.forEach(function (l) {
                            that.srcScript(l);
                            console.log("src=" + l);
                        });
                    }
                    //自定义脚本
                    if (result.data.javascript) {
                        eval(result.data.javascript);
                    }
                    //自动查询
                    if (result.data.isAutoSearch) {
                        that.$nextTick(function () {
                            that.onSearch();
                        })
                    }
                    //组表头
                    if (that.setting.listColumn && that.setting.listColumn.length && that.setting.listColumn.findIndex(function (l) { return l.groupname }) > 0) {
                        //保存原生列
                        Vue.set(that, "olistColumn", that.setting.listColumn);
                        Vue.set(that.setting, "isGroupColumn", true);
                        var listColumn = [];
                        that.setting.listColumn.forEach((l, i) => {
                            if (l.groupname) {
                                if (i == 0 || that.setting.listColumn[i - 1].groupname != l.groupname) {
                                    listColumn.push({ name: l.groupname, listColumn: [l] });
                                } else {
                                    listColumn[listColumn.length - 1].listColumn.push(l);
                                }
                            } else {
                                listColumn.push(l);
                            }
                        });
                        Vue.set(that.setting, "listColumn", listColumn);
                    }
                } else {
                    that.$message((!result.data && "配置错误") || (result.Message || " 未知错误!"));
                }
            }, function (error) {
                that.$message(error.statusText || " 未知错误!");
            });
        },
        //获取选择行
        getSelectItems: function () {
            return this.$refs.table.selection;
        },
        //自定义JS
        javaScript(js, scope, column) {
            if (js) {
                return eval(js)
            }
        },
        //是否存在JS或CSS
        isInclude: function (name) {
            var js = /js$/i.test(name);
            var es = document.getElementsByTagName(js ? 'script' : 'link');
            for (var i = 0; i < es.length; i++) {
                if (es[i][js ? 'src' : 'href'].indexOf(name) != -1) {
                    return true;
                }
            }
            return false;
        },
        //同步引用JS
        srcScript: function (url) {
            if (url) {
                var include = this.isInclude(url);
                if (!include) {
                    var request = new XMLHttpRequest();
                    request.open("get", url, false);//false指定非异步执行
                    request.send(null);
                    var ele = document.createElement("script");
                    ele.setAttribute("type", "text/javascript");
                    ele.text = request.responseText;
                    document.body.appendChild(ele);
                }
            }
        },
        //初始化数据
        onInit: function () {
            this.isFirst = true;
        },
        //查询字段
        onSearchColumn: function () {
            var that = this;
            if (that.listColumn && that.listColumn.length > 0) {
                Vue.set(that.setting, "listColumn", that.listColumn);
            } else {
                that.$http.post("/Component/Table/GetListColumn", $.extend({ code: that.code }, that.filterParams), { emulateJSON: true }).then(function (response) {
                    var result = response.data;
                    if (response.status === 200 && result.result && result.data) {
                        Vue.set(that.setting, "listColumn", result.data);
                    } else {
                        that.$message(result.message || " 未知错误!");
                    }
                }, function (error) {
                    that.$message(error.statusText || " 未知错误!");
                });
            }
        },
        //查询数据
        onSearchData: function (filterParams, cb) {
            var that = this;
            var data = $.extend({ code: that.code }, (filterParams || that.filterParams));
            delete data.total
            that.$http.post("/Component/Table/GetListData", data, { emulateJSON: true, code: that.code }).then(function (response) {
                var result = response.data;
                if (response.status === 200 && result.result && result.data) {
                    if (that.filterParams) {
                        Vue.set(that.filterParams, "total", result.data.totalCount);
                    }
                    if (cb) {
                        cb.call(this, result)
                    } else {
                        Vue.set(that, "listData", (result.data.list || []));
                    }
                } else {
                    this.$message(result.message || " 未知错误!");
                }
            }, function (error) {
                this.$message(error.statusText || " 未知错误!");
            });
        },
        //查询
        onSearch: function (filterParams, cb) {
            var that = this;
            //查询列头
            if (!that.setting || (that.setting.columnType != 3 && !(!that.isFirst && that.setting.columnType == 1))) {
                that.onSearchColumn();
                that.isFirst = false;
            }
            that.onSearchData(filterParams, cb);
        },
        //排序
        onSortChange: function (column) {
            var that = this;
            if (column.order) {
                Vue.set(this.filterParams, 'ListOrder', [{ Field: column.prop, Operator: column.order }]);
            } else {
                Vue.set(this.filterParams, 'ListOrder', null);
            }
            this.onSearchData();
        },
        //表格行点击事件
        onRowClick: function (row, column) {
            var that = this;
            if (column && (that.setting.operateColumnName || '操作') != column.label) {
                if (that.setting.selectRowMethod == 2) {
                    this.$refs.table.toggleRowSelection(row, !this.$refs.table.selection || !this.$refs.table.selection.length || this.$refs.table.selection.findIndex(function (l) { return l == row }) < 0);
                }
                else if (that.setting.selectRowMethod == 1) {
                    this.radio = row["ID"];
                }
            }
        },
        //当前行改变事件
        onCurrentChange: function (currentRow) {
            this.row = currentRow;
        },
        //选择项发生变化事件
        onSelectionChange(selection) {
            this.$set(this, "rows", selection);
            this.$emit("selection-change", selection)
        },
        //顺序号
        onSequenceIndex: function (index) {
            return (this.filterParams.currentPage - 1) * this.filterParams.pageSize + index + 1;
        },
        //行数据的Key
        onRowKey: function (row) {
            var that = this
            if (that.setting.selectRowMethod && row && row.id) {
                return row.id;
            } else {
                return null;
            }
        },
        //单元格合并
        onSpanMethod: function (span) {
            var that = this;
            var cellspan = { rowspan: 1, colspan: 1 };
            var listColumn = that.olistColumn && that.olistColumn.length ? that.olistColumn : that.setting.listColumn;
            if (span.columnIndex < listColumn.length) {
                var column = listColumn[span.columnIndex]
                if (column.rowspanprop) {
                    if (span.rowIndex == 0 || that.listData[span.rowIndex - 1][column.rowspanprop] != that.listData[span.rowIndex][column.rowspanprop]) {
                        var lastIndex = that.listData.findIndex(function (l, i) { return (i > span.rowIndex && l[column.rowspanprop] != span.row[column.rowspanprop]) });
                        if (lastIndex < 0) {
                            lastIndex = that.listData.length + 1;
                        }
                        cellspan.rowspan = lastIndex - span.rowIndex;
                        cellspan.colspan = 1;
                    } else {
                        cellspan.rowspan = 0;
                        cellspan.colspan = 0;
                    }
                }
            }
            return cellspan;
        }
    },
    mounted: function () {
        this.onInit();
        this.getTable();
    },
    created: function () {

    },
    template: '#elTableControl'
});