﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using System.Web;

namespace Bailun.DC.Web.Base
{
    public class BaseController: Controller
    {
        //private readonly IHttpContextAccessor _contextAccessor;

        //public BaseController(IHttpContextAccessor contextAccessor)
        //{
        //    _contextAccessor = contextAccessor;

        //    var cookie = HttpContext.Request.Cookies["BLUserAcct"];
        //    if (cookie == null)
        //    {
        //        HttpContext.Response.Redirect(ConfigHelper.GetByName("LoginUrl"), true);
        //    }
        //}

        /// <summary>
        /// 查看是否还有物流往来统计服务在跑
        /// </summary>
        public static bool isRunLogisticsSupplierTransaction = false;


        #region Excel表格导出
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="list"></param>
        /// <param name="columns"></param>
        /// <param name="tbName"></param>
        /// <param name="Split_Sign">数据分隔符号</param>
        public void ToCSV(List<string> list, List<string> columns, string tbName, string filePath,string Split_Sign="|")
        {
            var strb = string.Empty;

            if (System.IO.File.Exists(filePath + tbName + ".csv"))
            {
                System.IO.File.Delete(filePath + tbName + ".csv");
            }

            if (!Directory.Exists(filePath))
            {
                Directory.CreateDirectory(filePath);
            }

            StreamWriter writer = new StreamWriter(filePath + tbName + ".csv", true, System.Text.Encoding.UTF8);
            writer.AutoFlush = true;
            //var ms = new System.IO.MemoryStream();

            //添加表头
            foreach (var item in columns)
            {
                strb += (item + ",");
            }
            strb.Remove(strb.Length - 1, 1);
            writer.WriteLine(strb.ToString());

            //ms.Write(System.Text.Encoding.UTF8.GetBytes(strb.ToString()+"\n"));

            //添加表内容
            foreach (var item in list)
            {
                var arr = item.Split(Split_Sign);
                strb = string.Empty;
                foreach (var rowitem in arr)
                {
                    var temp = rowitem.Replace("\"", "\"\"");//替换英文冒号 英文冒号需要换成两个冒号
                    if (temp.Contains(",") || temp.Contains("\"")
                        || temp.Contains("\r") || temp.Contains("\n")) //含逗号 冒号 换行符的需要放到引号中
                    {
                        temp = string.Format("\"{0}\"", temp);
                    }

                    strb += (temp + ",");
                }

                if (arr.Length > 0)
                {
                    strb.Remove(strb.Length - 1, 1);
                    writer.WriteLine(strb.ToString());
                    //ms.Write(System.Text.Encoding.UTF8.GetBytes(strb.ToString() + "\n"));
                }
            }

            writer.Flush();
            writer.Close();
            writer.Dispose();
        }

        public void ToExcel(DataTable dt, string filename, string filePath)
        {
            #region 保存文件  

            //创建全新的Workbook 
            var workbook = new HSSFWorkbook();//一個sheet最多65536行
            var count = 0;
            for (double i = 0; i < Convert.ToDouble(dt.Rows.Count) / Convert.ToDouble(65534); i++)//每个Excel文件的一个页签只能存放65536行数据
            {
                var row_index = 0;
                //创建Sheet
                workbook.CreateSheet("Sheet" + (i+1));
                //根据Sheet名字获得Sheet对象  
                var sheet = workbook.GetSheet("Sheet" + (i + 1));
                IRow row;
                row = sheet.CreateRow(row_index);

                //写入标题
                for (int j = 0; j < dt.Columns.Count; j++)
                {
                    row.CreateCell(j).SetCellValue(dt.Columns[j].Caption.ToString());
                }
                row = sheet.CreateRow(++row_index);

                //写入数据
                for (int j = 0; j < (dt.Rows.Count - count > 65534 ? 65534 : dt.Rows.Count - count); j++)
                {
                    var r = dt.Rows[j + count];
                    for (int k = 0; k < dt.Columns.Count; k++)
                    {
                        row.CreateCell(k).SetCellValue(r[k].ToString());

                        //如果是数字,判断是否需要转换为数字
                        //if (IsNumeric(r[k].ToString()))
                        //{
                        //    row.CreateCell(k).SetCellValue(Convert.ToDouble(r[k].ToString()));
                        //}
                        //else
                        //{
                        //    row.CreateCell(k).SetCellValue(r[k].ToString());
                        //}
                    }

                    row = sheet.CreateRow(++row_index);
                }
                count += row_index - 2;
            }
            //保存Workbook方式一： 以文件形式保存到服务器中（每次导出都会生成一个文件，慎重使用）
            //var FileName = DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";

            var sw = System.IO.File.Create(filePath + filename+ ".xls");
            workbook.Write(sw);
            sw.Close();
            
            #endregion
        }

        #endregion

        /// <summary>
        /// 文件分片上传
        /// </summary>
        /// <returns></returns>
        public JsonResult UploadFileFragment()
        {

            string fileName = Request.Form["name"];
            int index = Convert.ToInt32(Request.Form["chunk"]);//当前分块序号
            var guid = Request.Form["guid"];//前端传来的GUID号
            var dir = Directory.GetCurrentDirectory()+"\\tempUploadFile"; //Server.MapPath("~/Upload");//文件上传目录
            dir = Path.Combine(dir, guid);//临时保存分块的目录
            if (!System.IO.Directory.Exists(dir))
                    System.IO.Directory.CreateDirectory(dir);
            string filePath = Path.Combine(dir, index.ToString());//分块文件名为索引名，更严谨一些可以加上是否存在的判断，防止多线程时并发冲突
            var data = Request.Form.Files["file"];//表单中取得分块文件
            if (data != null)//为null可能是暂停的那一瞬间
            {
                var file = new FileStream(filePath, FileMode.Create);
                var stream = data.OpenReadStream();
                
                byte[] bytes = new byte[stream.Length];
                stream.Read(bytes, 0, bytes.Length);
                stream.Seek(0, SeekOrigin.Begin);

                BinaryWriter bw = new BinaryWriter(file);
                bw.Write(bytes);
                bw.Close();

                file.Close();
                file.Dispose();
            }
            return Json(new { erron = 0 });//

        }

        [HttpPost]
        public JsonResult MergeUploadFile(string guid, string platform, string website, string month, string filename,int datatype=1)
        {
            //uploadfiles

            if (string.IsNullOrEmpty(guid))
            {
                return Json(
                    new
                    {
                        success = false,
                        msg = "guid不能为空"
                    }
                );
            }

            if (string.IsNullOrEmpty(platform))
            {
                return Json(
                    new
                    {
                        success = false,
                        msg = "平台类型不能为空"
                    }
                );
            }

            if (string.IsNullOrEmpty(month))
            {
                return Json(
                    new
                    {
                        success = false,
                        msg = "请填写月份"
                    }
                );
            }


            var uploadDir = Directory.GetCurrentDirectory() + "\\tempUploadFile"; //Upload 文件夹
            var dir = Path.Combine(uploadDir, guid);//临时保存分块的目录
            var files = System.IO.Directory.GetFiles(dir);//获得下面的所有文件
            var finalPath = Path.Combine(uploadDir, filename);//最终的文件名（demo中保存的是它上传时候的文件名，实际操作肯定不能这样）
            var fs = new FileStream(finalPath, FileMode.Create);
            foreach (var part in files.OrderBy(x => x.Length).ThenBy(x => x))//排一下序，保证从0-N Write
            {
                var bytes = System.IO.File.ReadAllBytes(part);
                fs.Write(bytes, 0, bytes.Length);
                bytes = null;
                System.IO.File.Delete(part);//删除分块
            }

            var arr = filename.Split('.');

            var uploadFile = new Models.DataWareHouse.uploadfiles
            {
                filelen = fs.Length,
                filename = filename,
                filetype = arr[arr.Length - 1],
                status = 0,
                guidcode = guid,
                month = month,
                platform = platform,
                website = website ?? "",
                paramdata = "",
                hashcode = "",
                filekey = "",
                createtime = DateTime.Now,
                datatype = datatype  //1=销售平台
            };

            var _platformService = new Services.DataWareHouse.PlatformOrderServices();

            var result = _platformService.SaveFileData(uploadFile);

            fs.Close();
            fs.Dispose();
            Directory.Delete(dir);//删除文件夹


            fs = new FileStream(finalPath, FileMode.OpenOrCreate);

            var _hashcode = "";
            var _filekey = "";

            //把文件上传到七牛云
            var qiuniu = new QiNiuCloudHelper(ServiceFabric.Extension.ConfigManagerConf.GetValue("QiNiu:AccessKey"), ServiceFabric.Extension.ConfigManagerConf.GetValue("QiNiu:SecretKey"));
            qiuniu.UploadStream(fs, guid+"."+uploadFile.filetype,ref _hashcode, ref _filekey);

            uploadFile.hashcode = _hashcode;
            uploadFile.filekey = _filekey;

            //把七牛云返回的hash值更新到文件记录里面
            result += _platformService.UpdateFileData(uploadFile.id, uploadFile.hashcode, uploadFile.filekey);

            fs.Close();
            fs.Dispose();

            return Json(
                new {
                    success = string.IsNullOrEmpty(result),
                    msg = result
                }
            );
        }

        public System.Collections.ArrayList Dtb2Json(DataTable dtb)
        {

            System.Collections.ArrayList dic = new System.Collections.ArrayList();
            foreach (DataRow dr in dtb.Rows)
            {
                System.Collections.Generic.Dictionary<string, object> drow = new System.Collections.Generic.Dictionary<string, object>();

                foreach (DataColumn dc in dtb.Columns)
                {
                    drow.Add(dc.ColumnName, dr[dc.ColumnName]);
                }

                //判断是否空行，如果null值
                if (drow.ToList().Where(a => a.Value == null).Count() == drow.Count || drow.FirstOrDefault().Value == null)
                {
                    continue;
                }
                else
                {
                    dic.Add(drow);
                }

            }

            return dic;

        }
    }
}
