﻿using Bailun.DC.Common;
using Bailun.DC.Services;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace Bailun.DC.Web.Areas.DataWareHouse.Controllers
{
    [Area("DataWareHouse")]
    public class VoucherController : Base.BaseController
    {
        public IActionResult Index()
        {
            return View();
        }

        #region 导出凭证

        /// <summary>
        /// 获取凭证信息
        /// </summary>
        /// <returns></returns>
        public ActionResult GetVoucherList(DateTime month,string platform)
        {
            var data = new VoucherService().GetVoucherListNew(month, platform);

            var columns = JsonConvert.DeserializeObject<Dictionary<string, string>>(JsonConvert.SerializeObject(data.FirstOrDefault())).Select(x => x.Key).ToList();
            columns.Remove("取值列");
            columns.Remove("站点");


            var table = new DataTable();
            foreach (var item in columns)
            {
                table.Columns.Add(item);
            }
            foreach (var dataItem in data)
            {
                var row = table.NewRow();
                var dataObj = JsonConvert.DeserializeObject<Dictionary<string, string>>(JsonConvert.SerializeObject(dataItem));
                var index = 0;
                foreach (var dicItem in dataObj)
                {
                    if (columns.Contains(dicItem.Key))
                    {
                        row[dicItem.Key] = dicItem.Value;
                    }
                    index++;
                }
                table.Rows.Add(row);
            }
            var filepath = Directory.GetCurrentDirectory() + "\\Files\\Report\\" + DateTime.Now.ToString("yyyyMMdd") + "\\";
            var filename = $"亚马逊{month.Month}月凭证" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            ExcelHelper.DataTableToExcel(table, filepath + filename, true);
            var stream = System.IO.File.OpenRead(filepath + filename);//excel表转换成流
            return File(stream, "application/vnd.android.package-archive", Path.GetFileName(filepath + filename));//进行浏览器下载
        }
        #endregion
    }
}
