﻿using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Services.Component;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using System;
using System.IO;
using System.Text;

namespace Bailun.DC.Web.Areas.Component.Controllers
{
    [Area("Component")]
    public class OfflineDownloadController : Base.BaseController
    {
        [HttpPost]
        public JsonResult Export(OfflineQueryFilterDTO queryFilter)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                if (Request.ContentType.Contains("application/json"))
                {
                    using (Stream stream = Request.Body)
                    {
                        byte[] buffer = new byte[Request.ContentLength.Value];
                        stream.Read(buffer, 0, buffer.Length);
                        string content = Encoding.UTF8.GetString(buffer);
                        queryFilter = JsonConvert.DeserializeObject<OfflineQueryFilterDTO>(content);
                    }
                }
                result = new OfflineDownloadService().Export(queryFilter, this.GetBailunToken());
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult ReExport(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new OfflineDownloadService().ReExport(id, this.GetBailunToken());
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult Delete(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new OfflineDownloadService().Save(id, true);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

        private string GetBailunToken()
        {
            string bailunToken = default(string);
            string cookie = Request.Headers["Cookie"];
            if (!string.IsNullOrWhiteSpace(cookie))
            {
                int startIndex = cookie.IndexOf("BailunToken");
                if (startIndex > 0)
                {
                    int lastIndex = cookie.IndexOf(";", cookie.IndexOf("BailunToken"));
                    if (lastIndex > 0)
                    {
                        bailunToken = cookie.Substring(startIndex, lastIndex);
                    }
                    else
                    {
                        bailunToken = cookie.Substring(startIndex);
                    }
                }
            }
            if (!string.IsNullOrWhiteSpace(bailunToken))
            {
                string[] split = bailunToken.Split("=", StringSplitOptions.RemoveEmptyEntries);
                if (split.Length > 1)
                {
                    bailunToken = split[1];
                }
            }

            return bailunToken;
        }
    }
}
