﻿using Bailun.DC.Common;
using Bailun.DC.SyncAmazonAdFee.Models;
using Dapper;
using Microsoft.Extensions.Hosting;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Bailun.DC.SyncAmazonAdFee
{

    public class Services : BackgroundService
    {
        /// <summary>
        /// 4K提供的APP_KEY
        /// </summary>
        string appkey = "4k_&934dfjkdf)(9048390";

        /// <summary>
        /// 4K AmazonAdFee接口地址
        /// </summary>
        string url = "https://www.4kmiles.com/api2/api/campaignService/getReport";

        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            //每60分钟执行一次任务
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(60));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;
                if (now.Hour == 1)  //每天1点启动
                {
                    Console.WriteLine("开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    Init();
                    Console.WriteLine("任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
                else
                {
                    Console.WriteLine($"目前时间是{now.Hour}小时,还没到设定的同步时间");
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public Services()
        {
            Dapper.SimpleCRUD.SetDialect(SimpleCRUD.Dialect.MySQL);
        }

        public void Init(DateTime? startDate = null, DateTime? endDate = null)
        {
            IList<dc_base_company_account> listAccount = this.GetListAccount();
            if (listAccount?.Count > 0)
            {
                if (!startDate.HasValue)
                {
                    startDate = this.GetSyncDate();
                    Console.WriteLine($"同步开始日期{startDate.Value.ToString("yyyy-MM-dd")}");
                }
                if (!endDate.HasValue)
                {
                    endDate = DateTime.Today.AddDays(-1);
                }
                for (DateTime date = startDate.Value; date <= endDate.Value; date = date.AddDays(1))
                {
                    Console.WriteLine($"同步日期{date.ToString("yyyy-MM-dd")}");
                    foreach (dc_base_company_account account in listAccount)
                    {
                        var page = 1;
                        var pagesize = 1000;
                        var count = 0;
                        while (page == 1 || (page > 1 && count > 0))
                        {
                            try
                            {
                                long timeStamp = (long)(DateTime.Now.ToUniversalTime() - new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds;
                                string sign = CommonHelper.md5Encrypt($"{this.appkey}{timeStamp}{account.seller_id}{account.site_en.ToLower()}{this.appkey}").ToUpper();
                                string url = $"{this.url}?pageIndex={page}&pageSize={pagesize}&sellerId={account.seller_id}&site={account.site_en.ToLower()}&timeStamp={timeStamp}&updateDate={date.ToString("yyyy-MM-dd")}&sign={sign}";
                                string result = HttpHelper.NetHelper.Request(url);
                                Console.WriteLine($"接口地址:{url}");
                                if (!string.IsNullOrEmpty(result))
                                {
                                    var json = JsonConvert.DeserializeObject<response_result>(result);
                                    count = json?.details?.list?.Count ?? 0;
                                    if (json.code == 100 && count > 0)
                                    {
                                        //保存数据
                                        this.Save(json.details.list, account);
                                        Console.WriteLine($"已保存{count}条记录数据!");
                                    }
                                    page++;
                                }
                            }
                            catch (Exception ex)
                            {
                                Console.WriteLine(ex.Message);
                                Thread.Sleep(60 * 1000);
                            }
                        }
                    }
                }
            }
        }

        public IList<dc_base_company_account> GetListAccount()
        {
            IList<dc_base_company_account> list = default(IList<dc_base_company_account>);
            //Amazon平台
            int platform_id = 15;
            string sql = "select id, company_id, account_id, site_en, seller_id from dc_base_company_account where status = 1 and site_en > '' and platform_id = @platform_id";

            using (var db = new MySqlConnection(GlobalConfig.ConnectionString_Data))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }
                list = db.Query<dc_base_company_account>(sql, new { platform_id = platform_id }).ToList();
            }
            return list;
        }

        public DateTime GetSyncDate()
        {
            DateTime date = DateTime.Today.AddDays(-1);
            using (var db = new MySqlConnection(GlobalConfig.ConnectionString_Data))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }
                date = db.QueryFirstOrDefault<DateTime?>("SELECT MAX(DATE_FORMAT(t1.operation_time,'%Y-%m-%d')) FROM dc_base_finance_amazon_ad_product t1") ?? DateTime.Today.AddDays(-1);
            }

            return date;
        }

        public decimal GetExchangeRate(string fromCur, string toCur, DateTime? date)
        {
            decimal rate = 0m;

            using (var db = new MySqlConnection(GlobalConfig.ConnectionString_Data))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }
                rate = db.QueryFirstOrDefault<decimal?>("select exchange_rate from dc_exchange_rate where init_curreny = @init_curreny and final_curreny = @final_curreny and record_time = @record_time", new { init_curreny = fromCur, final_curreny = toCur, record_time = (date ?? DateTime.Now).ToString("yyyy-MM-dd") }) ?? 0m;
            }

            if (rate == 0m)
            {
                var url = $"{GlobalConfig.OAUrl}/api/ExchangeRate/GetExchangeRateByCurAndDate?fromCur={fromCur}&toCur={toCur}&data={(date ?? DateTime.Now).ToString("yyyy-MM-dd")}";
                var result = HttpHelper.NetHelper.Request(url);
                try
                {
                    rate = JsonConvert.DeserializeObject<response_exchange_rate>(result)?.Rate ?? 0m;
                }
                catch (Exception ex)
                {
                    Console.WriteLine($"获取OA汇率异常:{ex.Message}");
                }

            }

            return rate;
        }

        public void Save(IList<response_amazon_ad_fee> list, dc_base_company_account account)
        {
            using (var db = new MySqlConnection(GlobalConfig.ConnectionString_Data))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }

                foreach (var item in list)
                {
                    var m = JsonConvert.DeserializeObject<dc_base_finance_amazon_ad_product>(JsonConvert.SerializeObject(item));
                    m.account_id = account.account_id;
                    m.company_id = account.company_id;
                    m.exchange_rate = this.GetExchangeRate(m.currency, "CNY", m.report_date);
                    m.exchange_rate_usd = this.GetExchangeRate(m.currency, "USD", m.report_date);
                    m.campaign_name = m.campaign_name ?? string.Empty;
                    m.campaign_id = m.campaign_id ?? string.Empty;
                    m.ad_group_name = m.ad_group_name ?? string.Empty;
                    m.ad_group_id = m.ad_group_id ?? string.Empty;
                    m.impressions = m.impressions ?? 0;
                    m.clicks = m.clicks ?? 0;
                    m.cost = m.cost ?? 0;
                    m.currency = m.currency ?? string.Empty;
                    m.asin = m.asin ?? string.Empty;
                    m.sku = m.sku ?? string.Empty;
                    m.attributed_conversions_sevenday = m.attributed_conversions_sevenday ?? 0;
                    m.attributed_conversions_sevenday_same_sku = m.attributed_conversions_sevenday_same_sku ?? string.Empty;
                    m.attributed_units_ordered_sevenday = m.attributed_units_ordered_sevenday ?? 0;
                    m.attributed_sales_sevenday = m.attributed_sales_sevenday ?? 0;
                    m.attributed_sales_sevenday_same_sku = m.attributed_sales_sevenday_same_sku ?? string.Empty;
                    m.attributed_units_ordered_sevenday_same_sku = m.attributed_units_ordered_sevenday_same_sku ?? string.Empty;
                    m.bj_modify_time = DateTime.Now;
                    switch (m.type)
                    {
                        case null:
                            m.type = 0;
                            break;
                        case 0:
                            m.type = 1;
                            break;
                        case 1:
                            m.type = 4;
                            break;
                    }
                    int count = 0;
                    if (m.data_id.HasValue && m.data_id.Value > 0)
                    {
                        count = db.Execute($@"update dc_base_finance_amazon_ad_product 
                                                    set 
                                                      campaign_name = @campaign_name
                                                    , campaign_id = @campaign_id
                                                    , ad_group_name = @ad_group_name
                                                    , ad_group_id = @ad_group_id
                                                    , impressions = @impressions
                                                    , clicks = @clicks
                                                    , cost = @cost
                                                    , currency = @currency 
                                                    , asin = @asin 
                                                    , sku = @sku 
                                                    , attributed_conversions_sevenday = @attributed_conversions_sevenday 
                                                    , attributed_conversions_sevenday_same_sku = @attributed_conversions_sevenday_same_sku 
                                                    , attributed_units_ordered_sevenday = @attributed_units_ordered_sevenday 
                                                    , attributed_sales_sevenday = @attributed_sales_sevenday 
                                                    , attributed_sales_sevenday_same_sku = @attributed_sales_sevenday_same_sku 
                                                    , attributed_units_ordered_sevenday_same_sku = @attributed_units_ordered_sevenday_same_sku 
                                                    , report_date = @report_date 
                                                    , operation_time = @operation_time 
                                                    , type = @type 
                                                    , account_id = @account_id 
                                                    , company_id = @company_id 
                                                    , bj_modify_time = @bj_modify_time 
                                                    , exchange_rate = @exchange_rate 
                                                    , exchange_rate_usd = @exchange_rate_usd
                                                    , data_id = @data_id
                                              where (`company_id`=@company_id AND `account_id`=@account_id AND `campaign_id`=@campaign_id AND `ad_group_id`=@ad_group_id AND `sku`=@sku AND `report_date`=@report_date AND `type`=@type) OR (`data_id`=@data_id)", m); 
                    }
                    if (count == 0)
                    {
                        m.bj_create_time = DateTime.Now;
                        db.Insert(m);
                    }
                }
            }
        }
    }
}
