﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using Bailun.DC.Models;
using Bailun.DC.Common;
using System.Linq;

namespace Bailun.DC.Services
{
    /// <summary>
    /// 用户权限
    /// </summary>
    public class UserAuthorityServices
    {
        /// <summary>
        /// 判断用户是否有导出权限
        /// </summary>
        /// <param name="code"></param>
        /// <param name="userid"></param>
        /// <returns></returns>
        public static bool checkUserExportAuthority(string code,int userid)
        {
            var sql = $"select * from dc_base_user_authoritys where has_export = 1 and code='{code}' and userid="+userid;

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirstOrDefault<dc_base_user_authoritys>(sql);

                return obj != null;
            }
        }

        /// <summary>
        /// 判断用户是否有导出权限
        /// </summary>
        /// <param name="code"></param>
        /// <param name="userid"></param>
        /// <returns></returns>
        public static bool checkUserExportAuthority(string code, string username)
        {
            var sql = $@"select count(t1.id) from dc_base_user_authoritys t1
                        join dc_user_role_relation t2 on t1.roleid=t2.role_id and t2.username='{username}'
                        where t1.has_export = 1 and t1.code='{code}'"; 
                //$@"select * from dc_base_user_authoritys where has_export = 1 and code='{code}' and username='" + username+"'";

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.ExecuteScalar<int>(sql);

                return obj>0;
            }
        }

        public string Add(List<dc_base_user_authoritys> list)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                foreach (var item in list)
                {
                    cn.Insert<dc_base_user_authoritys>(item);
                }

            }

            return "";
        }

        /// <summary>
        /// 保存导出权限
        /// </summary>
        /// <param name="roleid">角色id</param>
        /// <param name="code">权限编码</param>
        /// <param name="uid">当前用户id</param>
        /// <param name="username">当前用户名称</param>
        /// <returns></returns>
        public string Save(int roleid, List<string> code,int uid,string username)
        {
            try
            {
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    cn.Execute("update dc_base_user_authoritys set has_export=0,lastupdatetime='" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "',lastupdateuserid=" + uid + ",lastupdateusername='" + username + "' where roleid=" + roleid);

                    var listCode = cn.Query<dc_base_user_authoritys_code_config>("select * from dc_base_user_authoritys_code_config where type=1 and delstatus=0 and code in ('" + string.Join("','", code) + "')");

                    foreach (var item in code)
                    {
                        var objCode = listCode.Where(a => a.code == item).FirstOrDefault();
                        if (objCode != null)
                        {
                            var obj = cn.QueryFirstOrDefault<dc_base_user_authoritys>("select * from dc_base_user_authoritys where roleid=" + roleid + " and code='" + objCode.code + "'");
                            if (obj == null)
                            {
                                obj = new dc_base_user_authoritys()
                                {
                                    code = objCode.code,
                                    createtime = DateTime.Now,
                                    createuserid = uid,
                                    createusername = username,

                                    has_export = 1,
                                    lastupdatetime = DateTime.Now,
                                    lastupdateuserid = uid,
                                    lastupdateusername = username,

                                    notes = objCode.name,
                                    roleid = roleid,
                                    userid = 0,
                                    username = "",
                                };

                                cn.Insert<dc_base_user_authoritys>(obj);
                            }
                            else
                            {
                                obj.has_export = 1;
                                obj.lastupdatetime = DateTime.Now;
                                obj.lastupdateuserid = uid;
                                obj.lastupdateusername = username;

                                cn.Update(obj);
                            }
                        }
                    }
                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }

        /// <summary>
        /// 获取角色可导出的权限
        /// </summary>
        /// <param name="roleid"></param>
        /// <returns></returns>
        public List<dc_base_user_authoritys> GetRoleExportAuthority(int roleid)
        {
            var sql = $"select * from dc_base_user_authoritys where has_export = 1 and roleid="+roleid;

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.Query<dc_base_user_authoritys>(sql);

                return obj.ToList();
            }
        }

        /// <summary>
        /// 获取导出权限的编码数组
        /// </summary>
        /// <returns></returns>
        public static List<dc_base_user_authoritys_code_config> ListCodeConfig()
        {
            var sql = "select * from dc_base_user_authoritys_code_config where type=1 and delstatus=0 ";
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                return cn.Query<dc_base_user_authoritys_code_config>(sql).AsList();
            }
        }

    }
}
