﻿using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Models.DataWareHouse;
using Bailun.DC.Models.DataWareHouse.DTO;
using Bailun.DC.Services.Component;
using Dapper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Bailun.DC.Services.DataWareHouse
{
    /// <summary>
    /// 同步组件
    /// </summary>
    public class SyncService : BaseService
    {
        /// <summary>
        /// 加载资金系统亚马逊交易流水
        /// </summary>
        /// <param name="month">年月</param>
        /// <returns>加载结果</returns>
        public ResultDTO LoadFundAmazonTransaction(string month)
        {
            ResultDTO result = new ResultDTO();
            if (!string.IsNullOrWhiteSpace(month))
            {
                IList<FundAmazonTransactionDTO> list = default(IList<FundAmazonTransactionDTO>);
                string sql = $@"SELECT
	                                 t1.account_name AS AccountName
	                                ,t1.market as Website
	                                ,DATE_FORMAT(report_month,'%Y-%m') AS `Month`
	                                ,count(*) AS `ReportCount`
                                FROM
	                                `amazon_transaction_detail` t1 
                                WHERE
	                                report_month = CONCAT(@month,'-01 00:00:00')
                                GROUP BY
	                                 t1.market
	                                ,t1.account_name
	                                ,`month`";
                using (var db = FUND_DB)
                {
                    list = db.Query<FundAmazonTransactionDTO>(sql, new { Month = month }).ToList();
                }
                if (list?.Count > 0)
                {
                    using (var db = DW_DB)
                    {
                        if (db.State == System.Data.ConnectionState.Closed)
                        {
                            db.Open();
                        }

                        foreach (FundAmazonTransactionDTO dto in list)
                        {
                            flowing_sales_progress entity = new flowing_sales_progress()
                            {
                                platform = "亚马逊",
                                account_name = dto.AccountName,
                                website = dto.Website,
                                month = dto.Month,
                                fund_flowing_count = dto.ReportCount,
                                sync_flowing_count = 0,
                                sync_time_count = 0,
                                sync_status = 0,
                                delstatus = false,
                                update_time = DateTime.Now,
                            };
                            sql = $@"UPDATE flowing_sales_progress 
                                     SET
	                                    fund_flowing_count = @fund_flowing_count
                                     WHERE 1 = 1
	                                     AND platform = @platform
	                                     AND account_name = @account_name
	                                     AND website = @website
	                                     AND month = @month";
                            int count = db.Execute(sql, entity);
                            if (count == 0)
                            {
                                entity.create_time = DateTime.Now;
                                db.Insert(entity);
                            }
                        }
                    }
                    result.Result = true;
                    result.Message = "加载成功!";
                }
                else
                {
                    result.Message = "没数据加载!";
                }
            }
            else
            {
                result.Message = "年月不能为空!";
            }

            return result;
        }

        /// <summary>
        /// 加载资金系统亚马逊交易流水
        /// </summary>
        /// <param name="month">年月</param>
        /// <returns>加载结果</returns>
        public ResultDTO FundAmazonTransaction(string month, IEnumerable<FundAmazonTransactionDTO> listDto)
        {
            ResultDTO result = new ResultDTO();
            if (!string.IsNullOrWhiteSpace(month) || listDto?.Count() > 0)
            {
                IList<FundAmazonTransactionDTO> list = default(IList<FundAmazonTransactionDTO>);
                DateTime[] months = !string.IsNullOrWhiteSpace(month) ? new DateTime[] { DateTime.Parse(month) } : listDto.Where(l => !string.IsNullOrWhiteSpace(l.Month)).Select(l => DateTime.Parse(l.Month)).Distinct().ToArray();
                string sql = $@"SELECT
                                     id as Id
                                    ,'亚马逊' AS Platform
                                    ,t1.account_name AS AccountName
	                                ,t1.market as Website
	                                ,DATE_FORMAT(report_month,'%Y-%m') AS `Month`
	                                ,data_json AS `DataJson`
                                FROM
	                                `amazon_transaction_detail` t1 
                                WHERE
	                                report_month in @months";
                using (var db = FUND_DB)
                {
                    list = db.Query<FundAmazonTransactionDTO>(sql, new { months = months }).ToList();
                }
                if (list?.Count > 0)
                {
                    using (var db = DW_DB)
                    {
                        sql = $@"UPDATE flowing_sales_progress
                                     SET
	                                     sync_status = @sync_status
                                     WHERE 1 = 1
                                         AND sync_status < 1
	                                     AND {(!string.IsNullOrWhiteSpace(month) ? "month = @month" : "id in @id")}";
                        //同步为进行中状态
                        int count = db.Execute(sql, new { sync_status = 1, month = month, id = listDto.Select(l => l.Id).ToArray() });
                    }
                    Task task = Task.Factory.StartNew(() =>
                    {
                        int count = 0;
                        if (listDto?.Count() > 0)
                        {
                            list = list.Where(l => listDto.Select(l2 => l2.Month).Distinct().Contains(l.Month) && listDto.Select(l2 => l2.AccountName).Distinct().Contains(l.AccountName) && listDto.Select(l2 => l2.Website).Distinct().Contains(l.Website)).ToList();
                        }
                        using (var db = DW_DB)
                        {
                            if (db.State == System.Data.ConnectionState.Closed)
                            {
                                db.Open();
                            }
                            //同步流水
                            foreach (FundAmazonTransactionDTO dto in list)
                            {
                                flowing_sales entity = new flowing_sales
                                {
                                    accountname = dto.AccountName,
                                    jsondata = dto.DataJson,
                                    month = dto.Month,
                                    orderno = "",
                                    website = dto.Website ?? "",
                                    platform = dto.Platform,
                                    platformsku = "",
                                    createuser = "web",
                                    delstatus = 0,
                                    has_error = 0,
                                    md5code = dto.Id,
                                };
                                sql = $@"UPDATE flowing_sales
                                     SET
	                                     accountname = @accountname
                                        ,jsondata = @jsondata
                                        ,month = @month
                                        ,website = @website
                                        ,platform = @platform
                                        ,jsondata = @jsondata
                                     WHERE 1 = 1
	                                     AND md5code = @md5code";
                                count = db.Execute(sql, entity);
                                if (count == 0)
                                {
                                    entity.createtime = DateTime.Now;
                                    db.Insert(entity);
                                }
                            }
                            //同步状态
                            sql = $@"UPDATE flowing_sales_progress t1
                                     INNER JOIN (
                                     SELECT t2.accountname,t2.website,t2.`month`,count(*) AS sync_flowing_count FROM flowing_sales t2
                                     WHERE 1 = 1
                                     AND t2.platform = '亚马逊'
                                     AND `month` IN @month
                                     GROUP BY 
                                          t2.accountname
		                                 ,t2.website
		                                 ,t2.`month`
                                     ) 
                                     AS t2 
	                                     ON t1.account_name = t2.accountname
	                                     AND t1.website = t2.website
	                                     AND t1.`month` = t2.`month`
                                     SET 
	                                     t1.sync_flowing_count = t2.sync_flowing_count,
	                                     t1.sync_status = 2
                                     WHERE t1.platform = '亚马逊'
                                     AND t1.`month` IN @month
                                     AND t1.sync_status < 2";
                            count = db.Execute(sql, new { month = months.Select(l => l.ToString("yyyy-MM")).ToArray() });
                        }
                    });
                    result.Result = true;
                    result.Message = "正在同步!";
                }
                else
                {
                    result.Message = "没数据加载!";
                }
            }
            else
            {
                result.Message = "年月不能为空!";
            }

            return result;
        }
    }
}
