﻿using System;
using System.Collections.Generic;
using System.Text;
using Bailun.DC.Models.DataWareHouse;
using Dapper;
using MySql.Data.MySqlClient;


namespace Bailun.DC.Services.DataWareHouse
{
    public class OrderFeeConfigServices
    {
        /// <summary>
        /// 流水取数规则配置列表
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="datatype"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public List<order_fee_config> ListOrderFeeConfig(Models.BtTableParameter parameter, string platform, string website,int? datatype,ref int total)
        {
            var list = new List<order_fee_config>();
            var sql = "select * from order_fee_config where delstatus=0 ";

            var sqlparam = new DynamicParameters();

            if(!string.IsNullOrEmpty(platform))
            {
                sql += " and platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and website = @website";
                sqlparam.Add("website", website);
            }

            if(datatype.HasValue)
            {
                sql += " and datatype="+datatype.Value;
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                if (parameter.limit == 0)
                {
                    list = cn.Query<order_fee_config>(sql, sqlparam).AsList();
                }
                else
                {
                    var obj = cn.Page<order_fee_config>(parameter.pageIndex, parameter.limit, sql, ref total, sqlparam);
                    list = obj.AsList();
                }
            }

            return list;
        }

        /// <summary>
        /// 批量删除配置
        /// </summary>
        /// <param name="ids"></param>
        /// <param name="uid"></param>
        /// <param name="username"></param>
        /// <returns></returns>
        public string BulkDelete(List<int> ids,int uid,string username)
        {
            try
            {
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    var sql = $"update order_fee_config set delstatus=1 where id in ('{string.Join("','", ids)}')";

                    cn.Execute(sql);
                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
            
        }

        /// <summary>
        /// 删除配置
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string DelOrderFeeConfig(int id)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirstOrDefault<order_fee_config>("select * from order_fee_config where delstatus=0 and id=" + id);
                if (obj != null)
                {
                    obj.delstatus = 1;
                    cn.Update(obj);
                }
                else
                {
                    return "找不到该配置";
                }
            }

            return "";

        }
    }
}
