﻿using System.ComponentModel;

namespace Bailun.DC.Models.WebApiModels
{
    /// <summary>
    /// 预计销售利润表
    /// </summary>
    public class MonthSalesProfitDto
    {
        /// <summary>
        /// auto_increment
        /// </summary>
        [ParentName("id")]
        public int id { get; set; }
        /// <summary>
        /// 月份
        /// </summary>
        [ParentName("月份")]
        public string month { get; set; }
        /// <summary>
        /// 总销售额
        /// </summary>
        [ParentName("销售额", ParentNameEnum.amount_sales)]
        public decimal amount_sales { get; set; }
        /// <summary>
        /// 销售额-精油
        /// </summary>
        [ParentName("精油产品", ParentNameEnum.amount_sales)]
        public decimal amount_sales_jingyou { get; set; }
        /// <summary>
        /// 销售额-电子
        /// </summary>
        [ParentName("电子产品", ParentNameEnum.amount_sales)]
        public decimal amount_sales_dianzi { get; set; }
        /// <summary>
        /// 销售额-家居产品
        /// </summary>
        [ParentName("家居产品", ParentNameEnum.amount_sales)]
        public decimal amount_sales_jiaju { get; set; }
        /// <summary>
        /// 销售额-美容美甲产品
        /// </summary>
        [ParentName("美容美甲产品", ParentNameEnum.amount_sales)]
        public decimal amount_sales_meirongmj { get; set; }
        /// <summary>
        /// 销售额-服装
        /// </summary>
        [ParentName("服装", ParentNameEnum.amount_sales)]
        public decimal amount_sales_fuzhuang { get; set; }

        /// <summary>
        /// 销售额-其他
        /// </summary>
        [ParentName("其他", ParentNameEnum.amount_sales)]
        public decimal amount_sales_other { get; set; }

        /// 平台退款
        /// </summary>
        [ParentName("退款", ParentNameEnum.amount_sales)]
        public decimal fee_refund { get; set; }

        /// <summary>
        /// 总成本
        /// </summary>
        [ParentName("成本", ParentNameEnum.cost)]
        public decimal cost { get; set; }
        /// <summary>

        /// <summary>
        /// 精油成本
        /// </summary>
        [ParentName("精油产品", ParentNameEnum.cost)]
        public decimal cost_jingyou { get; set; }
        /// <summary>
        /// 电子成本
        /// </summary>
        [ParentName("电子产品", ParentNameEnum.cost)]
        public decimal cost_dianzi { get; set; }
        /// <summary>
        /// 家居成本
        /// </summary>
        [ParentName("家居产品", ParentNameEnum.cost)]
        public decimal cost_jiaju { get; set; }
        /// <summary>
        /// 美容美甲产品成本
        /// </summary>
        [ParentName("美容美甲产品", ParentNameEnum.cost)]
        public decimal cost_meirongmj { get; set; }
        /// <summary>
        /// 服装成本
        /// </summary>
        [ParentName("服装", ParentNameEnum.cost)]
        public decimal cost_fuzhuang { get; set; }

        /// <summary>
        /// 其他成本
        /// </summary>
        [ParentName("其它", ParentNameEnum.cost)]
        public decimal cost_other { get; set; }

        /// <summary>
        /// 平台费
        /// </summary>
        [ParentName("平台费用", ParentNameEnum.fee_platform)]
        public decimal fee_platform { get; set; }

        /// <summary>
        /// 广告及宣传费用
        /// </summary>
        [ParentName("广告及宣传费", ParentNameEnum.fee_platform)]
        public decimal fee_ad { get; set; }
        /// <summary>
        /// 佣金及平台费-亚马逊FBA
        /// </summary>
        [ParentName("佣金及平台费-亚马逊FBA", ParentNameEnum.fee_platform)]
        public decimal fee_fba { get; set; }
        /// <summary>
        /// 佣金及平台费-亚马逊非FBA
        /// </summary>
        [ParentName("佣金及平台费-亚马逊非FBA", ParentNameEnum.fee_platform)]
        public decimal? fee_nofba { get; set; }//new
        /// <summary>
        /// 佣金及平台费-Ebay
        /// </summary>
        [ParentName("佣金及平台费-Ebay", ParentNameEnum.fee_platform)]
        public decimal? fee_ebay { get; set; }//new
        /// <summary>
        /// 佣金及平台费-其他平台
        /// </summary>
        [ParentName("佣金及平台费-其他平台", ParentNameEnum.fee_platform)]
        public decimal? fee_ohtre { get; set; }//new
        ///// <summary>
        ///// 平台扣费及退款
        ///// </summary>
        //[ParentName("平台费", ParentNameEnum.fee_platform)]
        //public decimal fee_platform_and_refund { get; set; }


        /// <summary>
        /// 物流仓储费用
        /// </summary>
        [ParentName("物流仓储费用", ParentNameEnum.fee_logistics_storage)]
        public decimal fee_logistics_storage { get; set; }
        ///// <summary>
        ///// 平台提现回款
        ///// </summary>
        //public decimal amount_withdraw { get; set; }
        /// <summary>
        /// 头程运输
        /// </summary>
        [ParentName("头程运输-平台", ParentNameEnum.fee_logistics_storage)]
        public decimal fee_logistics_first { get; set; }
        [ParentName("头程运输-非平台", ParentNameEnum.fee_logistics_storage)]
        public decimal? fee_nologistics_first { get; set; }//new


        /// <summary>
        /// 尾程物流费
        /// </summary>
        [ParentName("尾程物流费-平台", ParentNameEnum.fee_logistics_storage)]
        public decimal fee_logistics_tail { get; set; }
        [ParentName("尾程物流费-非平台", ParentNameEnum.fee_logistics_storage)]
        public decimal? fee_nologistics_tail { get; set; }//new

        /// <summary>
        /// 直邮物流费
        /// </summary>
        [ParentName("直邮物流费-平台", ParentNameEnum.fee_logistics_storage)]
        public decimal fee_logistics_direct { get; set; }
        [ParentName("直邮物流费-非平台", ParentNameEnum.fee_logistics_storage)]
        public decimal? fee_nologistics_direct { get; set; }//new
        /// <summary>
        /// 仓储费
        /// </summary>
        [ParentName("仓储费-平台", ParentNameEnum.fee_logistics_storage)]
        public decimal fee_storage { get; set; }
        [ParentName("仓储费-非平台", ParentNameEnum.fee_logistics_storage)]
        public decimal? fee_nostorage { get; set; }//new

        ///// <summary>
        ///// 海外仓其他杂费
        ///// </summary>
        //[ParentName("海外仓其他杂费", ParentNameEnum.fee_logistics_storage)]
        //public decimal fee_storage_incidentals { get; set; }

        ///// <summary>
        ///// 付现销售费用
        ///// </summary>
        //[ParentName("付现销售费用", ParentNameEnum.fee_logistics_storage)]
        //public decimal fee_paycash_sales { get; set; }

        //[ParentName("销售费用-税金", ParentNameEnum.fee_sales_taxes)]
        public decimal? fee_sales_taxes { get; set; }//new
        /// <summary>
        /// 销售费用合计
        /// </summary>
        [ParentName("销售费用合计", ParentNameEnum.fee_sales_count)]
        public decimal fee_sales_count { get; set; }
        /// <summary>
        /// 销售利润
        /// </summary>
        [ParentName("销售利润", ParentNameEnum.fee_sales_count)]
        public decimal profit_sales { get; set; }
        /// <summary>
        /// 销售毛利率
        /// </summary>
        [ParentName("销售毛利率", ParentNameEnum.fee_sales_count)]
        public decimal rate_profit_sales { get; set; }

        /// <summary>
        /// 财务费用
        /// </summary>
        [ParentName("财务费用", ParentNameEnum.fee_sales_count)]
        public decimal fee_finance { get; set; }

        /// <summary>
        /// 管理成本合计
        /// </summary>
        [ParentName("管理成本合计", ParentNameEnum.managercost_count)]
        public decimal managercost_count { get; set; }

        /// <summary>
        /// 管理成本-广州百伦
        /// </summary>
        [ParentName("广州百伦供应链科技有限公司", ParentNameEnum.managercost_count)]
        public decimal managecost_bl_gz { get; set; }
        /// <summary>
        /// 管理成本-香港百伦
        /// </summary>
        [ParentName("香港百伦科技有限公司", ParentNameEnum.managercost_count)]
        public decimal managecost_bl_xg { get; set; }
        /// <summary>
        /// 管理成本-杨杉
        /// </summary>
        [ParentName("深圳前海扬杉创新科技有限公司", ParentNameEnum.managercost_count)]
        public decimal managercost_yangshan { get; set; }
        /// <summary>
        /// 管理成本-信荟蓝
        /// </summary>
        [ParentName("广州信荟蓝科技有限公司", ParentNameEnum.managercost_count)]
        public decimal managercost_xinhuilan { get; set; }
        /// <summary>
        /// 管理成本-广州电子服装仓
        /// </summary>
        [ParentName("广州电子服装仓", ParentNameEnum.managercost_count)]
        public decimal? managercost_gzdz { get; set; }//new
        [ParentName("阳山仓", ParentNameEnum.managercost_count)]
        public decimal? managercost_ys { get; set; }//new
        /// <summary>
        /// 管理成本-美容美甲店
        /// </summary>
        [ParentName("广州歌戈儿生活科技有限公司（含分公司）", ParentNameEnum.managercost_count)]
        public decimal managecost_meijia { get; set; }
        /// <summary>
        /// 迪致美容
        /// </summary>
        [ParentName("广州迪致美容科技有限公司", ParentNameEnum.managercost_count)]
        public decimal managercost_dizhi { get; set; }
        /// <summary>
        /// 广州灵酷跨境科技有限公司
        /// </summary>
        [ParentName("广州灵酷跨境科技有限公司", ParentNameEnum.managercost_count)]
        public decimal? managercost_gzlk { get; set; }//new
        /// <summary>
        /// 广州灵酷跨境科技有限公司
        /// </summary>
        [ParentName("广州崇瑜信息技术咨询有限公司", ParentNameEnum.managercost_count)]
        public decimal? managercost_gzcy { get; set; }//new


        /// <summary>
        /// 营业利润
        /// </summary>
        [ParentName("营业利润", ParentNameEnum.profit)]
        public decimal profit { get; set; }
        /// <summary>
        /// 营业毛利率
        /// </summary>
        [ParentName("营业毛利率", ParentNameEnum.profit)]
        public decimal rate_profit { get; set; }
        /// <summary>
        /// 加：其他收入
        /// </summary>
        [ParentName("加：其他收入", ParentNameEnum.profit)]
        public decimal incoming_other { get; set; }

        /// <summary>
        /// 加：出口退税收入
        /// </summary>
        [ParentName("其中：出口退税收入", ParentNameEnum.profit)]
        public decimal incoming_refundtax { get; set; }

        /// <summary>
        /// 加：歌戈尔收入
        /// </summary>
        [ParentName("其中：歌戈儿收入", ParentNameEnum.profit)]
        public decimal incoming_gogirl { get; set; }
        /// <summary>
        /// 加：歌戈尔收入
        /// </summary>
        [ParentName("其中：其他收入", ParentNameEnum.profit)]
        public decimal among_other_income { get; set; }

        /// <summary>
        /// 加：营业外收入
        /// </summary>
        [ParentName("加：营业外收入", ParentNameEnum.profit)]
        public decimal incoming_non_operating { get; set; }
        /// <summary>
        /// 减：营业外支出
        /// </summary>
        [ParentName("减：营业外支出", ParentNameEnum.profit)]
        public decimal pay_non_operating { get; set; }
        ///// <summary>
        ///// 减：资产减值损失
        ///// </summary>
        //[ParentName("减：资产减值损失", ParentNameEnum.profit)]
        //public decimal? impairment_assets { get; set; }
        /// <summary>
        /// 实际利润
        /// </summary>
        [ParentName("实际利润", ParentNameEnum.actual_profit)]
        public decimal actual_profit { get; set; }
        /// <summary>
        /// 净利润率
        /// </summary>
        [ParentName("净利率", ParentNameEnum.rate_profit_actual)]
        public decimal rate_profit_actual { get; set; }
        ///// <summary>
        ///// 减：分红
        ///// </summary>
        //public decimal dividend { get; set; }
        ///// <summary>
        ///// 利润结余
        ///// </summary>
        //public decimal profit_balance { get; set; }
        /// <summary>
        /// 是否编辑的版本，1：是，0：否, 2 汇总
        /// </summary>
        public int isedit { get; set; }
    }
}
