﻿using System.ComponentModel;

namespace Bailun.DC.Models.Component.Enum
{
    /// <summary>
    /// 数据库：1: 数据中心， 2: 交易流水， 3: 产品库， 4: 财务资金， 5: 费用系统， 6: Skums库
    /// </summary>
    public enum DBEnum
    {
        /// <summary>
        /// 数据中心
        /// </summary>
        [Description("数据中心")]
        DataCenter = 1,

        /// <summary>
        /// 交易流水
        /// </summary>
        [Description("交易流水")]
        DataWareHouse = 2,

        /// <summary>
        /// 产品库
        /// </summary>
        [Description("产品库")]
        Pro = 3,

        /// <summary>
        /// 财务资金
        /// </summary>
        [Description("财务资金")]
        Fund = 4,

        /// <summary>
        /// 费用系统
        /// </summary>
        [Description("费用系统")]
        Fee = 5,

        /// <summary>
        /// Skums库
        /// </summary>
        [Description("Skums库")]
        Skums = 6,
    }
}
