﻿using Bailun.DC.Models.Component.Enum;
using Dapper;
using System;

namespace Bailun.DC.Models.Component.Entity
{
    /// <summary>
    /// 报表组件
    /// </summary>
    public class dc_component_table
    {
        /// <summary>
        /// ID
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 编码
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        ///  菜单代码
        /// </summary>
        public string menu_code { get; set; }

        /// <summary>
        /// 面包屑
        /// </summary>
        public string crumbs { get; set; }

        /// <summary>
        /// 引用脚本
        /// </summary>
        public string javascript_src { get; set; }

        /// <summary>
        /// Scripts脚本
        /// </summary>
        public string javascript { get; set; }

        /// <summary>
        /// 过虑控件
        /// </summary>
        public string filter_controls { get; set; }

        /// <summary>
        /// 是否显示查询按钮:(默认是)
        /// </summary>
        public bool is_show_search_button { get; set; }

        /// <summary>
        /// 是否显示重置按钮:(默认是)
        /// </summary>
        public bool is_show_reset_button { get; set; }

        /// <summary>
        /// 是否显示导出按钮:(默认否)
        /// </summary>
        public bool is_show_export_button { get; set; }

        /// <summary>
        /// 是否显示离线导出按钮:(默认否)
        /// </summary>
        public bool is_show_offline_export_button { get; set; }

        /// <summary>
        /// 是否显示导入按钮:(默认否)
        /// </summary>
        public bool is_show_import_button { get; set; }

        /// <summary>
        /// 导入接口
        /// </summary>
        public string import_api { get; set; }

        /// <summary>
        /// 操作控件
        /// </summary>
        public string operate_controls { get; set; }

        /// <summary>
        /// 操作控件位置：NULL/1：换行，2：同行
        /// </summary>
        public int? operate_controls_position { get; set; }

        /// <summary>
        /// 是否显示顺序列:(默认否)
        /// </summary>
        public bool is_show_sequence_column { get; set; }

        /// <summary>
        /// 选择行方式：1: 单选， 2: 多选
        /// </summary>
        public int? select_row_method { get; set; }

        /// <summary>
        /// 列类型: 1: 控制器函数， 2: WebApi， 3:数据源编码， 4:SQL， 5:本地配置
        /// </summary>
        public ColumnTypeEnum? column_type { get; set; }

        /// <summary>
        /// 列值
        /// </summary>
        public string column_value { get; set; }

        /// <summary>
        /// 是否显示列查询:(默认否)
        /// </summary>
        public bool is_show_column_search { get; set; }

        /// <summary>
        /// 操作列名
        /// </summary>
        public string operate_column_name { get; set; }

        /// <summary>
        /// 操作列值
        /// </summary>
        public string operate_column_value { get; set; }

        /// <summary>
        /// 操作列宽度
        /// </summary>
        public int? operate_column_width { get; set; }

        /// <summary>
        /// 数据类型：1: 控制器函数， 2: WebApi， 3:数据库表或视图， 4:SQL
        /// </summary>
        public DataTypeEnum? data_type { get; set; }

        /// <summary>
        /// 列值
        /// </summary>
        public string data_value { get; set; }

        /// <summary>
        /// 数据默认排序SQL
        /// </summary>
        public string data_sort_sql { get; set; }

        /// <summary>
        /// 数据库：1: 数据中心， 2: 交易流水
        /// </summary>
        public DBEnum? data_db { get; set; }

        /// <summary>
        /// 是否自动查询:(默认是)
        /// </summary>
        public bool? is_auto_search { get; set; }

        /// <summary>
        /// 是否删除
        /// </summary>
        [IgnoreUpdate]
        public bool is_delete { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        [IgnoreUpdate]
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }
    }
}
