﻿using Bailun.DC.Models;
using Bailun.DC.Models.Common;
using Bailun.DC.WebApi.Attribute;
using Bailun.ServiceFabric.Authorize;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;

namespace Bailun.DC.WebApi.Controllers
{
    /// <summary>
    /// 财务报表
    /// </summary>
    [Route("api/Finance")]
    [ApiController]
    public class FinanceController : ControllerBase
    {
        /// <summary>
        /// 测试
        /// </summary>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        [BrowseLog("Bailun_data", "访问【百伦数据中心】->【财务报表】->【资产负债表】->【查询】页面", 0)]
        public CommonApiResponseDto<List<dc_base_finance_fee>> Test()
        {
            var list = new Services.FinanceReportServices().ListFinanceFee(DateTime.Now.AddDays(-5), DateTime.Now, "", "", "",null,null);

            return new CommonApiResponseDto<List<dc_base_finance_fee>> { Data = list, IsSuccess = true };
        }
    }
}
