﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class BalanceSheetSubController : Base.BaseController
    {
        /// <summary>
        /// 提现在途
        /// </summary>
        /// <param name="start">开始时间</param>
        /// <param name="end">结束时间</param>
        /// <returns></returns>
        public ActionResult WithdrawalInWay(DateTime start, DateTime end)
        {
            ViewBag.start = start.ToString("yyyy-MM-dd");
            ViewBag.end = end.ToString("yyyy-MM-dd");

            return View();
        }

        public string WithdrawalInWayJson(BtTableParameter request, DateTime start, DateTime end)
        {
            var total = 0;
            var _services = new Services.FinanceReportServices();
            var obj = _services.BSS_WithdrawOnWay(request,start,end,ref total);

            var list = obj.Select(a => new {
                sale_platform = a.sale_platform,
                platform = a.platform,
                pay_account = a.pay_account,
                bank_name = a.bank_name,
                bank_card_user = a.bank_card_user,
                amount_rmb = a.amount_rmb.ToString("N2"),
                statistical_time = start.ToString("yyyy-MM-dd HH:mm:ss"),
                amount_rmb2 = a.amount_rmb2.ToString("N2"),
                statistical_time2 = end.ToString("yyyy-MM-dd")
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list });

        }
    }
}