﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using System.Linq;
using Bailun.DC.Models;

namespace Bailun.DC.Services.DataWareHouse
{
    public class PlatformOrderServices
    {
        /// <summary>
        /// 获取平台站点信息
        /// </summary>
        /// <param name="platform"></param>
        /// <returns></returns>
        public List<string> ListPlatformSite(string platform)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = $"select t1.website from flowing_sales t1 where t1.platform='{platform}' group by t1.website";

                return cn.Query<string>(sql).ToList();
            }
        }

        /// <summary>
        /// 获取平台销售账单流水
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <param name="account">销售帐号</param>
        /// <param name="month">月份</param>
        /// <param name="total">符合条件的记录数</param>
        /// <returns></returns>
        public List<Models.DataWareHouse.flowing_sales> List(int page, string platform, string website, string account, string month,ref int total,int pagesize)
        {
            var sql = "select * from flowing_sales t1 where 1=1";
            var sqlparam = new DynamicParameters();

            if(!string.IsNullOrEmpty(platform))
            {
                sql += " and t1.platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and t1.website=@website";
                sqlparam.Add("website", website);
            }

            if (!string.IsNullOrEmpty(account))
            {
                sql += " and t1.accountname=@account";
                sqlparam.Add("account", account);
            }

            if(!string.IsNullOrEmpty(month))
            {
                sql += " and t1.month=@month";
                sqlparam.Add("month", month);
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                if (pagesize > 0)
                {
                    var obj = cn.Page<Models.DataWareHouse.flowing_sales>(page, pagesize, sql, ref total, sqlparam);

                    return obj.ToList();
                }
                else
                {
                    var obj = cn.Query<Models.DataWareHouse.flowing_sales>(sql, sqlparam);
                    return obj.ToList();
                }
            }

        }

    }
}
