﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 每日SKU+仓库维度的卖出数和下采购单数，可按周和月显示
    /// </summary>
    public class mDailyPurchaseSales
    {
        /// <summary>
        /// 统计日期
        /// </summary>
        public string day { get; set; }

        /// <summary>
        /// 开始日期
        /// </summary>
        public DateTime dayStart { get; set; }

        /// <summary>
        /// 结束日期
        /// </summary>
        public DateTime dayEnd { get; set; }

        /// <summary>
        /// 百伦简单分类
        /// </summary>
        public string category_simple_name { get; set; }

        /// <summary>
        /// 销售数量
        /// </summary>		
        public int count_sales { get; set; }

        /// <summary>
        /// 销售金额
        /// </summary>		
        public decimal amount_sales { get; set; }

        /// <summary>
        /// 采购数量
        /// </summary>		
        public int count_purchase { get; set; }

        /// <summary>
        /// 采购金额
        /// </summary>		
        public decimal amount_purchase { get; set; }

        /// <summary>
        /// 入库数
        /// </summary>
        public int count_putin { get; set; }

        /// <summary>
        /// 入库金额
        /// </summary>
        public decimal amount_putin { get; set; }

        /// <summary>
        /// 发货数量
        /// </summary>
        public int count_shipping { get; set; }

        /// <summary>
        /// 发货金额
        /// </summary>
        public decimal amount_shipping { get; set; }

        /// <summary>
        /// 采购下单的差异数
        /// </summary>		
        public int difference_count { get; set; }

        /// <summary>
        /// 采购下单的差异金额
        /// </summary>		
        public decimal difference_amount { get; set; }

        /// <summary>
        /// 入库的差异数
        /// </summary>
        public int diff_putin_count { get; set; }

        /// <summary>
        /// 入库的差异金额
        /// </summary>
        public decimal diff_putin_amount { get; set; }
        
    }
}
