﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Api
{
    public class mPlatformSkuSales
    {
        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }


        public string origin_order_id { get; set; }

        /// <summary>
        /// 销售帐号
        /// </summary>
        public string seller_account { get; set; }

        /// <summary>
        /// 销售帐号id
        /// </summary>
        public int accountid { get; set; }

        /// <summary>
        /// 平台sku列表
        /// </summary>
        public List<PlatformSku> platform_skus { get; set; }

    }

    public class PlatformSku { 

        /// <summary>
        /// 平台sku编码
        /// </summary>
        public string platformsku { get; set; }

        /// <summary>
        /// 售价 原币
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 售价 原币
        /// </summary>
        public decimal price_rmb { get; set; }

        /// <summary>
        /// 产品成本 rmb
        /// </summary>
        public decimal cost_product { get; set; }

        /// <summary>
        /// 平台佣金 原币
        /// </summary>
        public decimal cost_platform { get; set; }

        /// <summary>
        /// 运费（头程+尾程） rmb
        /// </summary>
        public decimal cost_logistic { get; set; }


        public decimal amount_product_rmb { get; set; }

        public decimal cost_total_rmb { get; set; }

        public decimal cost_platform_rmb { get; set; }

        /// <summary>
        /// 利润 rmb
        /// </summary>
        public decimal profit { get; set; }

        /// <summary>
        /// 利润率
        /// </summary>
        public decimal profit_rate { get; set; }

        public string itemid { get; set; }

        /// <summary>
        /// 对应的百伦sku
        /// </summary>
        public List<BLSkuInfo> listSku { get; set; }
    }

    public class BLSkuInfo
    { 
        /// <summary>
        /// 组合sku
        /// </summary>
        public string groupsku { get; set; }

        /// <summary>
        /// 百伦sku
        /// </summary>
        public string sku { get; set; }


        /// <summary>
        /// 平摊后的产品金额 原币
        /// </summary>
        public decimal amount_product { get; set; }

        public decimal amount_product_rmb { get; set; }

        public decimal cost_total_rmb { get; set; }

        public decimal cost_platform_rmb { get; set; }

        /// <summary>
        /// 平摊后的平台费 原币
        /// </summary>
        public decimal cost_platform { get; set; }


        /// <summary>
        /// 产品成本 rmb
        /// </summary>
        public decimal cost_product { get; set; }

        /// <summary>
        /// 运费（头程+尾程）rmb
        /// </summary>
        public decimal cost_logistic { get; set; }

        /// <summary>
        /// 平摊后的利润 rmb
        /// </summary>
        public decimal profit { get; set; }

        /// <summary>
        /// 平摊后的利润率
        /// </summary>
        public decimal profit_rate { get; set; }
    }
}
