﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Logistics.Controllers
{
    [Area("Logistics")]
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }

        public ActionResult EbayUkReport()
        {
            return View();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="start"></param>
        /// <returns></returns>
        public string EbayUkReportJson_backup(Models.BtTableParameter request,DateTime start,DateTime end,int? zstart,int? zend,int? hstart,int? hend)
        {
            var service = new Services.OrdersServices();

            var obj = service.ListEbayUKLogistics(start, end);
            var listconfig = service.ListEbayReportUKConfig();

            var groupby = obj.GroupBy(a => a.seller_account).ToList();

            var list = new List<Models.Ebay.mEBayUKReport>();

            foreach (var item in groupby)
            {
                var m = new Models.Ebay.mEBayUKReport();
                m.seller_account = item.Key;
                m.ordercount = item.Count();
                m.zsurfacemailcount = item.Where(a => listconfig.Where(b => b.type == 2).Select(c => c.config_value).Contains(a.logistics_order_id)).Count();
                m.zpackagecount = item.Where(a => listconfig.Where(b => b.type == 3).Select(c => c.config_value).Contains(a.logistics_order_id)).Count();
                m.zcount = m.zsurfacemailcount + m.zpackagecount;
                m.percenz = decimal.Parse((((decimal)m.zcount / (decimal)m.ordercount)*100).ToString("#0.00"));

                m.hsurfacemailcount = item.Where(a => listconfig.Where(b => b.type == 4).Select(c => c.config_value).Contains(a.logistics_order_id)).Count();
                m.hpackagecount = item.Where(a => listconfig.Where(b => b.type == 5).Select(c => c.config_value).Contains(a.logistics_order_id)).Count();
                m.hcount = m.hsurfacemailcount + m.hpackagecount;
                m.percenh = decimal.Parse((((decimal)m.hcount / (decimal)m.ordercount)*100).ToString("#0.00"));

                var need = ((m.ordercount * 0.5 - m.hcount) > 0 ? (m.ordercount * 0.5 - m.hcount) : 0);
                m.needaddh = (int)(need*1.5);
                m.needcount = 0;

                list.Add(m);
            }

            var countM = new Models.Ebay.mEBayUKReport() {
                seller_account = "总计",
                ordercount = obj.Count,
                zsurfacemailcount = obj.Where(a=> listconfig.Where(b => b.type == 2).Select(c => c.config_value).Contains(a.logistics_order_id)).Count(),
                zpackagecount = obj.Where(a => listconfig.Where(b => b.type == 3).Select(c => c.config_value).Contains(a.logistics_order_id)).Count(),
                zcount = 0,
                percenz = 0,


                hsurfacemailcount = obj.Where(a => listconfig.Where(b => b.type == 4).Select(c => c.config_value).Contains(a.logistics_order_id)).Count(),
                hpackagecount = obj.Where(a => listconfig.Where(b => b.type == 5).Select(c => c.config_value).Contains(a.logistics_order_id)).Count(),
                hcount = 0,
                percenh = 0,

                needcount = 0,
            };

            countM.zcount = countM.zsurfacemailcount + countM.zpackagecount;
            countM.percenz = decimal.Parse((((decimal)countM.zcount / (decimal)countM.ordercount) * 100).ToString("N2"));
            countM.hcount = countM.hsurfacemailcount + countM.hpackagecount;
            countM.percenh = decimal.Parse((((decimal)countM.hcount / (decimal)countM.ordercount) * 100).ToString("N2"));
            
            var need1 = ((countM.ordercount * 0.5 - countM.hcount) > 0 ? (countM.ordercount * 0.5 - countM.hcount) : 0);
            countM.needaddh = (int)(need1 * 1.5);
            countM.needcount = 0;


            if (zstart.HasValue && zstart.Value > 0)
            {
                list = list.Where(a => a.percenz >= zstart.Value).ToList();
            }
            if (zend.HasValue && zend.Value > 0)
            {
                list = list.Where(a => a.percenz < zend.Value).ToList();
            }
            if (hstart.HasValue && hstart.Value > 0)
            {
                list = list.Where(a => a.percenh >= hstart.Value).ToList();
            }
            if (hend.HasValue && hend.Value > 0)
            {
                list = list.Where(a => a.percenh < hend.Value).ToList();
            }

            //return Json(list);

            //排序
            if (request.order != null && request.order.ToLower() == "desc")
            {
                switch (request.sort)
                {
                    case "ordercount":
                        list = list.OrderByDescending(a => a.ordercount).ToList();
                        break;
                    case "needaddh":
                        list = list.OrderByDescending(a => a.needaddh).ToList();
                        break;
                }
            }
            else
            {
                switch (request.sort)
                {
                    case "ordercount":
                        list = list.OrderBy(a => a.ordercount).ToList();
                        break;
                    case "needaddh":
                        list = list.OrderBy(a => a.needaddh).ToList();
                        break;
                }
            }
            

            return JsonConvert.SerializeObject(new { total = 25, rows = list,count_row=countM });

        }

        /// <summary>
        /// 获取Ebay UK站点 leter的发货占比
        /// Add by Allan at 20200711
        /// </summary>
        /// <param name="start"></param>
        /// <returns></returns>
        public string EbayUkReportJson(Models.BtTableParameter request, DateTime start, DateTime end, int? l_start, int? l_end, int? bg_start, int? bg_end)
        {
            var service = new Services.OrdersServices();

            var obj = service.ListEbayUKLogistics_Letter(start, end);
            var listconfig = service.ListEbayReportUKConfig();

            var groupby = obj.GroupBy(a => a.seller_account).ToList();

            var list = new List<Models.Ebay.mEBayUKReport>();

            foreach (var item in groupby)
            {
                var m = new Models.Ebay.mEBayUKReport();
                m.seller_account = item.Key;
                m.ordercount = item.Count();
                
                m.hsurfacemailcount = item.Where(a => listconfig.Where(b => b.type == 4).Select(c => c.config_value).Contains(a.logistics_order_id)).Count();
                m.hpackagecount = item.Where(a => listconfig.Where(b => b.type == 7).Select(c => c.config_value).Contains(a.logistics_order_id)).Count();
                
                //m.hcount = m.hsurfacemailcount + m.hpackagecount;
                //m.percenh = decimal.Parse((((decimal)m.hcount / (decimal)m.ordercount) * 100).ToString("#0.00"));

                m.lettercount = item.Where(a => listconfig.Where(b => b.type == 6).Select(c => c.config_value).Contains(a.logistics_order_id)).Count();  //letter
                
                m.percenl = m.hpackagecount / m.lettercount;

                //需新增包裹数=1.2*信封transactionid数-包裹transactionid订单数
                var need = ((m.lettercount * 1.2 - m.hpackagecount) > 0 ? (m.lettercount * 1.2 - m.hpackagecount) : 0);
                //m.needaddh = (int)(need * 1.5);
                //m.needcount = 0;

                m.needcount_bg = Math.Ceiling(need);

                //letter占比
                m.percenz = decimal.Parse((m.lettercount*100 / m.ordercount).ToString("#0.00"));
                //包裹占比
                m.percenh = decimal.Parse((m.hpackagecount*100 / m.ordercount).ToString("#0.00"));


                list.Add(m);
            }

            var countM = new Models.Ebay.mEBayUKReport()
            {
                seller_account = "总计",
                ordercount = obj.Count,

                hsurfacemailcount = obj.Where(a => listconfig.Where(b => b.type == 4).Select(c => c.config_value).Contains(a.logistics_order_id)).Count(),
                hpackagecount = obj.Where(a => listconfig.Where(b => b.type == 7).Select(c => c.config_value).Contains(a.logistics_order_id)).Count(),
                lettercount = obj.Where(a => listconfig.Where(b => b.type == 6).Select(c => c.config_value).Contains(a.logistics_order_id)).Count(),
                
            };

            countM.percenl = countM.hpackagecount / countM.lettercount;


            var need1 = ((countM.lettercount * 1.2 - countM.hpackagecount) > 0 ? (countM.lettercount * 1.2 - countM.hpackagecount) : 0);
            countM.needcount_bg = Math.Ceiling(need1);


            if (l_start.HasValue && l_start.Value > 0)
            {
                list = list.Where(a => a.percenz >= l_start.Value).ToList();
            }
            if (l_end.HasValue && l_end.Value > 0)
            {
                list = list.Where(a => a.percenz < l_end.Value).ToList();
            }
            if (bg_start.HasValue && bg_start.Value > 0)
            {
                list = list.Where(a => a.percenh >= bg_start.Value).ToList();
            }
            if (bg_end.HasValue && bg_end.Value > 0)
            {
                list = list.Where(a => a.percenh < bg_end.Value).ToList();
            }
            
            //排序
            if (request.order != null && request.order.ToLower() == "desc")
            {
                switch (request.sort)
                {
                    case "ordercount":
                        list = list.OrderByDescending(a => a.ordercount).ToList();
                        break;
                    case "needcount_bg":
                        list = list.OrderByDescending(a => a.needcount_bg).ToList();
                        break;
                }
            }
            else
            {
                switch (request.sort)
                {
                    case "ordercount":
                        list = list.OrderBy(a => a.ordercount).ToList();
                        break;
                    case "needcount_bg":
                        list = list.OrderBy(a => a.needcount_bg).ToList();
                        break;
                }
            }


            return JsonConvert.SerializeObject(new { total = 25, rows = list, count_row = countM });

        }
    }
}