﻿using Bailun.DC.Models.WebApiModels;
using System.Collections.Generic;

namespace Bailun.DC.WebApi.Models
{
    /// <summary>
    /// 月销售利润
    /// </summary>
    public class MonthSalesProfitResponse
    {
        public MonthSalesProfitResponse()
        {
            Col = new List<MonthSalesProfitColumnsModel>();
        }

        /// <summary>
        /// json字符串
        /// </summary>
        public string DataJson { get; set; }

        /// <summary>
        /// 表头
        /// </summary>
        public List<MonthSalesProfitColumnsModel> Col { get; set; }
    }

    /// <summary>
    /// 表头
    /// </summary>
    public class MonthSalesProfitColumnsModel
    {
        /// <summary>
        /// 显示名称
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// Key
        /// </summary>
        public string Key { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public int Width { get; set; } = 200;

        /// <summary>
        /// 
        /// </summary>
        public List<MonthSalesProfitColumnsChildren> Children { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    public class MonthSalesProfitColumnsChildren
    {
        /// <summary>
        /// 显示名称
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// Key
        /// </summary>
        public string Key { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public int Width { get; set; } = 150;
    }

    /// <summary>
    /// 
    /// </summary>
    public class KeyDisplayNameModel
    {
        /// <summary>
        /// 
        /// </summary>
        public string DisplayName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string KeyName { get; set; }

        /// <summary>
        /// 上级名称
        /// </summary>
        public ParentNameEnum? ParentName { get; set; }
    }
}
