﻿using Bailun.DC.Models.Common;
using Bailun.DC.Models.Dtos.BasicData;
using Bailun.DC.Services.WebApiService;
using Bailun.ServiceFabric.Authorize;
using Microsoft.AspNetCore.Mvc;
using System.Collections.Generic;

namespace Bailun.DC.WebApi.Controllers
{
    /// <summary>
    /// 基础数据
    /// </summary>
    [Route("api/basicData")]
    [ApiController]
    public class BasicDataController : ControllerBase
    {
        /// <summary>
        /// 获取付现所有公司信息
        /// </summary>
        /// <returns></returns>
        [HttpGet("getCompanyAllList"), BailunAuthentication(LoginMode.Enforce)]
        public CommonApiResponseDto<List<CompanyListOutPutDto>> GetCompanyAllList()
        {
            return new BasicDataService().GetCompanyAllList();
        }

        /// <summary>
        /// 获取费用类型
        /// </summary>
        /// <returns></returns>
        [HttpGet("getCostTypeAllList"), BailunAuthentication(LoginMode.Enforce)]
        public CommonApiResponseDto<List<CostTypeListOutPutDto>> GetCostTypeAllList()
        {
            return new BasicDataService().GetCostTypeAllList();
        }
    }
}
