﻿Vue.component('el-table-query', {
    props: {
        //编码
        code: {
            type: String
        },
        //列
        listColumn: {
            type: Array
        }
    },
    data: function () {
        return {
            //是否加载中
            loading: false,
            //是否第一次加载
            isFirst: false,
            //设置
            setting: {},
            //过虑条件参数
            filterParams: {
                //当前页
                currentPage: 1,
                //每页显示数
                pageSize: 10,
                //过虑条件
                listFilter: [],
            }
        }
    },
    methods: {
        //关闭弹出窗
        closeDialog() {
            this.$emit("close-dialog")
        },
        //清空选择
        clearSelection: function () {
            this.$refs.table.clearSelection();
        },
        //弹出窗
        showDialog(title, form, code) {
            this.$emit("show-dialog", title, form, code)
        },
        //获取过虑条件
        getFilter: function (filter) {
            var that = this;
            var listFilter = [];
            //筛选区域过虑条件
            if (!filter) {
                listFilter = that.$refs.formFilter.getFilter(true);
            } else {
                listFilter = filter.length > 0 ? filter : [];
            }
            //列值过虑条件 
            if (that.setting.isShowColumnSearch && that.setting.listColumn && that.setting.listColumn.length) {
                var listColumnFilter = that.setting.listColumn.filter(function (l) {
                    return !!l.value
                });
                if (listColumnFilter && listColumnFilter.length) {
                    listColumnFilter = listColumnFilter.forEach(function (l) {
                        if ((l.type && l.type.toLowerCase()) == 'select') {
                            listFilter.push({ field: l.prop, operator: "=", value: l.value });
                        } else {
                            listFilter.push({ field: l.prop, operator: "like", value: l.value });
                        }
                    });
                }
            }
            Vue.set(that.filterParams, 'listFilter', listFilter);
            return listFilter;
        },
        //获取选择行
        getSelectItems: function () {
            return this.$refs.table.getSelectItems();
        },
        //表单组件初始化事件
        onInit: function (setting) {
            var that = this;
            Vue.set(that, 'setting', setting);
            //初始化时设置过虑条件 
            Vue.set(that.filterParams, 'code', setting.code);
            if (setting.listFilterControl) {
                that.$refs.formFilter.filter.listFilterControl = setting.listFilterControl
                Vue.set(that.filterParams, 'listFilter', that.$refs.formFilter.getFilter(true));
            }
            //面包屑
            if (that.setting.listCrumb && that.setting.listCrumb.length && document.getElementsByClassName("breadcrumb").length == 1) {
                $(".breadcrumb li").remove();
                $(".breadcrumb").prepend("<li><a href='#'>首页</a></li>" + that.setting.listCrumb.map(function (i) { return "<li><a href='#'>" + i + "</a></li>" }).join(""));
            }
        },
        //查询
        onSearch: function (filterParams, firstPage, cb) {
            var that = this;
            //设置当前第一页
            if (that.$refs.formFilter.validate()) {
                if (firstPage == null || firstPage == true) {
                    Vue.set(that.filterParams, 'currentPage', 1);
                }
                Vue.set(that.filterParams, 'code', that.code);
                if (!filterParams || filterParams.constructor === Array) {
                    //获取过虑条件
                    this.getFilter(filterParams);
                    //查询
                    that.$refs.table.onSearch(null, cb);
                } else {
                    //查询
                    that.$refs.table.onSearch(filterParams, cb);
                }
            } else {
                var message = that.$refs.formFilter.getValidateMessage();
                if (message && message.length) {
                    that.$message({ dangerouslyUseHTMLString: true, message: message.join("<br/>") });
                }
            }
        },
        //重置
        onReset: function (listFilter) {
            var that = this;
            //设置首次标识
            that.isFirst = true;
            if (that.setting) {
                //清空表格过虑值
                if (that.setting.listColumn && that.setting.listColumn.length) {
                    that.setting.listColumn.forEach(function (l) {
                        Vue.set(l, 'value', null);
                    });
                }
            }
            //清空排序
            that.$refs.table.clearSort();
            //清空列值
            that.$refs.table.clearColumnValue;
            Vue.set(that.filterParams, 'pageSize', 10);
            Vue.set(that.filterParams, 'ListOrder', null);
            //初始化过虑条件
            Vue.set(that.filterParams, 'listFilter', listFilter && listFilter.length > 0 ? listFilter : null);
            //重新查询
            that.onSearch();
        },
        //导出
        onExport: function (filterParams, cb) {
            var that = this;
            //异步请求
            if (that.$refs.formFilter.validate()) {
                that.$http.post("/Component/Table/Export", ((filterParams.constructor === Object ? filterParams : null) || that.filterParams), { emulateJSON: true }, {
                    responseType: 'arraybuffer',
                    headers: {
                        'Accept': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8'
                    }
                }).then(function (respons) {
                    if (respons.bodyBlob.type == "application/json") {
                        that.$message(respons.body.message || " 未知错误!");
                    } else {
                        if (respons.headers && respons.headers.map && respons.headers.map["content-disposition"] && respons.headers.map["content-disposition"].length > 0) {
                            var exportName = null;
                            var fileInfo = respons.headers.map["content-disposition"][0].split(';');
                            if (fileInfo.length > 2) {
                                exportName = decodeURI(fileInfo[2].replace(" filename*=UTF-8''", ""));
                            } else if (fileInfo.length > 1) {
                                exportName = fileInfo[1].replace(" filename=", "");
                            } else {
                                exportName = (that.setting.listCrumb && that.setting.listCrumb.length > 0 ? that.setting.listCrumb.join("") : ('Export')) + "_" + (new Date().format("yyyyMMddhhmm")) + "xls";
                            }
                            saveAs(respons.bodyBlob, exportName);
                        }
                    }
                    if (cb) {
                        cb.call(this, respons);
                    }
                }).catch(function (error) {
                    that.$message(error.message || " 未知错误!");
                    if (cb) {
                        cb.call(this, error);
                    }
                });
            } else {
                var message = that.$refs.formFilter.getValidateMessage();
                if (message && message.length) {
                    that.$message({ dangerouslyUseHTMLString: true, message: message.join("<br/>") });
                }
            }
        },
        //单击事件
        onClick: function (fn) {
            var that = this;
            switch (that.setting.selectRowMethod) {
                case 1:
                    row = that.row;
                    break;
                case 2:
                    rows = that.getSelectItems();
                    break;
            }
            if (fn) {
                eval(fn);
            }
        },
        //每页显示数改变事件
        onSizeChange: function (val) {
            //点击显示多少条
            var that = this;
            Vue.set(that.filterParams, "pageSize", val);
            //查询
            that.$refs.table.onSearchData();
        },
        //当前页改变事件
        onCurrentChange: function (val) {
            //点击页数
            var that = this;
            Vue.set(that.filterParams, "currentPage", val);
            //查询
            that.$refs.table.onSearchData();
        }
    },
    mounted: function () {
    },
    created: function () {

    },
    template: '#elTableQuery'
});