﻿Vue.component('el-form-filter', {
    props: {
        filter: {
            type: Object
        }
    },
    data: function () {
        return {
            formValidate: null
        }
    },
    methods: {
        //初始化数据
        onInitValue: function () {
        },
        //获取查询过虑条件
        getFilter: function (defaultValue) {
            var that = this;
            var listFilter = [];
            //当前筛选区域过虑条件
            if (that.filter && that.filter.listFilterControl) {
                that.filter.listFilterControl.forEach(function (l) {
                    //是否默认值
                    if (defaultValue) {
                        //日期
                        if (l.defaultValue && l.type == "daterange" || l.type == "date" || l.type == "month") {
                            var date = new Date();
                            switch (l.defaultValue) {
                                case "new Date()":
                                    date = l.type == "daterange" ? [new Date(), new Date()] : date;
                                    break;
                                case "prev Date()":
                                case "prev date()":
                                    date = new Date(date.setDate(date.getDate() - 1));
                                    break;
                                case "curr day()":
                                    date = [new Date(date.setDate(date.getDate() - date.getDay() + 1)), new Date(date.setDate(date.getDate() - date.getDay() + 7))];
                                    break;
                                case "curr month()":
                                    date = l.type == "daterange" ? [new Date(date.setDate(1)), new Date(date.setMonth(date.getMonth() + 1) - (24 * 60 * 60 * 1000))] : new Date(date.setDate(1));
                                    break;
                                case "prev day()":
                                    date = [new Date(date.setDate(date.getDate() - date.getDay() + 1 - 7)), new Date(date.setDate(date.getDate() - date.getDay() + 7))];
                                    break;
                                case "prev month()":
                                    date = l.type == "daterange" ? [new Date(new Date(date.setMonth(date.getMonth() - 1)).setDate(1)), new Date(new Date(date.setMonth(date.getMonth() + 1)).setDate(1) - (24 * 60 * 60 * 1000))] : new Date(date.setMonth(date.getMonth() - 1));
                                    break;
                            }
                            Vue.set(l, "value", date);
                        } else {
                            Vue.set(l, "value", l.defaultValue);
                        }
                    }
                    if (l.value) {
                        var filter = { field: l.prop };
                        //日期区间
                        if (l.type == "daterange" && l.value.constructor == Array && l.value.length > 1) {
                            filter.operator = "between";
                            if (l.value[0].constructor == Date && l.value[1].constructor == Date) {
                                filter.value = [l.value[0].format("yyyy-MM-dd"), l.value[1].format("yyyy-MM-dd")].join(",");
                            } else {
                                filter.value = l.value.join(",");
                            }
                        }
                        //月
                        else if (l.type == "month") {
                            filter.operator = "=";
                            filter.value = l.value.format("yyyy-MM");
                        }
                        //日期
                        else if (l.type == "date") {
                            filter.operator = "=";
                            filter.value = l.value.format("yyyy-MM-dd");
                        }
                        //对象
                        else if (l.value.constructor === Object || l.value.constructor === Array) {
                            filter.operator = "in";
                            filter.value = l.value.join(",");
                            //文本
                        } else if (l.type == "input") {
                            filter.operator = "like";
                            filter.value = l.value;
                        }
                        //其他
                        else {
                            filter.operator = "=";
                            filter.value = l.value;
                        }
                        listFilter.push(filter);
                    }
                })
            }
            return listFilter;
        },
        //获取验证错误信息
        getValidateMessage: function () {
            return (this.formValidate || []).filter(function (l) { return !l.valid }).map(function (l) { return l.message });
        },
        //验证
        validate: function () {
            var that = this;
            var isvalid = false;
            that.$refs['form-filter'].validate(function (valid) {
                isvalid = valid
            })
            return isvalid;
        },
        //查询
        onSearch: function () {
            this.$emit("search", this.getFilter());
        },
        //重置
        onReset: function () {
            this.$emit("reset", this.getFilter(true));
        },
        //导出
        onExport: function () {
            this.$emit("export", this.getFilter());
        },
        //导入
        onImport: function (result, file, message) {
            if (result) {
                this.$message("导入成功!")
                this.onSearch();
            } else { 
                this.$message.error(message)
            }
        },
        //单击事件
        onClick: function (fn) {
            this.$emit("click", fn);
        },
        //验证事件
        onValidate: function (field, valid, message) {
            var that = this;
            if (!that.formValidate) {
                that.formValidate = []
            }
            var index = that.formValidate.findIndex(function (l) { return l.field == field });
            if (index >= 0) {
                that.formValidate[index].valid = valid;
                that.formValidate[index].message = message;
            } else {
                this.formValidate.push({ field: field, valid: valid, message: message });
            }
        },
        //改变事件
        onChange: function (item, val) {
            var that = this;
            switch (item.type) {
                case "select":
                    //联动子项
                    var listFilter = that.filter.listFilterControl.filter(function (l) { return l.type == "select" && l.parentProp == item.prop });
                    if (listFilter && listFilter.length) {
                        listFilter.forEach(function (l) {
                            Vue.set(l, "value", null);
                            Vue.set(l, "listOption", null);
                        })
                    }
                    break;
            }
        }
    },
    mounted: function () {
        this.onInitValue();
    },
    created: function () {

    },
    template: '#elFormFilter'
});