﻿Vue.component('el-dialog-form', {
    props: {
        //编码
        code: {
            type: String,
            default: ""
        }
    },
    data() {
        return {
            //显示
            show: false,
            //FORM表单
            form: {},
            //
            dialog: {}
        }
    },
    created() {
    },
    mounted() {

    },
    methods: {
        //自定义JS
        javaScript: function (js, form, $event, item) {
            if (js) {
                return eval(js)
            }
        },
        //显示
        showDialog: function (title, form, code) {
            var that = this
            if (code || that.code) {
                that.$http({
                    method: 'get',
                    url: "/Component/Form/Get",
                    params: { code: code || that.code }
                }).then(function (response) {
                    var result = response.data;
                    if (response.status === 200 && result.result && result.data) {
                        Vue.set(that, "dialog", result.data)
                        that.show = true;
                        if (title) {
                            Vue.set(that.dialog, "name", title);
                        }
                        if (that.dialog.listFormItem && that.dialog.listFormItem.constructor === String) {
                            Vue.set(that.dialog, "listFormItem", JSON.parse(that.dialog.listFormItem));
                        }
                        if (form && that.dialog.listFormItem && that.dialog.listFormItem.length) {
                            that.dialog.listFormItem.forEach(function (item) {
                                if (item.type == "select" && (!item.listOption || item.listOption.length) && form[item.prop] && form[item.propname]) {
                                    var listOption = [];
                                    var listPropValue = Array.isArray(form[item.prop]) ? form[item.prop] : [form[item.prop]]
                                    listPropValue.forEach(function (l, i) {
                                        var option = {};
                                        option[item.value || "value"] = l;
                                        option[item.display || "display"] = Array.isArray(form[item.propname]) ? form[item.propname][i] : form[item.propname];
                                        listOption.push(option);
                                    })
                                    Vue.set(item, "listOption", listOption);
                                }
                            })
                        }
                        that.$set(that, "form", form || {});
                    } else {
                        that.$message((!result.data && "配置错误") || (result.Message || " 未知错误!"));
                    }
                }, function (error) {
                    that.$message(error.statusText || " 未知错误!");
                });
            }
        },
        //隐藏
        closeDialog: function () {
            var that = this;
            if (!that.show) {
                that.$set(that, "form", {})
                that.$emit("cancel")
                var resetFieldsIndex = that.dialog.listFormItem && that.dialog.listFormItem.findIndex(function (l, i) {
                    return (l.type == "input" || l.type == "number" || l.type == "select" || l.type == "daterange" || l.type == "date" || l.type == "month" || l.type == "year" || l.type == "switch");
                });
                if (resetFieldsIndex > 0) {
                    that.$refs.form && that.$refs.form.resetFields && that.$refs.form.resetFields();
                };
            }
            that.show = false
        },
        //提交表单
        submitForm: function () {
            var that = this
            var isvalid = false
            if (that.dialog.validate == null || that.dialog.validate) {
                that.$refs['form'].validate(function (valid) {
                    isvalid = valid
                })
            } else {
                isvalid = true
            }
            if (isvalid && that.dialog.saveScript) {
                that.javaScript.call(that, that.dialog.saveScript, that.form)
            }
        },
        //
        visibleChange: function (visible, item) {
            var that = this
            if (visible && item.api && (!item.listOption || item.listOption.length <= 1 || (that.form && item.prop && that.form[item.prop] && Array.isArray(that.form[item.prop]) && that.form[item.prop].length == item.listOption.length))) {
                //that.$set(item, "loading", true)
                //if (item.apiType == "post") {
                //    request.post(item.api, { limit: 2147483647 }).then(response => {
                //        if (response.code == 200 && response.data) {
                //            that.$set(item, "listOption", response.data.list)
                //        }
                //        that.$set(item, "loading", false)
                //    })
                //} else {
                //    request.get(item.api, { limit: 2147483647 }).then(response => {
                //        if (response.code == 200 && response.data) {
                //            that.$set(item, "listOption", response.data.list)
                //        }
                //        that.$set(item, "loading", false)
                //    })
                //}
            }
        }
    },
    template: '#elDialogForm'
});