﻿using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Models.DataWareHouse.DTO;
using Bailun.DC.Services.DataWareHouse;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;

namespace Bailun.DC.Web.Areas.DataWareHouse.Controllers
{
    [Area("DataWareHouse")]
    public class SyncController : Base.BaseController
    {
        [HttpPost]
        public JsonResult LoadFundAmazonTransaction([FromForm] string month)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new SyncService().LoadFundAmazonTransaction(month);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }


        [HttpPost]
        public JsonResult FundAmazonTransaction([FromForm] string month, [FromForm] IEnumerable<FundAmazonTransactionDTO> list)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new SyncService().FundAmazonTransaction(month, list);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

    }
}
