﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Threading.Tasks;

namespace Bailun.DC.Web.Areas.DataWareHouse.Controllers
{
    [Area("DataWareHouse")]
    public class LogisticsController : Base.BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public LogisticsController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }


        public IActionResult List(string platform)
        {
            var listconfig = new Services.DataWareHouse.PlatformOrderFeeServices().ListOrderFeeConfig(2);

            ViewBag.listconfig = listconfig.Select(a=>a.platform).Distinct().Where(b=>b!= "万邑通" && b!= "易可达" && b!= "艾姆勒IML海外仓" && b!= "递四方" && b!= "顺邮" && b!= "橙联speedPAK" && b!= "英国伯明翰" && b!= "WishPost").ToList();
            ViewBag.platform = platform;
            ViewBag.sites = listconfig.Where(a=>a.platform==platform).Select(b=>b.website).Distinct().Where(c=>!string.IsNullOrEmpty(c)).ToList();

            return View();
        }

        /// <summary>
        /// 获取物流账单json数据
        /// </summary>
        /// <param name="page"></param>
        /// <param name="platform"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="orderno"></param>
        /// <param name="pagesize"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListFlowingJson(int page, string platform,string website,string month, DateTime? start, DateTime? end, string orderno, int pagesize = 25)
        {
            var total = 0;
            if (page <= 0)
            {
                page = 1;
            }

            var obj = new Services.DataWareHouse.LogisticServices().ListFlowingLogistic(page, pagesize, platform,website,month, start, end,orderno, ref total);
;
            var list = obj.Select(a => new {
                a.createtime,
                jsondata = Newtonsoft.Json.Linq.JRaw.Parse(a.jsondata),
                datatime = a.datatime.HasValue ? a.datatime.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
            });

            return Json(new
            {
                success = true,
                msg = "",
                rows = list,
                total = total,
                page = page,
                totalpage = total / pagesize + (total % pagesize > 0 ? 1 : 0),
            });

        }


        /// <summary>
        /// 上传物流流水数据
        /// </summary>
        /// <param name="platform"></param>
        /// <returns></returns>
        [RequestSizeLimit(100_000_000)]
        public JsonResult UploadFlowing(string platform,string website, string month)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择平台"
                });
            }

            if (string.IsNullOrEmpty(month))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择月份后再导入"
                });
            }


            if (Request.Form.Files.Count == 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            //var user = HttpContextHelper.Current?.User;

            var file = Request.Form.Files[0];
            var errmsg = "";
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true, ref errmsg);

            if (!string.IsNullOrEmpty(errmsg))
            {
                return Json(new
                {
                    success = false,
                    msg = "识别表格异常，异常信息："+errmsg,
                });
            }

            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();

                var list = Dtb2Json(tb.Value);
                var listOrders = new List<Models.DataWareHouse.flowing_logistic>();
                foreach (var item in list)
                {
                    //保存数据
                    var m = new Models.DataWareHouse.flowing_logistic
                    {
                        createtime = DateTime.Now,
                        jsondata = Newtonsoft.Json.JsonConvert.SerializeObject(item),
                        month = month,
                        platformtype = platform,
                        website = website??"",
                        createuser = "页面上传",
                        datatype = 1,
                        datatypename = "物流账单",
                        account = "",
                    };
                    listOrders.Add(m);
                }

                var result = new Services.DataWareHouse.LogisticServices().InsertOrderBilling(listOrders);
                return Json(new
                {
                    success = string.IsNullOrEmpty(result),
                    msg = result
                });
            }

            return Json(new
            {
                success = false,
                msg = "无法识别表格的数据，请下载模版重新导入，或者检查下表格数据是否正确。",
            });

        }

        public ActionResult ExportFlowing(string platform,string website, string month, DateTime? start, DateTime? end, string orderno)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择平台类型"
                });
            }

            var total = 0;
            var obj = new Services.DataWareHouse.LogisticServices().ListFlowingLogistic(0, 0, platform, website, month, start, end, orderno, ref total);

            if (obj.Count == 0)
            {
                return Json(new
                {
                    success = true,
                    msg = "没有数据"
                });
            }

            //列头

            DataTable dataTable = new DataTable(); //实例化
            var objFirst = obj.FirstOrDefault();
            var jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(objFirst.jsondata);
            var colnames = new List<string>();

            foreach (var item in jsonData)
            {
                dataTable.Columns.Add(item.Key, typeof(string));
                colnames.Add(item.Key);
            }

            foreach (var item in obj)
            {
                jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(item.jsondata);

                DataRow dataRow = dataTable.NewRow();

                foreach (var c in jsonData)
                {

                    dataRow[c.Key] = c.Value;
                }

                dataTable.Rows.Add(dataRow);
            }


            //for (var i = 0; i < dataTable.Columns.Count; i++)
            //{
            //    colnames.Add(dataTable.Columns[i].ColumnName);
            //}

            var listVal = new List<string>();
            for (int j = 0; j < dataTable.Rows.Count; j++)
            {
                var s = "";
                for (int k = 0; k < dataTable.Columns.Count; k++)
                {
                    string tmpRowValue = dataTable.Rows[j][k].ToString();

                    s += tmpRowValue + "|";
                }

                //s = s.Substring(0, s.Length - 1);
                listVal.Add(s);
            }

            var guid = Guid.NewGuid().ToString();
            var filename = platform + " " + ((start.HasValue ? start.Value.ToString("yyyy-MM-dd") : "" + (end.HasValue ? "至" + end.Value.ToString("yyyy-MM-dd") : ""))) + "的账单流水";
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(listVal, colnames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");
        }


        /// <summary>
        /// 下载销售平台流水上传模版
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public ActionResult DownLoadFlowingTemplate(string platform, string website, DateTime? start, DateTime? end, string month)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Content("请选择完平台再导出");
            }

            var obj = new Services.DataWareHouse.LogisticServices().Get(platform, website, start, end, month);
            if (obj == null)
            {
                return Content("系统没有该平台的模版可导出，你可自定义一个模版，后面的导入都以本次导入的格式作为新模板。");
            }

            DataTable dataTable = new DataTable(); //实例化
            var jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(obj.jsondata);
            var colnames = new List<string>();

            foreach (var item in jsonData)
            {
                dataTable.Columns.Add(item.Key, typeof(string));
                colnames.Add(item.Key);
            }

            jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(obj.jsondata);

            DataRow dataRow = dataTable.NewRow();

            foreach (var c in jsonData)
            {

                dataRow[c.Key] = c.Value;
            }

            dataTable.Rows.Add(dataRow);


            //for (var i = 0; i < dataTable.Columns.Count; i++)
            //{
            //    colnames.Add(dataTable.Columns[i].ColumnName);
            //}

            var listVal = new List<string>();
            for (int j = 0; j < dataTable.Rows.Count; j++)
            {
                var s = "";
                for (int k = 0; k < dataTable.Columns.Count; k++)
                {
                    string tmpRowValue = dataTable.Rows[j][k].ToString();

                    s += tmpRowValue + "|";
                }

                //s = s.Substring(0, s.Length - 1);
                listVal.Add(s);
            }

            var guid = Guid.NewGuid().ToString();
            var filename = platform + " " + ((start.HasValue ? start.Value.ToString("yyyy-MM-dd") : "" + (end.HasValue ? "至" + end.Value.ToString("yyyy-MM-dd") : ""))) + "的上传模版";
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            //ToCSV(listVal, colnames, guid, filepath);

            ToExcel(dataTable, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".xls", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/xls", filename + ".xls");

        }


    }
}
