﻿using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Services.Component;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using System;
using System.Linq;
using System.Collections.Generic;
using System.IO;
using System.Text;
using Microsoft.AspNetCore.Http;

namespace Bailun.DC.Web.Areas.Component.Controllers
{
    [Area("Component")]
    public class TableController : Base.BaseController
    {
        public IActionResult Index()
        {
            return View();
        }

        [HttpGet]

        public JsonResult Get(string id = null, string code = null)
        {
            ResultDTO result = new ResultDTO();
            try
            {
                result.Data = new TableService().Get(code, id);
                result.Result = true;
            }
            catch (Exception ex)
            {
                result.Message = ex.Message;
            }

            return Json(result, new JsonSerializerSettings() { ContractResolver = new IgnoreJsonAttributesResolver(id), DefaultValueHandling = DefaultValueHandling.Include });
        }

        [HttpPost]
        public JsonResult GetListColumn(QueryFilterDTO queryFilter = null)
        {
            ResultDTO result = new ResultDTO();
            try
            {
                if (Request.ContentType.Contains("application/json"))
                {
                    using (Stream stream = Request.Body)
                    {
                        byte[] buffer = new byte[Request.ContentLength.Value];
                        stream.Read(buffer, 0, buffer.Length);
                        string content = Encoding.UTF8.GetString(buffer);
                        queryFilter = JsonConvert.DeserializeObject<QueryFilterDTO>(content);
                    }
                }
                result.Data = new TableService().GetListColumn(queryFilter);
                result.Result = true;
            }
            catch (Exception ex)
            {
                result.Message = ex.Message;
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult GetListData(QueryFilterDTO queryFilter)
        {
            ResultDTO result = new ResultDTO();
            try
            {
                if (Request.ContentType.Contains("application/json"))
                {
                    using (Stream stream = Request.Body)
                    {
                        byte[] buffer = new byte[Request.ContentLength.Value];
                        stream.Read(buffer, 0, buffer.Length);
                        string content = Encoding.UTF8.GetString(buffer);
                        queryFilter = JsonConvert.DeserializeObject<QueryFilterDTO>(content);
                    }
                }
                result.Data = new TableService().GetListData(queryFilter);
                result.Result = true;
            }
            catch (Exception ex)
            {
                result.Message = ex.Message;
            }

            return Json(result);
        }

        [HttpPost]
        public ActionResult Export(QueryFilterDTO queryFilter)
        {
            byte[] data = null;
            try
            {
                if (Request.ContentType.Contains("application/json"))
                {
                    using (Stream stream = Request.Body)
                    {
                        byte[] buffer = new byte[Request.ContentLength.Value];
                        stream.Read(buffer, 0, buffer.Length);
                        string content = Encoding.UTF8.GetString(buffer);
                        queryFilter = JsonConvert.DeserializeObject<QueryFilterDTO>(content);
                    }
                }
                var exportResult = new TableService().Export(queryFilter);
                if (exportResult.Item2 != null)
                {
                    data = exportResult.Item2;
                    return File(data, "text/plain", exportResult.Item1);
                }
                else
                {
                    ResultDTO result = new ResultDTO() { Message = "无数据导出" };
                    return Json(result);
                }
            }
            catch (Exception ex)
            {
                ResultDTO result = new ResultDTO() { Message = ex.Message };
                return Json(result);
            }
            finally
            {
                data = null;
                GC.Collect();
            }
        }

        [HttpPost]
        public JsonResult Save([FromBody] TableDTO dto)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new TableService().Save(dto);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult Enable(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new TableService().Save(id, true);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);

        }

        [HttpPost]
        public JsonResult Disable(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new TableService().Save(id, false);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

        private class IgnoreJsonAttributesResolver : DefaultContractResolver
        {
            private string Id { get; set; }

            public IgnoreJsonAttributesResolver(string id)
            {
                this.Id = id;
            }

            protected override IList<JsonProperty> CreateProperties(Type type, MemberSerialization memberSerialization)
            {
                this.NamingStrategy = new CamelCaseNamingStrategy();
                IList<JsonProperty> props = base.CreateProperties(type, memberSerialization);
                foreach (var prop in props)
                {
                    string[] ignorePropertys = { "ColumnValue", "DataValue", "DataDB", "DataSortSql" };
                    if (string.IsNullOrWhiteSpace(this.Id) && ignorePropertys.Contains(prop.UnderlyingName))
                    {
                        prop.Ignored = true;
                    }
                }
                return props;
            }
        }
    }
}
